/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.utils.ResourceBundleControl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ResourceBundleLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleLoader.class);
    private HashMap<String, URLClassLoader> cache = new HashMap();

    private URLClassLoader createURLClassLoader(String rootFolderPath) {
        URLClassLoader urlClassLoader = null;
        try {
            URL[] urls = new URL[]{new File(rootFolderPath).toURI().toURL()};
            urlClassLoader = new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            LOGGER.error("ResourceBundleLoader::getURLClassLoader unable to create urlClassLoader for " + rootFolderPath, (Throwable)e);
        }
        return urlClassLoader;
    }

    private URLClassLoader getURLClassLoader(String rootFolderPath) {
        if (this.cache.containsKey(rootFolderPath)) {
            return this.cache.get(rootFolderPath);
        }
        URLClassLoader urlClassLoader = this.createURLClassLoader(rootFolderPath);
        this.cache.put(rootFolderPath, urlClassLoader);
        return urlClassLoader;
    }

    public ResourceBundle load(String rootFolderPath, String bundlePath, Locale locale) throws MissingResourceException {
        return this.load(rootFolderPath, bundlePath, locale, false);
    }

    public ResourceBundle load(String rootFolderPath, String bundlePath, Locale locale, boolean disableCache) throws MissingResourceException {
        URLClassLoader urlClassLoader = this.getURLClassLoader(rootFolderPath);
        if (urlClassLoader == null) {
            return null;
        }
        return ResourceBundle.getBundle(bundlePath, locale, urlClassLoader, new ResourceBundleControl(disableCache));
    }
}

