/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.exception.JSONFormatException;
import com.ibm.ba.glass.resource.Constants;
import com.ibm.ba.glass.utils.GlassCommonMessageKeys;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;

public class SpecUtils {
    private static final String EXTENSIONS = "extensions";
    private static final String KEY_FEATURES = "features";

    public static JsonObject parseSpecString(String specStr) throws InvalidInputException {
        try {
            return JsonObject.parseString((String)specStr, (boolean)true);
        }
        catch (IOException e) {
            throw new JSONFormatException(GlassCommonMessageKeys.ERROR_PARSING_JSON, "spec.json", e);
        }
    }

    public static ArrayList<String> parseUrlsFromSpec(JsonObject spec) {
        JsonArray extensions = spec.getArray(EXTENSIONS);
        ArrayList<String> urls = new ArrayList<String>();
        if (extensions != null) {
            for (Object object : extensions) {
                ArrayList<String> extensionUrls = SpecUtils.processExtension((JsonObject)object);
                if (extensionUrls.isEmpty()) continue;
                urls.addAll(extensionUrls);
            }
        }
        return urls;
    }

    private static ArrayList<String> processExtension(JsonObject extension) {
        JsonArray jsonFeatures = extension.getArray(KEY_FEATURES);
        ArrayList<String> urls = new ArrayList<String>();
        if (jsonFeatures != null) {
            for (Object object : jsonFeatures) {
                ArrayList<String> featureUrls = SpecUtils.processFeature((JsonObject)object);
                if (featureUrls.isEmpty()) continue;
                urls.addAll(featureUrls);
            }
        }
        return urls;
    }

    private static ArrayList<String> processFeature(JsonObject feature) {
        ArrayList<String> urls = new ArrayList<String>();
        if (feature != null) {
            for (String key : Constants.featureKeys) {
                JsonArray featureArray = feature.getArray(key);
                ArrayList<String> arrayUrls = SpecUtils.processArray(featureArray);
                if (arrayUrls.isEmpty()) continue;
                urls.addAll(arrayUrls);
            }
        }
        return urls;
    }

    private static ArrayList<String> processArray(JsonArray array) {
        ArrayList<String> urls = new ArrayList<String>();
        if (array != null) {
            for (Object object : array) {
                if (object instanceof JsonObject) {
                    ArrayList<String> valueUrls = SpecUtils.processValue((JsonObject)object);
                    if (valueUrls == null) continue;
                    urls.addAll(valueUrls);
                    continue;
                }
                if (!(object instanceof JsonArray)) continue;
                return SpecUtils.processArray((JsonArray)object);
            }
        }
        return urls;
    }

    private static ArrayList<String> processValue(JsonObject object) {
        ArrayList<String> urls = new ArrayList<String>();
        if (object != null) {
            for (Object key : object.keySet()) {
                Object value = object.get(key);
                if (value instanceof String) {
                    String url = SpecUtils.getUrl(key.toString(), value.toString());
                    if (url == null) continue;
                    urls.add(url);
                    continue;
                }
                if (value instanceof JsonObject) {
                    return SpecUtils.processValue((JsonObject)value);
                }
                if (!(value instanceof JsonArray)) continue;
                return SpecUtils.processArray((JsonArray)value);
            }
        }
        return urls;
    }

    private static String getUrl(String key, String value) {
        if ("url".equals(key)) {
            return value;
        }
        return null;
    }
}

