/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.utils.DeviceType;

public class UserAgentType {
    private static final UserAgentType INSTANCE = new UserAgentType();
    private static final String ANDROID = "android";
    private static final String iPAD = "ipad";
    private static final String iPOD = "ipod";
    private static final String iPHONE = "iphone";
    private static final String MOBILE = "mobile";
    private static final String PLAYBOOK = "playbook";
    private static final String BLACKBERRY = "blackberry";
    private static final String WINDOWS_PHONE = "windows phone";

    private UserAgentType() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Already instantiated");
        }
    }

    public static UserAgentType getInstance() {
        return INSTANCE;
    }

    public DeviceType getDeviceType(String userAgent) {
        boolean isIpod;
        boolean isPlayBook;
        boolean isBlackberry;
        boolean isWindowsPhone;
        boolean isAndroid;
        boolean isIpad;
        boolean isIphone;
        if (userAgent == null || userAgent.isEmpty()) {
            return DeviceType.desktop;
        }
        String agent = userAgent.toLowerCase();
        boolean bl = isIphone = agent.indexOf(iPHONE) >= 0;
        if (isIphone) {
            return DeviceType.phone;
        }
        boolean bl2 = isIpad = agent.indexOf(iPAD) >= 0;
        if (isIpad) {
            return DeviceType.tablet;
        }
        boolean bl3 = isAndroid = agent.indexOf(ANDROID) >= 0;
        if (isAndroid) {
            boolean isMobile = agent.indexOf(MOBILE) >= 0;
            return isMobile ? DeviceType.phone : DeviceType.tablet;
        }
        boolean bl4 = isWindowsPhone = agent.indexOf(WINDOWS_PHONE) >= 0;
        if (isWindowsPhone) {
            return DeviceType.phone;
        }
        boolean bl5 = isBlackberry = agent.indexOf(BLACKBERRY) >= 0;
        if (isBlackberry) {
            return DeviceType.phone;
        }
        boolean bl6 = isPlayBook = agent.indexOf(PLAYBOOK) >= 0;
        if (isPlayBook) {
            return DeviceType.tablet;
        }
        boolean bl7 = isIpod = agent.indexOf(iPOD) >= 0;
        if (isIpod) {
            return DeviceType.phone;
        }
        return DeviceType.desktop;
    }
}

