/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.resource.ZippedFile;
import com.ibm.ba.glass.utils.ESException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHandler.class);

    public List<ZippedFile> getZippedFiles(InputStream zipStream) throws ESException {
        ArrayList<ZippedFile> files = new ArrayList<ZippedFile>();
        ZipInputStream is = this.getZipInputStream(zipStream);
        try {
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                ByteArrayOutputStream output = this.getEntityOutputStream(is);
                ZippedFile file = new ZippedFile(name, output);
                files.add(file);
            }
            Collections.sort(files);
        }
        catch (IOException e) {
            throw new ESException("Error extracting zip file.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close input stream.", (Throwable)e);
                }
            }
        }
        return files;
    }

    private ByteArrayOutputStream getEntityOutputStream(ZipInputStream is) throws IOException {
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int len = 0;
        while ((len = is.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        return os;
    }

    public byte[] zipDirectory(File fileToZip, String customization) throws ESException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            this.zipFiles(zos, fileToZip, "", customization);
        }
        catch (IOException ex) {
            LOGGER.error("Error occurred while zipping files", (Throwable)ex);
            throw new ESException(ex);
        }
        return baos.toByteArray();
    }

    private void zipFiles(ZipOutputStream zos, File fileToZip, String path, String customization) throws IOException {
        File[] filesInDir;
        for (File file : filesInDir = this.filterDirectory(fileToZip, customization)) {
            if (file.isDirectory()) {
                this.zipFiles(zos, file, path + file.getName() + File.separator, customization);
                continue;
            }
            if (file.getName().equals("palette.css")) continue;
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                byte[] buffer = new byte[2048];
                zos.putNextEntry(new ZipEntry(path + file.getName()));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    private File[] filterDirectory(File file, final String customization) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (customization.equals("extensions")) {
                    return !name.equals(".DS_Store");
                }
                return !name.equals("css") && !name.equals(".DS_Store");
            }
        });
    }

    public void extractToFileSystem(List<ZippedFile> zippedFiles, String rootFolder) throws ESException {
        String specFolder = null;
        for (ZippedFile zippedFile : zippedFiles) {
            if (!zippedFile.isSpecFile()) continue;
            specFolder = zippedFile.getParentFolder();
            break;
        }
        if (specFolder == null) {
            throw new ESException("no spec file in the zip file");
        }
        for (ZippedFile file : zippedFiles) {
            String relativePath = file.getRelativePath(specFolder);
            if (relativePath == null || relativePath.isEmpty()) continue;
            StringBuilder fullPath = new StringBuilder().append(rootFolder).append(File.separator).append(relativePath);
            ByteArrayOutputStream os = file.getData();
            if (os == null) {
                throw new ESException("Invalid zip file, no data.");
            }
            if (os.size() == 0) {
                this.createDirectory(fullPath.toString());
                continue;
            }
            this.extractToFile(os, fullPath.toString());
        }
    }

    private void createDirectory(String path) {
        File dir = this.getFile(path);
        dir.mkdirs();
    }

    private void createParentDirectories(File file) {
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
    }

    private void extractToFile(ByteArrayOutputStream os, String filePath) throws ESException {
        File file = this.getFile(filePath);
        this.createParentDirectories(file);
        OutputStream fos = null;
        try {
            file.createNewFile();
            fos = this.getFileOutputStream(file);
            os.writeTo(fos);
        }
        catch (IOException e) {
            throw new ESException("Error writing to file: " + filePath, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close output stream.", (Throwable)e);
                }
            }
        }
    }

    protected ZipInputStream getZipInputStream(InputStream zipStream) {
        return new ZipInputStream(zipStream);
    }

    protected File getFile(String path) {
        return new File(path);
    }

    protected OutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }
}

