/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.exception.JSONFormatException;
import com.ibm.ba.glass.resource.ZippedFile;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.GlassCommonMessageKeys;
import com.ibm.ba.glass.utils.SpecUtils;
import com.ibm.ba.glass.validation.JsonSchemaValidationException;
import com.ibm.ba.glass.validation.JsonSchemaValidator;
import com.ibm.bi.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ZippedSpecUtils {
    public static JsonObject getSpecFromZip(List<ZippedFile> zippedFiles, String validationSchema) throws ESException, InvalidInputException {
        JsonObject jsonSpec = null;
        for (ZippedFile file : zippedFiles) {
            if (!file.isSpecFile()) continue;
            if (jsonSpec != null) {
                throw new ESException("Duplicate specification file: " + file.getName());
            }
            ByteArrayOutputStream os = file.getData();
            try {
                String specStr = os.toString("UTF-8");
                if (!ZippedSpecUtils.validateSpec(specStr, validationSchema)) {
                    throw new ESException("Invalid JSON spec provided.");
                }
                jsonSpec = SpecUtils.parseSpecString(specStr);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidInputException(e);
            }
        }
        if (jsonSpec == null) {
            throw new ESException("Missing specification file 'spec.json'.");
        }
        if (jsonSpec.getString("name") == null) {
            throw new ESException("Missing specification name.");
        }
        return jsonSpec;
    }

    private static boolean validateSpec(String specStr, String validationSchema) throws JSONFormatException {
        if (validationSchema != null) {
            try {
                JsonSchemaValidator validator = new JsonSchemaValidator();
                return validator.validate(validationSchema, specStr);
            }
            catch (JsonSchemaValidationException e) {
                throw new JSONFormatException(GlassCommonMessageKeys.ERROR_PARSING_JSON, "spec.json", e);
            }
        }
        return true;
    }
}

