/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.config.compat;

import com.ibm.bi.logging.glug.config.compat.IPFConfigFile;
import com.ibm.bi.logging.glug.config.compat.LoggingTopic;
import com.ibm.bi.logging.glug.internal.GsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinTopicLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(BuiltinTopicLibrary.class);
    private static final String RESPATH = "/com/ibm/bi/logging/glug/compat";
    private static final String LISTFILE = "/000list.txt";
    private static final String JSONLISTFILE = "/001list.txt";
    private List<String> topics = new ArrayList<String>();

    public List<String> getTopics() {
        return Collections.unmodifiableList(this.topics);
    }

    public void init() {
        Matcher m;
        Throwable throwable;
        InputStream is;
        Pattern pattern = Pattern.compile("ipf(.+)clientconfig\\.xml\\.sample");
        try {
            is = this.getClass().getResourceAsStream("/com/ibm/bi/logging/glug/compat/000list.txt");
            throwable = null;
            try {
                for (String file : IOUtils.readLines((InputStream)is)) {
                    m = pattern.matcher(file);
                    if (!m.matches()) continue;
                    this.topics.add(m.group(1));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException iox) {
            LOG.warn("failed to initialize ipf logging files", (Throwable)iox);
            throw new RuntimeException("failed to initialize ipf logging files", iox);
        }
        pattern = Pattern.compile("(.+)(\\.json)");
        try {
            is = this.getClass().getResourceAsStream("/com/ibm/bi/logging/glug/compat/001list.txt");
            throwable = null;
            try {
                for (String file : IOUtils.readLines((InputStream)is)) {
                    m = pattern.matcher(file);
                    if (!m.matches()) continue;
                    this.topics.add(m.group(1));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException iox) {
            LOG.warn("failed to initialize json builtin logging files", (Throwable)iox);
            throw new RuntimeException("failed to initialize json builtin logging files", iox);
        }
    }

    private IPFConfigFile openIPFConfigFile(String topicName) {
        String topicfilename = this.buildIPFTopicResourceName(topicName);
        LOG.debug("loading topic resource {}", (Object)topicfilename);
        return new IPFConfigFile(new InputStreamReader(this.getClass().getResourceAsStream(topicfilename)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoggingTopic getTopic(String topicName) {
        LOG.debug("builtinTopicLibrary: get topic name {}", (Object)topicName);
        if (!topicName.equalsIgnoreCase("DEFAULT")) {
            try (InputStreamReader rdr = new InputStreamReader(this.getClass().getResourceAsStream("/com/ibm/bi/logging/glug/compat/" + topicName + ".json"));){
                LoggingTopic throwable3 = LoggingTopic.makeWithLoggerDefs(topicName, ((LoggingTopic)GsonFactory.makeGson().fromJson((Reader)rdr, LoggingTopic.class)).getLoggerDefinitions());
                return throwable3;
            }
            catch (Exception x) {
                LOG.debug("Due to exception", (Throwable)x);
            }
        }
        try (IPFConfigFile ipfConfig = this.openIPFConfigFile(topicName);){
            ipfConfig.parse();
            LoggingTopic throwable7 = LoggingTopic.make(topicName, ipfConfig.getLoggers());
            return throwable7;
        }
        catch (Exception x) {
            LOG.debug("Due to exception", (Throwable)x);
            LOG.warn("failed to load logging topic {}", (Object)topicName);
            return null;
        }
    }

    private String buildIPFTopicResourceName(String name) {
        return String.format("%s/ipf%sclientconfig.xml.sample", RESPATH, name);
    }
}

