/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.ibm.bi.logging.glug.internal.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlugMessage {
    private static final Logger LOG = LoggerFactory.getLogger(GlugMessage.class);
    private final String messageKey;
    private final List<String> params;
    private final List<String> details = new ArrayList<String>();
    private final String format;
    private String renderedMessage;

    public GlugMessage(Messages message, String ... params) {
        this.messageKey = message.key;
        this.format = message.template;
        this.params = Arrays.asList(params);
        this.render();
    }

    public void addDetail(String detail) {
        this.details.add(detail);
        this.render();
    }

    private void render() {
        this.renderedMessage = this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(String.format(this.format, this.params.toArray()));
        }
        catch (Exception x) {
            LOG.warn("failed to render message, params likely don't match the format string", (Throwable)x);
            sb.append(this.format).append(StringUtils.join(this.params, (String)", "));
        }
        if (!this.details.isEmpty()) {
            sb.append(" Details: ").append(StringUtils.join(this.details, (String)", "));
        }
        return sb.toString();
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public List<String> getParams() {
        return this.params;
    }
}

