/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.ibm.bi.logging.glug.internal.LogEnabler;
import com.ibm.bi.logging.glug.internal.LogLevel;
import com.ibm.bi.logging.glug.internal.TopicType;
import java.lang.reflect.Type;

public class GsonFactory {
    static final String LEVEL = "level";
    static final String TOPICNAME = "topicName";
    static final String TOPICTYPE = "topicType";
    static final String LOGGERNAME = "loggerName";
    static final String ADDITIVITY = "additivity";
    private static JsonDeserializer<LogLevel> logLevelDeserializer = new JsonDeserializer<LogLevel>(){

        public LogLevel deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return LogLevel.forString(json.getAsString());
        }
    };
    private static JsonDeserializer<LogEnabler> logEnablerDeserializer = new JsonDeserializer<LogEnabler>(){

        public LogEnabler deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jo = json.getAsJsonObject();
            LogEnabler enabler = GsonFactory.asTopic(json, jo);
            if (enabler != null) {
                return enabler;
            }
            enabler = GsonFactory.asLogger(json, jo);
            if (enabler != null) {
                return enabler;
            }
            throw new JsonSyntaxException("Invalid LogEnabler: \"" + json + "\". Must have loggerName and level strings, or topicName. boolean additivity is optional");
        }
    };
    private static JsonSerializer<LogEnabler> logEnablerSerializer = new JsonSerializer<LogEnabler>(){

        public JsonElement serialize(LogEnabler logEnabler, Type type, JsonSerializationContext context) {
            JsonElement result = context.serialize((Object)logEnabler, LogEnablerSubclass.class);
            JsonObject jo = result.getAsJsonObject();
            if (jo.has(GsonFactory.TOPICTYPE)) {
                String topicType = jo.get(GsonFactory.TOPICTYPE).getAsString();
                if (TopicType.UNSPECIFIED.toString().equals(topicType)) {
                    jo.remove(GsonFactory.TOPICTYPE);
                }
            }
            return result;
        }
    };

    public static Gson makeGson() {
        GsonBuilder bldr = new GsonBuilder();
        bldr.registerTypeAdapter(LogLevel.class, logLevelDeserializer);
        bldr.registerTypeAdapter(LogEnabler.class, logEnablerDeserializer);
        bldr.registerTypeAdapter(LogEnabler.class, logEnablerSerializer);
        return bldr.create();
    }

    private static LogEnabler asLogger(JsonElement json, JsonObject jo) throws JsonSyntaxException {
        if (jo.has(LOGGERNAME) && jo.has(LEVEL)) {
            String name = jo.get(LOGGERNAME).getAsString();
            String level = jo.get(LEVEL).getAsString();
            LogLevel logLevel = LogLevel.forString(level);
            Boolean additivity = null;
            if (jo.has(ADDITIVITY)) {
                additivity = jo.get(ADDITIVITY).getAsBoolean();
            }
            return LogEnabler.makeLogger(name, logLevel, additivity);
        }
        return null;
    }

    private static LogEnabler asTopic(JsonElement json, JsonObject jo) throws JsonSyntaxException {
        if (jo.has(TOPICNAME)) {
            String ttype;
            TopicType topicType = TopicType.UNSPECIFIED;
            if (jo.has(TOPICTYPE) && !(topicType = TopicType.forString(ttype = jo.get(TOPICTYPE).getAsString())).isValidExternalType()) {
                throw new JsonSyntaxException("Invalid LogEnabler: \"" + json + "\". topicType " + ttype + " is invalid");
            }
            return LogEnabler.makeTopic(jo.get(TOPICNAME).getAsString(), topicType);
        }
        return null;
    }

    private static class LogEnablerSubclass
    extends LogEnabler {
        private LogEnablerSubclass() {
        }
    }
}

