/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.internal;

import com.google.gson.Gson;
import com.ibm.bi.logging.glug.internal.GlugMessage;
import com.ibm.bi.logging.glug.internal.GsonFactory;
import com.ibm.bi.logging.glug.internal.LogEnabler;
import com.ibm.bi.logging.glug.internal.LoggerDefinition;
import com.ibm.bi.logging.glug.internal.Messages;
import com.ibm.bi.logging.glug.internal.ValidationResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfiguration {
    private static Logger LOG = LoggerFactory.getLogger(LoggingConfiguration.class);
    private List<LogEnabler> logsEnabled = Collections.emptyList();
    private String sessionCustomTopic;
    private String startupCustomTopic;
    private String socketAppenderHostname = "localhost";
    private Meta meta = new Meta();
    public static final int SOCKET_APPENDER_PORT_DISABLED = -1;
    public static final String SOCKET_APPENDER_HOST_DEFAULT = "localhost";
    private Integer socketAppenderPort = -1;
    public static final String SOCKET_APPENDER_HOSTNAME_KEY = "socketAppenderHostname";
    public static final String SOCKET_APPENDER_PORT_KEY = "socketAppenderPort";

    public String getSocketAppenderHostname() {
        return this.socketAppenderHostname;
    }

    public Integer getSocketAppenderport() {
        return this.socketAppenderPort;
    }

    public List<LogEnabler> getEnabledLoggers() {
        return Collections.unmodifiableList(this.logsEnabled);
    }

    public String getSessionCustomTopic() {
        return this.sessionCustomTopic;
    }

    public String getStartupCustomTopic() {
        return this.startupCustomTopic;
    }

    public static LoggingConfiguration loadOrDefault(File jsonFile, Predicate<String> isValidTopicName) {
        try {
            Gson gson = GsonFactory.makeGson();
            LoggingConfiguration config = (LoggingConfiguration)gson.fromJson((Reader)new FileReader(jsonFile), LoggingConfiguration.class);
            if (config.sanitize(isValidTopicName)) {
                return config;
            }
            LOG.warn("invalid logging configuration, revert to defaults");
        }
        catch (FileNotFoundException e) {
            LOG.debug("logger config file not found. Will use defaults.");
        }
        catch (Exception e) {
            LOG.warn("failed to read or parse JSON logger definitions, reverting to defaults", (Throwable)e);
        }
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        loggingConfiguration.setupDefaultLogging();
        return loggingConfiguration;
    }

    public void setupDefaultLogging() {
        this.logsEnabled = Collections.emptyList();
        this.socketAppenderHostname = SOCKET_APPENDER_HOST_DEFAULT;
        this.socketAppenderPort = -1;
    }

    public Boolean isSocketAppenderEnabled() {
        return this.socketAppenderPort > 0;
    }

    Meta getMeta() {
        return this.meta;
    }

    public ValidationResult testValidity(Predicate<String> knownTopics) {
        ValidationResult result = new ValidationResult(true);
        if (CollectionUtils.isEmpty(this.logsEnabled)) {
            result.setOk(false);
            result.addMessage(new GlugMessage(Messages.TOPIC_READ_OR_PARSE_ERROR, "missing enabled topic"));
            return result;
        }
        HashSet dupeDetection = new HashSet();
        this.logsEnabled.stream().forEach(le -> {
            if (le == null) {
                result.setOk(false);
                result.addMessage(new GlugMessage(Messages.TOPIC_READ_OR_PARSE_ERROR, "missing topic name"));
                return;
            }
            if (le.isTopic()) {
                if (!knownTopics.test(le.getTopicName())) {
                    LOG.debug("error: unknown logging topic {}", le);
                    result.setOk(false);
                    result.addMessage(new GlugMessage(Messages.UNKNOWN_TOPIC, le.getTopicName()));
                }
            } else {
                LoggerDefinition.testValid(le, dupeDetection, result);
            }
        });
        return result;
    }

    public boolean sanitize(Predicate<String> knownTopics) {
        this.logsEnabled = this.logsEnabled.stream().filter(le -> {
            if (le == null) {
                return false;
            }
            if (le.isTopic()) {
                if (!knownTopics.test(le.getTopicName())) {
                    LOG.debug("prune unknown logging topic {}", le);
                    return false;
                }
            } else {
                ValidationResult result = new ValidationResult(true);
                if (!LoggerDefinition.testValid(le, result)) {
                    LOG.debug("prune invalid logger {} because {}", le, (Object)result);
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        return !this.logsEnabled.isEmpty();
    }

    static class Meta {
        String type = "glugLoggingConfiguration";
        String version = "0.0.1";

        Meta() {
        }
    }
}

