/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.flipper.auth;

import com.google.common.net.MediaType;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysAdminAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SysAdminAuthenticator.class);
    Supplier<RESTClientFactory> restClientFactorySupplier;

    SysAdminAuthenticator(Supplier<RESTClientFactory> restClientFactorySupplier) {
        this.restClientFactorySupplier = restClientFactorySupplier;
    }

    public SysAdminAuthenticator() {
        this.restClientFactorySupplier = () -> RESTClientFactory.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateUserIdentityAsSysAdmin(HttpServletRequest servletRequest) {
        boolean isSysAdmin = false;
        if (Boolean.getBoolean("ignore-user-identity")) {
            return true;
        }
        try (RESTClient client = this.restClientFactorySupplier.get().getClient(servletRequest);){
            JsonObject obj = client.getResource("/bi/v1/identity", MediaType.JSON_UTF_8.toString());
            if (obj == null) return isSysAdmin;
            boolean bl = SysAdminAuthenticator.isUserSysAdmin(obj);
            return bl;
        }
        catch (IOException e) {
            LOG.debug("Current user is not a System Administration. ", (Throwable)e);
            return false;
        }
    }

    static boolean isUserSysAdmin(JsonObject obj) {
        boolean isSysAdmin = false;
        try {
            Object o;
            JsonObject identity;
            JsonArray identityList = obj.getArray("data");
            Iterator iterator = identityList.iterator();
            while (iterator.hasNext() && !(isSysAdmin = SysAdminAuthenticator.isSysAdmin(identity = (JsonObject)(o = iterator.next())))) {
            }
        }
        catch (Exception e) {
            LOG.debug("the user is not system administrator", (Throwable)e);
            return false;
        }
        return isSysAdmin;
    }

    static boolean isSysAdmin(JsonObject identity) {
        if (identity != null) {
            String searchpath = identity.getString("searchPath");
            String type = identity.getString("type");
            if (searchpath != null && type != null && "CAMID(\"::System Administrators\")".equals(searchpath) && "role".equals(type)) {
                return true;
            }
        }
        return false;
    }
}

