/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local;

import com.ibm.neo.persist.ICatalog;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.local.IDocumentContainer;
import com.ibm.neo.persist.local.LocalDocumentDatabase;
import com.ibm.neo.persist.local.LocalPersistenceGateway;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class LocalCatalog
implements ICatalog {
    private final LocalPersistenceGateway mGateway;
    private final String mName;
    private final IDocumentContainer mRoot;
    private final ConcurrentHashMap<String, IDocumentDatabase> mName2Db = new ConcurrentHashMap();

    public LocalCatalog(LocalPersistenceGateway gateway, String name, IDocumentContainer root) {
        this.mGateway = gateway;
        this.mName = name;
        this.mRoot = root;
    }

    public LocalPersistenceGateway getGateway() {
        return this.mGateway;
    }

    public String getName() {
        return this.mName;
    }

    public boolean databaseExists(String databaseName) throws PersistenceException {
        return this.listDatabaseNames().contains(databaseName);
    }

    public List<String> listDatabaseNames() throws PersistenceException {
        ArrayList<String> dbNames = new ArrayList<String>();
        List<IDocumentContainer> dbs = this.mRoot.listChildContainers();
        for (IDocumentContainer c : dbs) {
            dbNames.add(c.getName());
        }
        return dbNames;
    }

    public IDocumentDatabase getDatabase(String databaseName) throws PersistenceException {
        IDocumentDatabase db = this.mName2Db.get(databaseName);
        if (null == db) {
            IDocumentContainer dbImpl = this.mRoot.getChildContainer(databaseName, true);
            db = new LocalDocumentDatabase(this, dbImpl);
            db.addDropListener(new IDropListener(){

                public void onDropped(Object o) {
                    IDocumentDatabase db = (IDocumentDatabase)o;
                    LocalCatalog.this.mName2Db.remove(db.getName(), db);
                }
            });
            IDocumentDatabase conflict = this.mName2Db.putIfAbsent(databaseName, db);
            if (null != conflict) {
                db = conflict;
            }
        }
        return db;
    }

    public void dropDatabase(String databaseName) throws PersistenceException {
        this.mName2Db.remove(databaseName);
        IDocumentContainer dbImpl = this.mRoot.getChildContainer(databaseName, false);
        if (null != dbImpl) {
            this.mRoot.deleteChildContainer(databaseName);
        }
    }
}

