/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local;

import com.ibm.neo.persist.AbstractDocumentCollection;
import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.EWriteConcern;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IPersistenceGateway;
import com.ibm.neo.persist.IndexInfo;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.FilteringCursor;
import com.ibm.neo.persist.cursor.IteratorBackedCursor;
import com.ibm.neo.persist.cursor.ProjectingCursor;
import com.ibm.neo.persist.cursor.RootCursor;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.local.IDocumentContainer;
import com.ibm.neo.persist.local.LocalDocumentDatabase;
import com.ibm.neo.persist.local.UniqueIndex;
import com.ibm.neo.persist.query.AggregationEvaluator;
import com.ibm.neo.persist.query.ProjectionEvaluator;
import com.ibm.neo.persist.update.UpdateEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalDocumentCollection
extends AbstractDocumentCollection {
    private final LocalDocumentDatabase mDB;
    private IDocumentContainer mCollectionImpl;
    private final ConcurrentHashMap<String, UniqueIndex> mName2UniqueIndex = new ConcurrentHashMap();

    public LocalDocumentCollection(LocalDocumentDatabase db, IDocumentContainer collectionImpl) {
        this.mDB = db;
        this.mCollectionImpl = collectionImpl;
    }

    public <T> T getCollectionImpl(Class<T> type) {
        this.ensureExists();
        return type.cast(this.mCollectionImpl);
    }

    public IPersistenceGateway getGateway() {
        return this.mDB.getGateway();
    }

    public IDocumentDatabase getDatabase() {
        return this.mDB;
    }

    public String getName() {
        return this.mCollectionImpl.getName();
    }

    public String getFullName() {
        return this.getDatabase().getName() + "/" + this.getName();
    }

    public List<IndexInfo> getIndexInfo() throws PersistenceException {
        ArrayList<IndexInfo> indexes = new ArrayList<IndexInfo>();
        indexes.add(new IndexInfo("_id_", new String[]{"_id"}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false, false, -1));
        for (UniqueIndex ui : this.mName2UniqueIndex.values()) {
            indexes.add(new IndexInfo(ui.getName(), ui.getKeys(), ui.getSortOrders(), false, false, false, -1));
        }
        return indexes;
    }

    public void ensureSortedIndex(String[] keys, ESortOrder[] sortOrders, boolean isUnique, boolean isSparse) throws PersistenceException {
        UniqueIndex index;
        if (isUnique && null == this.mName2UniqueIndex.putIfAbsent((index = new UniqueIndex(keys, sortOrders, isSparse)).getName(), index)) {
            this.rebuildIndexes();
        }
    }

    public void ensureHashedIndex(String key, boolean isUnique, boolean isSparse) throws PersistenceException {
    }

    public void ensureTTLIndex(String key, int expireAfterSeconds) throws PersistenceException {
    }

    public void dropIndex(String indexName) throws PersistenceException {
        this.mName2UniqueIndex.remove(indexName);
        this.rebuildIndexes();
    }

    public void dropIndexes() throws PersistenceException {
        this.mName2UniqueIndex.clear();
        this.rebuildIndexes();
    }

    public boolean isCapped() throws PersistenceException {
        return false;
    }

    public boolean supportsCursorOption(ECursorOption option) throws PersistenceException {
        return false;
    }

    public boolean supportsCursorMaxTime() throws PersistenceException {
        return false;
    }

    public boolean supportsAggregate() throws PersistenceException {
        return true;
    }

    public IONObject get(IONObjectId id, EReadPreference readPref) throws PersistenceException {
        this.ensureExists();
        return this.mCollectionImpl.getDocument(id);
    }

    public IONObject get(IONObjectId id, IONObject projection, EReadPreference readPref) throws PersistenceException {
        IONObject obj = this.get(id);
        return new ProjectionEvaluator(projection).project(obj);
    }

    public long count(EReadPreference readPref) throws PersistenceException {
        return LocalDocumentCollection._count(this.findAll());
    }

    public long count(IONObject query, EReadPreference readPref) throws PersistenceException {
        return LocalDocumentCollection._count(this.find(query));
    }

    private static long _count(ICursor<?> cur) throws PersistenceException {
        long counter = 0L;
        while (cur.hasNext()) {
            cur.next();
            ++counter;
        }
        return counter;
    }

    public ICursor<IONObject> find(IONObject query) throws PersistenceException {
        this.ensureExists();
        return new RootCursor((ICursor)new FilteringCursor((ICursor)new IteratorBackedCursor(this.mCollectionImpl.iterator()), query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONArray aggregate(List<IONObject> pipelines, EReadPreference readPref) throws PersistenceException {
        this.ensureExists();
        AggregationEvaluator evaluator = new AggregationEvaluator(pipelines);
        try (ICursor<IONObject> cursor = this.findAll();){
            IONArray iONArray = evaluator.aggregate(cursor);
            return iONArray;
        }
    }

    public ICursor<IONObject> find(IONObject query, IONObject projection) throws PersistenceException {
        this.ensureExists();
        return new RootCursor((ICursor)new ProjectingCursor((ICursor)new FilteringCursor((ICursor)new IteratorBackedCursor(this.mCollectionImpl.iterator()), query), projection));
    }

    public ICursor<IONObject> findAll() throws PersistenceException {
        this.ensureExists();
        return new RootCursor((ICursor)new IteratorBackedCursor(this.mCollectionImpl.iterator()));
    }

    public ICursor<IONObject> findAll(IONObject projection) throws PersistenceException {
        this.ensureExists();
        return new RootCursor((ICursor)new ProjectingCursor((ICursor)new IteratorBackedCursor(this.mCollectionImpl.iterator()), projection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONObject findOne(IONObject query, EReadPreference readPref) throws PersistenceException {
        try (ICursor cur = this.find(query).setReadPreference(readPref);){
            if (cur.hasNext()) {
                IONObject iONObject = (IONObject)cur.next();
                return iONObject;
            }
            IONObject iONObject = null;
            return iONObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONObject findOne(IONObject query, IONObject projection, EReadPreference readPref) throws PersistenceException {
        try (ICursor cur = this.find(query, projection).setReadPreference(readPref);){
            if (cur.hasNext()) {
                IONObject iONObject = (IONObject)cur.next();
                return iONObject;
            }
            IONObject iONObject = null;
            return iONObject;
        }
    }

    public boolean remove(IONObjectId id, EWriteConcern writeConcern) throws PersistenceException {
        this.ensureExists();
        this.removeIndexes(id);
        return this.mCollectionImpl.deleteDocument(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(IONObject query, EWriteConcern writeConcern) throws PersistenceException {
        try (ICursor<IONObject> cur = this.find(query);){
            int count = 0;
            while (cur.hasNext()) {
                IONObject obj = (IONObject)cur.next();
                this.removeIndexes(obj.getPrimaryId());
                this.mCollectionImpl.deleteDocument(obj.getPrimaryId());
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public void save(IONObject obj, EWriteConcern writeConcern) throws PersistenceException {
        this.ensureExists();
        if (null == obj.getPrimaryId()) {
            obj.setPrimaryId(this.generateId());
        }
        this.putIndexes(obj);
        this.mCollectionImpl.putDocument(obj, false);
    }

    public void insert(IONObject obj, EWriteConcern writeConcern) throws PersistenceException {
        this.ensureExists();
        if (null == obj.getPrimaryId()) {
            obj.setPrimaryId(this.generateId());
        }
        this.putIndexes(obj);
        if (!this.mCollectionImpl.putDocument(obj, true)) {
            throw new PersistenceException.DuplicateKey("Duplicate key", 0, null);
        }
    }

    public void insert(Collection<IONObject> col, EWriteConcern writeConcern) throws PersistenceException {
        this.ensureExists();
        for (IONObject obj : col) {
            this.insert(obj, writeConcern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(IONObject query, IONObject update, boolean upsert, boolean multi, EWriteConcern writeConcern) throws PersistenceException {
        UpdateEvaluator updater = new UpdateEvaluator(update);
        try (ICursor<IONObject> cur = this.find(query);){
            IONObject obj;
            int count = 0;
            while (cur.hasNext()) {
                obj = (IONObject)cur.next();
                if (updater.update(obj)) {
                    this.putIndexes(obj);
                    this.mCollectionImpl.putDocument(obj, false);
                }
                ++count;
                if (multi) continue;
                break;
            }
            if (0 == count && upsert) {
                obj = new IONObject();
                for (Map.Entry e : query.entrySet()) {
                    if (((String)e.getKey()).startsWith("$")) continue;
                    obj.put(e.getKey(), e.getValue());
                }
                updater.update(obj);
                this.putIndexes(obj);
                this.mCollectionImpl.putDocument(obj, true);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public int update(IONObjectId id, IONObject update, EWriteConcern writeConcern) throws PersistenceException {
        UpdateEvaluator updater = new UpdateEvaluator(update);
        IONObject obj = this.get(id);
        if (null != obj) {
            if (updater.update(obj)) {
                this.putIndexes(obj);
                this.mCollectionImpl.putDocument(obj, false);
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONObject findOneAndRemove(IONObject query, IONObject sort, IONObject projection) throws PersistenceException {
        try (ICursor cur = this.find(query);){
            if (null != sort) {
                cur = cur.sort(sort);
            }
            if (!cur.hasNext()) {
                IONObject iONObject = null;
                return iONObject;
            }
            IONObject obj = (IONObject)cur.next();
            if (null != obj) {
                this.remove(obj.getPrimaryId());
                if (null != projection) {
                    IONObject iONObject = new ProjectionEvaluator(projection).project(obj);
                    return iONObject;
                }
                IONObject iONObject = obj;
                return iONObject;
            }
            IONObject iONObject = null;
            return iONObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONObject findOneAndUpdate(IONObject query, IONObject sort, IONObject update, IONObject projection, boolean returnNew, boolean upsert) throws PersistenceException {
        UpdateEvaluator updater = new UpdateEvaluator(update);
        Object retObj = null;
        try (ICursor cur = this.find(query);){
            if (null != sort) {
                cur = cur.sort(sort);
            }
            IONObject obj = null;
            if (cur.hasNext()) {
                obj = (IONObject)cur.next();
            }
            if (null == obj) {
                if (upsert) {
                    IONObject newObj = new IONObject();
                    updater.update(newObj);
                    this.insert(newObj);
                    retObj = returnNew ? newObj : null;
                } else {
                    retObj = null;
                }
            } else {
                IONObject newObj = obj.duplicate();
                updater.update(newObj);
                this.save(newObj);
                retObj = returnNew ? newObj : obj;
            }
        }
        if (null != retObj && null != projection) {
            return new ProjectionEvaluator(projection).project(retObj);
        }
        return retObj;
    }

    public <T> List<T> distinct(String field, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        return this.distinct(new IONObject(), field, fieldType, readPref);
    }

    public <T> List<T> distinct(IONObject query, String field, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        LinkedHashSet<Object> distinctValues = new LinkedHashSet<Object>();
        ICursor cur = this.findAndProject(query, field, fieldType).setReadPreference(readPref);
        while (cur.hasNext()) {
            Object value = cur.next();
            if (null == value) continue;
            distinctValues.add(value);
        }
        return new ArrayList(distinctValues);
    }

    public void drop() throws PersistenceException {
        this.notifyDropped();
        this.mCollectionImpl.getParentContainer().deleteChildContainer(this.getName());
    }

    private void ensureExists() {
        this.mCollectionImpl = this.mCollectionImpl.getParentContainer().getChildContainer(this.getName(), true);
    }

    private void rebuildIndexes() throws PersistenceException {
        for (UniqueIndex index : this.mName2UniqueIndex.values()) {
            index.clear();
        }
        for (IONObject obj : this.mCollectionImpl.listDocuments()) {
            this.putIndexes(obj);
        }
    }

    private synchronized void putIndexes(IONObject obj) throws PersistenceException {
        for (UniqueIndex index : this.mName2UniqueIndex.values()) {
            if (index.testPut(obj)) continue;
            throw new PersistenceException.DuplicateKey("Duplicate key", 0, null);
        }
        for (UniqueIndex index : this.mName2UniqueIndex.values()) {
            index.put(obj);
        }
    }

    private synchronized void removeIndexes(IONObjectId id) {
        for (UniqueIndex index : this.mName2UniqueIndex.values()) {
            index.remove(id);
        }
    }

    private IONObjectId generateId() {
        LocalDocumentDatabase db = (LocalDocumentDatabase)this.getDatabase();
        return db.getGateway().generateId();
    }
}

