/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local;

import com.ibm.neo.persist.ICatalog;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.local.IDocumentContainer;
import com.ibm.neo.persist.local.LocalCatalog;
import com.ibm.neo.persist.local.LocalDocumentCollection;
import com.ibm.neo.persist.local.LocalPersistenceGateway;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.persist.nobject.NonPolymorphicNobjectCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LocalDocumentDatabase
implements IDocumentDatabase {
    private final LocalCatalog mCatalog;
    private IDocumentContainer mDBImpl;
    private final List<IDropListener> mDropListeners = new LinkedList<IDropListener>();
    private final ConcurrentHashMap<String, IDocumentCollection> mName2Col = new ConcurrentHashMap();

    public LocalDocumentDatabase(LocalCatalog catalog, IDocumentContainer dbImpl) {
        this.mCatalog = catalog;
        this.mDBImpl = dbImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDropListener(IDropListener listener) {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            this.mDropListeners.add(listener);
        }
    }

    public <T> T getDatabaseImpl(Class<T> type) {
        this.ensureExists();
        return type.cast(this.mDBImpl);
    }

    public LocalPersistenceGateway getGateway() {
        return this.mCatalog.getGateway();
    }

    public ICatalog getCatalog() {
        return this.mCatalog;
    }

    public String getName() {
        return this.mDBImpl.getName();
    }

    public boolean supportsCappedCollections() {
        return false;
    }

    public boolean collectionExists(String collectionName) throws PersistenceException {
        this.ensureExists();
        IDocumentContainer container = this.mDBImpl.getChildContainer(collectionName, false);
        return null != container;
    }

    public Set<String> getCollectionNames() throws PersistenceException {
        this.ensureExists();
        List<IDocumentContainer> containers = this.mDBImpl.listChildContainers();
        HashSet<String> collectionNames = new HashSet<String>(containers.size());
        for (IDocumentContainer c : containers) {
            collectionNames.add(c.getName());
        }
        return collectionNames;
    }

    public List<IDocumentCollection> listDocumentCollections() throws PersistenceException {
        this.ensureExists();
        List<IDocumentContainer> containers = this.mDBImpl.listChildContainers();
        ArrayList<IDocumentCollection> collections = new ArrayList<IDocumentCollection>(containers.size());
        for (IDocumentContainer c : containers) {
            collections.add(this.getDocumentCollection(c.getName()));
        }
        return collections;
    }

    public IDocumentCollection getDocumentCollection(String collectionName) throws PersistenceException {
        this.ensureExists();
        Object col = this.mName2Col.get(collectionName);
        if (null == col) {
            IDocumentContainer container = this.mDBImpl.getChildContainer(collectionName, true);
            col = new LocalDocumentCollection(this, container);
            col.addDropListener(new IDropListener(){

                public void onDropped(Object o) {
                    IDocumentCollection col = (IDocumentCollection)o;
                    LocalDocumentDatabase.this.mName2Col.remove(col.getName(), col);
                }
            });
            IDocumentCollection conflict = this.mName2Col.putIfAbsent(collectionName, (IDocumentCollection)col);
            if (null != conflict) {
                col = conflict;
            }
        }
        return col;
    }

    public IDocumentCollection getCappedDocumentCollection(String collectionName, int maxSizeInBytes, int maxDocuments) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<IFileBucket> listFileBuckets() throws PersistenceException {
        return new ArrayList<IFileBucket>();
    }

    public Set<String> getFileBucketNames() throws PersistenceException {
        return new HashSet<String>();
    }

    public IFileBucket getFileBucket(String bucketName) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    public <T extends Nobject> NobjectCollection<T> getNobjectCollection(String collectionName, Class<T> nobjectType) throws PersistenceException {
        return new NobjectCollection(this.getDocumentCollection(collectionName), nobjectType);
    }

    public <T extends Nobject> NobjectCollection<T> getNonPolymorphicNobjectCollection(String collectionName, Class<T> nobjectType) throws PersistenceException {
        return new NonPolymorphicNobjectCollection(this.getDocumentCollection(collectionName), nobjectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() throws PersistenceException {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            for (IDropListener listener : this.mDropListeners) {
                listener.onDropped((Object)this);
            }
        }
        this.mDBImpl.getParentContainer().deleteChildContainer(this.getName());
        this.mName2Col.clear();
    }

    private void ensureExists() {
        this.mDBImpl = this.mDBImpl.getParentContainer().getChildContainer(this.getName(), true);
    }
}

