/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local;

import com.ibm.neo.persist.ICatalog;
import com.ibm.neo.persist.IPersistenceGateway;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.local.IDocumentContainer;
import com.ibm.neo.persist.local.LocalCatalog;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.NullArgumentException;

public class LocalPersistenceGateway
implements IPersistenceGateway {
    private final LocalCatalog mDefaultCatalog;

    public LocalPersistenceGateway(IDocumentContainer root) {
        if (null == root) {
            throw new NullArgumentException("root");
        }
        this.mDefaultCatalog = new LocalCatalog(this, "_default", root);
    }

    public List<ICatalog> listCatalogs() throws PersistenceException {
        ArrayList<ICatalog> catalogs = new ArrayList<ICatalog>(1);
        catalogs.add(this.mDefaultCatalog);
        return catalogs;
    }

    public ICatalog getCatalogByName(String name) throws PersistenceException {
        if (this.mDefaultCatalog.getName().equals(name)) {
            return this.mDefaultCatalog;
        }
        return null;
    }

    public ICatalog getDefaultCatalog() throws PersistenceException {
        return this.mDefaultCatalog;
    }

    public ICatalog getTenantCatalog(String tenantId) throws PersistenceException {
        return this.mDefaultCatalog;
    }

    public IONObjectId generateId() {
        return new IONObjectId(UUID.randomUUID().toString());
    }

    public boolean validateId(IONObjectId id) {
        if (null == id) {
            return false;
        }
        return Pattern.matches("[0-9a-gA-G]+-[0-9a-gA-G]+-[0-9a-gA-G]+-[0-9a-gA-G]+-[0-9a-gA-G]+", id.getIdentifier());
    }

    public void dispose() {
    }
}

