/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local;

import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.query.FieldSelector;
import com.ibm.neo.util.ArrayKey;
import java.util.HashMap;
import java.util.Map;

public class UniqueIndex {
    private final String mName;
    private final String[] mKeys;
    private final ESortOrder[] mSortOrders;
    private final boolean mSparse;
    private final FieldSelector[] mKeySelectors;
    private final Map<ArrayKey, IONObjectId> mKeys2Id = new HashMap<ArrayKey, IONObjectId>();
    private final Map<IONObjectId, ArrayKey> mId2Keys = new HashMap<IONObjectId, ArrayKey>();

    public UniqueIndex(String[] keys, ESortOrder[] sortOrders, boolean isSparse) {
        this.mKeys = keys;
        this.mSortOrders = sortOrders;
        this.mSparse = isSparse;
        this.mKeySelectors = new FieldSelector[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.mKeySelectors[i] = new FieldSelector(keys[i]);
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (i > 0) {
                nameBuilder.append('_');
            }
            nameBuilder.append(this.mKeys[i]).append('_');
            if (ESortOrder.ASCENDING == this.mSortOrders[i]) {
                nameBuilder.append("1");
                continue;
            }
            nameBuilder.append("-1");
        }
        this.mName = nameBuilder.toString();
    }

    public String getName() {
        return this.mName;
    }

    public String[] getKeys() {
        return this.mKeys;
    }

    public ESortOrder[] getSortOrders() {
        return this.mSortOrders;
    }

    public boolean isSparse() {
        return this.mSparse;
    }

    public synchronized boolean testPut(IONObject obj) throws PersistenceException {
        IONObjectId id = obj.getPrimaryId();
        if (null == id) {
            throw new PersistenceException("_id was not set");
        }
        Object[] values = new Object[this.mKeySelectors.length];
        boolean nonEmpty = false;
        for (int i = 0; i < this.mKeySelectors.length; ++i) {
            values[i] = this.mKeySelectors[i].getFieldValue(obj);
            if (values[i] == null) continue;
            nonEmpty = true;
        }
        if (this.mSparse && !nonEmpty) {
            return true;
        }
        ArrayKey oldKeys = this.mId2Keys.get(id);
        ArrayKey newKeys = new ArrayKey(values);
        if (null != oldKeys && oldKeys.equals((Object)newKeys)) {
            return true;
        }
        return !this.mKeys2Id.containsKey(newKeys);
    }

    public synchronized void put(IONObject obj) throws PersistenceException {
        IONObjectId id = obj.getPrimaryId();
        if (null == id) {
            throw new PersistenceException("_id was not set");
        }
        Object[] values = new Object[this.mKeySelectors.length];
        boolean nonEmpty = false;
        for (int i = 0; i < this.mKeySelectors.length; ++i) {
            values[i] = this.mKeySelectors[i].getFieldValue(obj);
            if (values[i] == null) continue;
            nonEmpty = true;
        }
        if (this.mSparse && !nonEmpty) {
            return;
        }
        ArrayKey oldKeys = this.mId2Keys.get(id);
        ArrayKey newKeys = new ArrayKey(values);
        if (null != oldKeys && oldKeys.equals((Object)newKeys)) {
            return;
        }
        if (this.mKeys2Id.containsKey(newKeys)) {
            throw new PersistenceException.DuplicateKey("Duplicate key", 0, null);
        }
        this.mKeys2Id.put(newKeys, id);
        this.mId2Keys.put(id, newKeys);
        if (null != oldKeys) {
            this.mKeys2Id.remove(oldKeys);
        }
    }

    public synchronized void remove(IONObjectId id) {
        ArrayKey keys = this.mId2Keys.remove(id);
        if (null != keys) {
            this.mKeys2Id.remove(keys);
        }
    }

    public synchronized void clear() {
        this.mKeys2Id.clear();
        this.mId2Keys.clear();
    }
}

