/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local.fs;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.local.IDocumentContainer;
import com.ibm.neo.persist.local.fs.DirectoryFilter;
import com.ibm.neo.persist.local.fs.DocumentFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDocumentContainer
implements IDocumentContainer {
    private static final String DOT_JSON = ".json";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDocumentContainer.class);
    private final FileDocumentContainer mParent;
    private final ConcurrentMap<String, FileDocumentContainer> mChildren = new ConcurrentHashMap<String, FileDocumentContainer>();
    private final File mContainerDir;
    private final ReadWriteLock mRWLock = new ReentrantReadWriteLock();

    public FileDocumentContainer(File containerDir) {
        this(null, containerDir);
    }

    public FileDocumentContainer(FileDocumentContainer parent, File containerDir) {
        this.mParent = parent;
        this.mContainerDir = containerDir;
    }

    @Override
    public String getName() {
        return this.mContainerDir.getName();
    }

    @Override
    public IDocumentContainer getParentContainer() {
        return this.mParent;
    }

    @Override
    public Iterator<IONObject> iterator() {
        return new DocumentIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDocumentContainer> listChildContainers() {
        if (!this.mContainerDir.exists()) {
            return Collections.emptyList();
        }
        File[] files = null;
        this.mRWLock.readLock().lock();
        try {
            files = this.mContainerDir.listFiles(new DirectoryFilter());
            if (null == files || files.length == 0) {
                List<IDocumentContainer> list = Collections.emptyList();
                return list;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        ArrayList<IDocumentContainer> children = new ArrayList<IDocumentContainer>(files.length);
        for (File f : files) {
            children.add(this.getChildContainer(f.getName(), true));
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocumentContainer getChildContainer(String name, boolean create) {
        if (!create && !this.mContainerDir.exists()) {
            return null;
        }
        this.mRWLock.writeLock().lock();
        try {
            FileDocumentContainer old;
            FileDocumentContainer child;
            File childDir = new File(this.mContainerDir, name);
            if (!childDir.exists()) {
                if (create) {
                    try {
                        FileUtils.forceMkdir((File)childDir);
                    }
                    catch (IOException ex) {
                        if (!childDir.exists()) {
                            LOGGER.error("Failed to make directory: " + childDir.getPath(), (Throwable)ex);
                        }
                    }
                } else {
                    IDocumentContainer ex = null;
                    return ex;
                }
            }
            if (null == (child = (FileDocumentContainer)this.mChildren.get(name)) && null != (old = this.mChildren.putIfAbsent(name, child = new FileDocumentContainer(this, childDir)))) {
                child = old;
            }
            FileDocumentContainer fileDocumentContainer = child;
            return fileDocumentContainer;
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteChildContainer(String name) {
        this.mRWLock.writeLock().lock();
        try {
            this.mChildren.remove(name);
            File childDir = new File(this.mContainerDir, name);
            if (childDir.exists()) {
                try {
                    FileUtils.forceDelete((File)childDir);
                }
                catch (IOException ex) {
                    if (childDir.exists()) {
                        LOGGER.error("Failed to delete directory: " + childDir.getPath(), (Throwable)ex);
                    }
                }
            }
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    @Override
    public List<IONObject> listDocuments() {
        ArrayList<IONObject> docs = new ArrayList<IONObject>();
        CollectionUtils.addAll(docs, this.iterator());
        return docs;
    }

    @Override
    public IONObject getDocument(IONObjectId id) {
        if (!this.mContainerDir.exists()) {
            return null;
        }
        File docFile = this.getJSONFile(id);
        return this.loadDocument(docFile);
    }

    @Override
    public boolean putDocument(IONObject doc, boolean noClobber) {
        IONObjectId id = doc.getPrimaryId();
        if (null == id) {
            throw new IllegalArgumentException("doc has no primary id assigned");
        }
        this.ensureExists();
        File docFile = this.getJSONFile(id);
        if (noClobber && docFile.exists()) {
            return false;
        }
        this.storeDocument(docFile, doc);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDocument(IONObjectId id) {
        if (!this.mContainerDir.exists()) {
            return false;
        }
        this.mRWLock.writeLock().lock();
        try {
            File docFile = this.getJSONFile(id);
            boolean bl = docFile.delete();
            return bl;
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.getName()).append("dir", (Object)this.mContainerDir).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDocumentContainer)) {
            return false;
        }
        FileDocumentContainer other = (FileDocumentContainer)o;
        return new EqualsBuilder().append((Object)this.mParent, (Object)other.mParent).append((Object)this.mContainerDir, (Object)other.mContainerDir).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mParent).append((Object)this.mContainerDir).toHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExists() {
        this.mRWLock.writeLock().lock();
        try {
            if (!this.mContainerDir.exists()) {
                FileUtils.forceMkdir((File)this.mContainerDir);
            }
        }
        catch (IOException ex) {
            if (!this.mContainerDir.exists()) {
                LOGGER.error("Failed to create container directory: " + this.mContainerDir.getAbsolutePath(), (Throwable)ex);
                throw new RuntimeException("Failed to create container directory: " + this.mContainerDir.getAbsolutePath(), ex);
            }
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    private File getJSONFile(IONObjectId id) {
        if (null == id) {
            return null;
        }
        return new File(this.mContainerDir, id.getIdentifier() + DOT_JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IONObject loadDocument(File docFile) {
        if (null == docFile || !docFile.exists()) {
            return null;
        }
        this.mRWLock.readLock().lock();
        try {
            JSONObject json;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(docFile), "UTF-8");){
                json = JSONObject.parse((Reader)reader);
            }
            IONObject iONObject = IONHelper.toIONObject((JSONObject)json);
            return iONObject;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load document: " + docFile.getPath(), (Throwable)ex);
            IONObject iONObject = null;
            return iONObject;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDocument(File docFile, IONObject doc) {
        this.mRWLock.writeLock().lock();
        try {
            JSONObject json = (JSONObject)IONHelper.toJSON((Object)doc);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(docFile), "UTF-8");){
                json.serialize((Writer)writer);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to store document: " + docFile.getPath(), (Throwable)ex);
            throw new RuntimeException("Failed to store document: " + docFile, ex);
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    private final class DocumentIterator
    implements Iterator<IONObject> {
        private final File[] mDocFiles;
        private int mNextIndex = 0;
        private IONObject mNext;

        DocumentIterator() {
            File[] files = FileDocumentContainer.this.mContainerDir.listFiles(new DocumentFilter());
            this.mDocFiles = null == files ? new File[0] : files;
            this.fetchNext();
        }

        private void fetchNext() {
            this.mNext = null;
            while (null == this.mNext && this.mNextIndex < this.mDocFiles.length) {
                this.mNext = FileDocumentContainer.this.loadDocument(this.mDocFiles[this.mNextIndex++]);
            }
        }

        @Override
        public boolean hasNext() {
            return null != this.mNext;
        }

        @Override
        public IONObject next() {
            IONObject doc = this.mNext;
            this.fetchNext();
            return doc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

