/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.local.mem;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.local.IDocumentContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MemDocumentContainer
implements IDocumentContainer {
    private final IDocumentContainer mParent;
    private final String mName;
    private final ConcurrentMap<String, IDocumentContainer> mChildren = new ConcurrentHashMap<String, IDocumentContainer>();
    private final ConcurrentMap<IONObjectId, IONObject> mDocuments = new ConcurrentHashMap<IONObjectId, IONObject>();

    public MemDocumentContainer(String name) {
        this(null, name);
    }

    public MemDocumentContainer(IDocumentContainer parent, String name) {
        this.mParent = parent;
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public IDocumentContainer getParentContainer() {
        return this.mParent;
    }

    @Override
    public Iterator<IONObject> iterator() {
        return new DuplicatingIterator(this.mDocuments.values().iterator());
    }

    @Override
    public List<IDocumentContainer> listChildContainers() {
        return new ArrayList<IDocumentContainer>(this.mChildren.values());
    }

    @Override
    public IDocumentContainer getChildContainer(String name, boolean create) {
        IDocumentContainer child2;
        IDocumentContainer child = (IDocumentContainer)this.mChildren.get(name);
        if (null == child && create && null != (child2 = this.mChildren.putIfAbsent(name, child = new MemDocumentContainer(this, name)))) {
            child = child2;
        }
        return child;
    }

    @Override
    public void deleteChildContainer(String name) {
        this.mChildren.remove(name);
    }

    @Override
    public List<IONObject> listDocuments() {
        ArrayList<IONObject> list = new ArrayList<IONObject>(this.mDocuments.size());
        for (IONObject doc : this.mDocuments.values()) {
            list.add(doc.duplicate());
        }
        return list;
    }

    @Override
    public IONObject getDocument(IONObjectId id) {
        if (null == id) {
            return null;
        }
        IONObject doc = (IONObject)this.mDocuments.get(id);
        if (null == doc) {
            return null;
        }
        return doc.duplicate();
    }

    @Override
    public boolean putDocument(IONObject doc, boolean noClobber) {
        IONObjectId id = doc.getPrimaryId();
        if (null == id) {
            throw new IllegalArgumentException("doc has no primary id assigned");
        }
        if (noClobber) {
            return null == this.mDocuments.putIfAbsent(id, doc.duplicate());
        }
        this.mDocuments.put(id, doc.duplicate());
        return true;
    }

    @Override
    public boolean deleteDocument(IONObjectId id) {
        return null != this.mDocuments.remove(id);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemDocumentContainer)) {
            return false;
        }
        MemDocumentContainer other = (MemDocumentContainer)o;
        return new EqualsBuilder().append((Object)this.mParent, (Object)other.mParent).append((Object)this.mName, (Object)other.mName).append(this.mChildren, other.mChildren).append(this.mDocuments, other.mDocuments).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mParent).append((Object)this.mName).append(this.mChildren).append(this.mDocuments).toHashCode();
    }

    private static final class DuplicatingIterator
    implements Iterator<IONObject> {
        private final Iterator<IONObject> mSource;

        DuplicatingIterator(Iterator<IONObject> source) {
            this.mSource = source;
        }

        @Override
        public boolean hasNext() {
            return this.mSource.hasNext();
        }

        @Override
        public IONObject next() {
            IONObject doc = this.mSource.next();
            if (null == doc) {
                return null;
            }
            return doc.duplicate();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

