/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.api.model.EAggregateType;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.analyze.CellAnalyzer;
import com.ibm.neo.dataimport.analyze.HeaderRowAnalyzer;
import com.ibm.neo.dataimport.api.EImportFeatureFlag;
import com.ibm.neo.dataimport.api.EImportFeedbackCode;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.ImportSlipReader;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.dataimport.cdf.sheet.Sheet2JSONArray;
import com.ibm.neo.dataimport.deploy.DeployNodeBuilder;
import com.ibm.neo.dataimport.deploy.action.EDeployAction;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.DocumentMetadata;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.EDataTypeGroup;
import com.ibm.neo.dataimport.nodel.FormatHints;
import com.ibm.neo.dataimport.nodel.Grouping;
import com.ibm.neo.dataimport.nodel.MetadataItem;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.dataimport.util.AnalyzePluginHelper;
import com.ibm.neo.dataimport.util.AnalyzeUtils;
import com.ibm.neo.dataimport.util.DocumentModelHelper;
import com.ibm.neo.dataimport.util.ImportFeatureFlagHelper;
import com.ibm.neo.dataimport.util.ImportFeedbackParser;
import com.ibm.neo.dataimport.util.ImportQuotas;
import com.ibm.neo.dataimport.xtab.XSheet;
import com.ibm.neo.dataimport.xtab.format.TypeDetect;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.util.Assertions;
import com.ibm.neo.util.FrequencyCounter;
import com.ibm.neo.util.ops.CallableOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeDocumentOp
extends CallableOperation<AnalyzeResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeDocumentOp.class);
    private static final EnumSet<EDataType> ALL_TEMPORAL_TYPES = EnumSet.of(EDataType.DATE, EDataType.TIME, EDataType.TIMESTAMP);
    private static final EnumSet<EDataType> ALL_FLOAT_TYPES = EnumSet.of(EDataType.DECIMAL64, EDataType.FLOAT32, EDataType.FLOAT64);
    private static final EnumSet<EDataType> ALL_INTEGER_TYPES = EnumSet.of(EDataType.INT16, EDataType.INT32, EDataType.INT64, EDataType.INT8);
    public static final String ROW_ID = "__row_id__";
    private static final String PROP_ROW_SAMPLE_COUNT = "com.ibm.neo.dataimport.analyze.row-sample-count";
    private static final int DEFAULT_ROW_SAMPLE_COUNT = 2000;
    public static final String PROP_RETURN_ONE_DATASET = "com.ibm.neo.dataimport.analyze.return-one-dataset";
    private static final boolean DEFAULT_RETURN_ONE_DATASET = true;
    public static final String PROP_THROW_ON_SECTION_FAILURE = "com.ibm.neo.dataimport.analyze.throw-on-section-failure";
    private static final boolean DEFAULT_THROW_ON_SECTION_FAILURE = true;
    private final ImportService mImportService;
    private final CDFService mCDFService;
    private final DocumentDataSource mDataSource;
    private final DocumentModel mDocument;
    private final String mSheetName;
    private final AnalyzePluginHelper mPluginHelper;
    private ImportSlipReader mSlipReader;
    private final ImportQuotas mImportQuotas;
    private final Map<EImportFeedbackCode, Boolean> mFeedbackModeStates;
    private final Map<EImportFeatureFlag, Boolean> mImportFeatureFlags;
    private int mRowSampleCount;
    private boolean mReturnOneDataset;
    private boolean mThrowOnSectionFailure;

    public AnalyzeDocumentOp(ImportService importService, AccessControlService accessControlService, DocumentDataSource dataSource, IONObject importSlip) throws WAImportException {
        this.mImportService = importService;
        this.mCDFService = this.mImportService.getCDFService();
        this.mDataSource = dataSource;
        this.mDocument = this.mDataSource.getDocument();
        Assertions.assertNotNull((Object)this.mDocument, (String)"mDataSource.getDocument()");
        this.readConfiguration();
        this.mPluginHelper = new AnalyzePluginHelper(this.mImportService.getPluginManager()).withConfiguration(this.mImportService.getConfiguration()).withCDFService(this.mCDFService).withPersistenceService(PersistenceService.getInstance()).withDataSource((UserDataSource)this.mDataSource);
        this.addOperationObserver(this.mPluginHelper);
        if (null == importSlip) {
            importSlip = dataSource.getExtendedFields().getIONObject("import-slip");
        }
        this.mSlipReader = new ImportSlipReader(importSlip);
        this.mSheetName = this.mSlipReader.dataSource().getString("sheet-name", dataSource.getExtendedFields().getString("sheet-name"));
        this.mFeedbackModeStates = ImportFeedbackParser.determineFeedbackModes(this.mImportService.getConfiguration());
        this.mImportFeatureFlags = ImportFeatureFlagHelper.determineFeatureFlags();
        this.mImportQuotas = this.mImportService.getImportQuotas();
    }

    private void setTotalWork(List<DocumentSectionPair> sections) {
        for (DocumentSectionPair section : sections) {
            this.updateTotalWork(section.mSection);
        }
        if (this.getTotalWork() < 1L) {
            this.setTotalWork(1L);
        }
    }

    private void updateTotalWork(DocumentSection section) {
        for (DocumentSection child : section.getChildren()) {
            this.updateTotalWork(child);
        }
        if (null != section.getSheetInfo()) {
            this.setTotalWork(this.getTotalWork() + section.getSheetInfo().getRowExtent());
        }
    }

    private void readConfiguration() {
        Properties config = this.mImportService.getConfiguration();
        this.mRowSampleCount = config.containsKey(PROP_ROW_SAMPLE_COUNT) ? Integer.parseInt(config.getProperty(PROP_ROW_SAMPLE_COUNT)) : 2000;
        this.mReturnOneDataset = config.containsKey(PROP_RETURN_ONE_DATASET) ? Boolean.parseBoolean(config.getProperty(PROP_RETURN_ONE_DATASET)) : true;
        this.mThrowOnSectionFailure = config.containsKey(PROP_THROW_ON_SECTION_FAILURE) ? Boolean.parseBoolean(config.getProperty(PROP_THROW_ON_SECTION_FAILURE)) : true;
    }

    public DocumentDataSource getDataSource() {
        return this.mDataSource;
    }

    protected AnalyzeResult callImpl() throws Exception {
        try {
            return this.doAnalyzeDocument();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private AnalyzeResult doAnalyzeDocument() throws Exception {
        AnalyzeResult result = new AnalyzeResult((UserDataSource)this.mDataSource);
        List<DocumentSectionPair> sectionsToAnalyze = this.selectSectionsToAnalyze();
        LOGGER.info("Found {} sections in document to analyze", (Object)sectionsToAnalyze.size());
        int failedSections = 0;
        WAImportException firstEx = null;
        for (DocumentSectionPair sectionPair : sectionsToAnalyze) {
            Dataset dataset;
            block4: {
                dataset = null;
                try {
                    dataset = new SectionAnalyzer(sectionPair).analyze();
                }
                catch (WAImportException ex) {
                    if (this.mThrowOnSectionFailure || this.mReturnOneDataset) {
                        throw ex;
                    }
                    firstEx = failedSections++ == 0 ? ex : firstEx;
                    LOGGER.info("Failed to import document section: {}", (Object)sectionPair.mSection.toString());
                    if (sectionsToAnalyze.size() != failedSections) break block4;
                    throw firstEx;
                }
            }
            if (dataset == null) continue;
            result.getDatasets().add(dataset);
            this.mPluginHelper.datasetPlanned(dataset);
            this.mPluginHelper.withDatasets(result.getDatasets());
            this.setCompletedWork(this.getCompletedWork() + sectionPair.mSection.getSheetInfo().getRowExtent());
            if (!this.mReturnOneDataset) continue;
            break;
        }
        return result;
    }

    private List<DocumentSectionPair> selectSectionsToAnalyze() throws WAImportException {
        List<DocumentSection> sectionsWithSheets = DocumentModelHelper.getSectionsWithSheets(this.mDocument);
        ArrayList<DocumentSectionPair> sectionsToAnalyze = new ArrayList<DocumentSectionPair>();
        int sheetIndex = -1;
        List selectedSections = this.mSlipReader.dataSource().getSelectedSections();
        for (DocumentSection documentSection : sectionsWithSheets) {
            SheetInfo info;
            if (selectedSections != null && !selectedSections.contains(++sheetIndex) || (info = documentSection.getSheetInfo()).getColumnExtent() < 1 || info.getRowExtent() < 1L || this.mSheetName != null && !this.mSheetName.equals(documentSection.getName())) continue;
            sectionsToAnalyze.add(new DocumentSectionPair(sheetIndex, documentSection));
        }
        if (sectionsToAnalyze.isEmpty()) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.NO_NONEMPTY_DATASETS).build();
        }
        if (this.mReturnOneDataset && sectionsToAnalyze.size() > 1 && this.isFeedbackModeEnabled(EImportFeedbackCode.SELECT_SECTION_INDEXES)) {
            IONArray sheetsION = new IONArray(sectionsToAnalyze.size());
            for (DocumentSectionPair pair : sectionsToAnalyze) {
                sheetsION.add((Object)new IONObjectBuilder().put("index", (Object)pair.mIndex).put("name", (Object)pair.mSection.getName()).toDocument());
            }
            IONArray iONArray = new IONArray();
            iONArray.add((Object)0);
            throw this.getFeedbackExceptionBuilder(EImportFeedbackCode.SELECT_SECTION_INDEXES).withContextAttribute(EImportMessageContext.SELECTED_SECTIONS, (Object)iONArray.toJSONArtifact()).withContextAttribute(EImportMessageContext.SECTIONS, (Object)sheetsION.toJSONArtifact()).build();
        }
        this.setTotalWork(sectionsToAnalyze);
        return sectionsToAnalyze;
    }

    protected void cancelImpl() {
    }

    private boolean isFeedbackModeEnabled(EImportFeedbackCode code) {
        return Boolean.TRUE.equals(this.mFeedbackModeStates.get(code));
    }

    private WAImportException.Builder getFeedbackExceptionBuilder(EImportFeedbackCode feedbackCode) {
        return WAImportException.newBuilder().withConditionCode(EImportMessageCode.ANALYZE_FEEDBACK_NEEDED).withContextAttribute(EImportMessageContext.FEEDBACK_CODE, (Object)feedbackCode.toString()).withContextAttribute(EImportMessageContext.DATA_SOURCE_NAME, (Object)this.mDataSource.getName());
    }

    private class SectionAnalyzer {
        private static final double EXTRA_15_PERCENT = 1.15;
        private static final float CURRENCY_DETECTION_RATIO = 0.5f;
        private static final float PERCENT_DETECTION_RATIO = 0.5f;
        private static final float FORMAT_PATTERN_DETECTION_RATIO = 0.5f;
        private final int mDatasetIndex;
        private final DocumentSection mSection;
        private CellAnalyzer mCellAnalyzer;
        private ImportSlipReader.ISDataset mSlipDataset;

        private SectionAnalyzer(DocumentSectionPair sectionPair) {
            String[] nullTokens;
            this.mDatasetIndex = sectionPair.mIndex;
            this.mSection = sectionPair.mSection;
            DocumentType documentType = AnalyzeDocumentOp.this.mCDFService.getDocumentType(AnalyzeDocumentOp.this.mDocument.getType());
            Assertions.assertFalse((boolean)documentType.isUnknown(), (String)"documentType.isUnknown()");
            List<String> nullPlaceholders = null != AnalyzeDocumentOp.this.mDataSource.getMetadata() ? (null != (nullTokens = AnalyzeDocumentOp.this.mDataSource.getMetadata().getNullTokens()) ? Arrays.asList(nullTokens) : AnalyzeDocumentOp.this.mImportService.getNullPlaceholders()) : AnalyzeDocumentOp.this.mImportService.getNullPlaceholders();
            this.mCellAnalyzer = new CellAnalyzer(documentType, nullPlaceholders);
            this.mSlipDataset = AnalyzeDocumentOp.this.mSlipReader.dataSource().getDataset(this.mDatasetIndex, this.mSection.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dataset analyze() throws WAImportException, IOException, NoSuchSheetException {
            LOGGER.info("Analyzing sheet of document section: {}", (Object)this.mSection.toString());
            SheetInfo sheetInfo = this.mSection.getSheetInfo();
            boolean xtabDetect = AnalyzeDocumentOp.this.mDataSource.getExtendedFields().getBoolean("xtab-detect", true);
            XSheet xsheet = new XSheet(AnalyzeDocumentOp.this.mCDFService.getSheetLibrary().load(sheetInfo.getSheetId()), AnalyzeDocumentOp.this.mRowSampleCount, !xtabDetect);
            Dataset dataset = new Dataset();
            this.addExtendedPropertiesFromSlip((Nobject)dataset, (ImportSlipReader.ISElement)AnalyzeDocumentOp.this.mSlipReader.dataSource().dataset());
            String datasetName = this.mSlipDataset.getName();
            if (StringUtils.isEmpty((String)datasetName)) {
                datasetName = AnalyzeDocumentOp.this.mImportService.getNamingStrategy().makeDatasetName(AnalyzeDocumentOp.this.mDataSource, this.mSection);
            }
            datasetName = AnalyzeUtils.cleanIdentifier(datasetName);
            dataset.setDataSourceId(AnalyzeDocumentOp.this.mDataSource.getId());
            dataset.setName(datasetName);
            dataset.setLabel(this.makeDatasetLabel());
            dataset.setCreatedTime(new Date());
            dataset.setModifiedTime(new Date());
            dataset.setLastAccessTime(new Date());
            DeploymentPlan plan = new DeploymentPlan();
            plan.setSheetInfo(xsheet.getSheetInfo());
            this.mergeCrosstabInfo(xsheet, plan);
            dataset.getPlans().add(plan);
            try (ICDFSheetReader sheetReader = xsheet.openReader();){
                long headerRowIndex;
                ICDFRowCursor cursor = sheetReader.cursor();
                if (this.mSlipDataset.containsKey((Object)"header-row-index")) {
                    headerRowIndex = this.mSlipDataset.getLong("header-row-index");
                    LOGGER.info("User chose header row index: {}", (Object)headerRowIndex);
                    cursor.position(headerRowIndex);
                } else {
                    if (!this.moveToNonEmptyRow(cursor)) {
                        throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.DATASET_NO_ROWS).build();
                    }
                    if (!this.isCrossTab(plan)) {
                        headerRowIndex = this.pickBestHeaderRow(cursor.getRowIndex(), sheetReader);
                        LOGGER.info("Picked best header row index: {}", (Object)headerRowIndex);
                        cursor.position(headerRowIndex);
                    }
                }
                plan.setFirstDataRow((int)cursor.getRowIndex() + 1);
                long expectedRowCount = xsheet.getRowCount() - (long)plan.getFirstDataRow();
                LOGGER.info("Sheet appears to have {} data rows", (Object)expectedRowCount);
                this.checkRowCount(expectedRowCount);
                dataset.setRowCount(expectedRowCount);
                List dataItems = dataset.getDataItems();
                ICDFRow headerRow = cursor.getRow();
                int numColumns = xsheet.getColumnCount();
                LOGGER.info("Sheet appears to have {} columns.", (Object)numColumns);
                DocumentMetadata documentMetadata = AnalyzeDocumentOp.this.mDataSource.getMetadata();
                ArrayList<MetadataItem> dataItemMetadata = new ArrayList<MetadataItem>();
                for (int i = 0; i < numColumns; ++i) {
                    if (xsheet.getMaxStringLength(i) == 0) {
                        LOGGER.info("Skipping column index {}, because it has no data", (Object)i);
                        continue;
                    }
                    MetadataItem metadataItem = this.getMetadataItemForColumn(documentMetadata, i);
                    dataItemMetadata.add(metadataItem);
                    DataItem dataItem = new DataItem();
                    dataItem.setSourceColumnIndex(i);
                    ImportSlipReader.ISDataItem isDataItem = this.getISItemByIndexOrId(headerRow, i);
                    ICDFCell headerCell = headerRow.getCellCount() > i ? headerRow.getCell(i) : null;
                    String name = this.resolveDataItemName(headerCell, metadataItem, isDataItem);
                    name = AnalyzeUtils.cleanIdentifier(name);
                    dataItem.setName(name);
                    if (isDataItem.getLabel() != null) {
                        dataItem.setLabel(isDataItem.getLabel());
                    }
                    dataItem.setMaxStringLength(xsheet.getMaxStringLength(i));
                    EDataType type = xsheet.getDataType(i);
                    if (EDataType.isIntegerType((EDataType)type)) {
                        type = EDataType.INT64;
                    } else if (type == EDataType.FLOAT32) {
                        type = EDataType.FLOAT64;
                    }
                    dataItem.setDataType(type);
                    this.addExtendedPropertiesFromSlip((Nobject)dataItem, (ImportSlipReader.ISElement)isDataItem);
                    dataItems.add(dataItem);
                    LOGGER.trace("Created data item for column index {}: {}", (Object)i, (Object)dataItem.toString());
                }
                this.checkColumnCount(dataItems);
                this.analyzeValues(plan, dataItems, cursor, expectedRowCount);
                Map<String, MetadataItem> overridesMap = this.buildOverridesMap(documentMetadata);
                this.mergeFormatHintsAndTypes(dataItems, dataItemMetadata, overridesMap);
                this.ensureHeadersAreClean(dataItems);
                DataItem rowId = new DataItem();
                rowId.setName(AnalyzeDocumentOp.ROW_ID);
                rowId.setDataType(EDataType.INT64);
                this.addExtendedPropertiesFromSlip((Nobject)rowId, (ImportSlipReader.ISElement)this.mSlipDataset.getItemForDataItem(rowId));
                dataItems.add(0, rowId);
                AnalyzeUtils.ensureHeadersAreUnique(dataItems, false);
                this.setOptionalFields(dataset, documentMetadata, overridesMap);
                this.buildPlan(dataItems, plan);
                LOGGER.trace("Final dataset after analysis:\n{}", (Object)dataset.toString());
                Dataset dataset2 = dataset;
                return dataset2;
            }
        }

        private String makeDatasetLabel() {
            DocumentType type = AnalyzeDocumentOp.this.mImportService.getCDFService().getDocumentType(AnalyzeDocumentOp.this.mDocument.getType());
            return AnalyzeDocumentOp.this.mImportService.getNamingStrategy().makeDatasetLabel(type, this.mSection);
        }

        private void checkRowCount(long numRows) throws WAImportException {
            if (numRows < 1L) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.DATASET_NO_ROWS).build();
            }
            AnalyzeDocumentOp.this.mImportQuotas.checkRowCount(numRows);
        }

        private void checkColumnCount(List<DataItem> dataItems) throws WAImportException {
            if (dataItems.size() < 1) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.DATASET_NO_COLUMNS).build();
            }
            AnalyzeDocumentOp.this.mImportQuotas.checkColumnCount(dataItems.size());
        }

        private MetadataItem getMetadataItemForColumn(DocumentMetadata documentMetadata, int columnIndex) {
            MetadataItem[] items;
            if (documentMetadata != null && (items = documentMetadata.getMetadataDataItems()) != null && items.length > columnIndex) {
                return items[columnIndex];
            }
            return null;
        }

        private boolean isCrossTab(DeploymentPlan plan) {
            return plan.getCrossTabInfo() != null && plan.getCrossTabInfo().isCrossTab();
        }

        private boolean moveToNonEmptyRow(ICDFRowCursor cursor) throws IOException {
            boolean foundRow = false;
            while (cursor.next()) {
                ICDFRow row = cursor.getRow();
                if (!this.hasNonNullCells(row)) continue;
                foundRow = true;
                break;
            }
            return foundRow;
        }

        private long pickBestHeaderRow(long startingIndex, ICDFSheetReader sheetReader) throws IOException, WAImportException {
            int sampleSize = 10;
            HeaderRowAnalyzer headerRowAnalyzer = new HeaderRowAnalyzer(this.mCellAnalyzer);
            headerRowAnalyzer.analyze(sheetReader, startingIndex, 10);
            long bestHeaderRowIndex = headerRowAnalyzer.getBestCandidateIndex();
            if (this.shouldPromptForHeader(bestHeaderRowIndex, startingIndex)) {
                ICDFSheet sheet = sheetReader.getSheet();
                WAImportException.Builder builder = AnalyzeDocumentOp.this.getFeedbackExceptionBuilder(EImportFeedbackCode.NEED_HEADER_ROW_INDEX);
                this.addSectionDetails(builder);
                JSONArray sample = Sheet2JSONArray.toJSONArray((ICDFSheet)sheet, (long)(startingIndex + 10L), (long)-1L);
                JSONArray decoratedSample = this.decorateSample(sample, startingIndex, headerRowAnalyzer);
                throw builder.withContextAttribute(EImportMessageContext.HEADER_ROW_INDEX, (Object)Math.max(startingIndex, bestHeaderRowIndex)).withContextAttribute(EImportMessageContext.INDEXED_ROW_SAMPLE, (Object)this.buildIndexedHeaderSample(decoratedSample, headerRowAnalyzer)).build();
            }
            return startingIndex;
        }

        private boolean shouldPromptForHeader(long candidateIndex, long startingIndex) {
            if (AnalyzeDocumentOp.this.isFeedbackModeEnabled(EImportFeedbackCode.NEED_HEADER_ROW_INDEX_DEBUG)) {
                return true;
            }
            return candidateIndex != startingIndex && AnalyzeDocumentOp.this.isFeedbackModeEnabled(EImportFeedbackCode.NEED_HEADER_ROW_INDEX);
        }

        private JSONArray buildIndexedHeaderSample(JSONArray sample, HeaderRowAnalyzer headerRowAnalyzer) {
            JSONArray array = new JSONArray();
            for (long candidateIndex : headerRowAnalyzer.getCandidateIndexes()) {
                if (candidateIndex >= (long)sample.size()) continue;
                JSONObject entry = new JSONObject();
                entry.put((Object)"index", (Object)candidateIndex);
                entry.put((Object)"row", sample.get((int)candidateIndex));
                array.add((Object)entry);
            }
            return array;
        }

        private JSONArray decorateSample(JSONArray sample, long startingIndex, HeaderRowAnalyzer headerRowAnalyzer) {
            if (AnalyzeDocumentOp.this.isFeedbackModeEnabled(EImportFeedbackCode.NEED_HEADER_ROW_INDEX_DEBUG)) {
                JSONArray newSample = new JSONArray();
                Iterator<Integer> scoreItr = headerRowAnalyzer.getScores().iterator();
                for (int index = 0; index < sample.size(); ++index) {
                    JSONArray row = new JSONArray();
                    if ((long)index < startingIndex) {
                        row.add((Object)"score:N/A");
                    } else {
                        row.add((Object)("score:" + scoreItr.next()));
                    }
                    row.addAll((Collection)((JSONArray)sample.get(index)));
                    newSample.add((Object)row);
                }
                return newSample;
            }
            return sample;
        }

        private ImportSlipReader.ISDataItem getISItemByIndexOrId(ICDFRow headerRow, int columnIndex) {
            ICDFCell headerCell;
            String headerString = null;
            if (headerRow.getCellCount() > columnIndex && (headerCell = headerRow.getCell(columnIndex)) != null) {
                headerString = headerCell.stringValue();
            }
            return this.mSlipDataset.getItem(columnIndex, headerString);
        }

        private void setOptionalFields(Dataset dataset, DocumentMetadata documentMetadata, Map<String, MetadataItem> overridesMap) {
            if (documentMetadata != null) {
                if (documentMetadata.getRelatedArtifacts() != null) {
                    dataset.getExtendedFields().put((Object)"related-artifacts", (Object)documentMetadata.getRelatedArtifacts());
                }
                if (documentMetadata.getGroupings() != null) {
                    for (Grouping grouping : documentMetadata.getGroupings()) {
                        dataset.addGrouping(grouping);
                    }
                }
                if (overridesMap != null) {
                    for (DataItem item : dataset.getDataItems()) {
                        MetadataItem override = overridesMap.get(item.getName());
                        if (override == null || override.getExtendedFields() == null) continue;
                        item.getExtendedFields().putAll((Map)override.getExtendedFields());
                    }
                }
            }
            if (this.mSlipDataset.getGroupings() != null) {
                for (Grouping grouping : this.mSlipDataset.getGroupings()) {
                    dataset.addGrouping(grouping);
                }
            }
        }

        private void addExtendedPropertiesFromSlip(Nobject nobject, ImportSlipReader.ISElement element) {
            IONObject isProperties = element.getExtendedFields();
            if (!isProperties.isEmpty()) {
                nobject.getExtendedFields().putAll((Map)isProperties);
            }
        }

        private String resolveDataItemName(ICDFCell headerCell, MetadataItem metadataItem, ImportSlipReader.ISDataItem isDataItem) {
            String name = isDataItem.getName();
            if (name != null) {
                return name;
            }
            if (metadataItem != null && (name = metadataItem.getName()) != null && (name = name.trim()).length() > 0) {
                return name;
            }
            name = AnalyzeUtils.formatHeaderLabel(headerCell);
            if (name != null) {
                name = name.trim();
            }
            return name;
        }

        private void mergeFormatHintsAndTypes(List<DataItem> dataItems, List<MetadataItem> metadataItems, Map<String, MetadataItem> overridesMap) {
            for (int i = 0; i < dataItems.size(); ++i) {
                MetadataItem overrideMetadataItem;
                MetadataItem metadataItem;
                DataItem dataItem = dataItems.get(i);
                if (metadataItems.size() > i && (metadataItem = metadataItems.get(i)) != null) {
                    if (metadataItem.getDataType() != null) {
                        dataItem.setDataType(metadataItem.getDataType());
                    }
                    this.mergeFormatingHints(dataItem, metadataItem);
                }
                if (overridesMap == null || (overrideMetadataItem = overridesMap.get(dataItem.getName())) == null || overrideMetadataItem.getDataType() == null) continue;
                dataItem.setDataType(overrideMetadataItem.getDataType());
            }
        }

        private Map<String, MetadataItem> buildOverridesMap(DocumentMetadata documentMetadata) {
            if (documentMetadata == null || documentMetadata.getDataOverrides() == null) {
                return null;
            }
            HashMap<String, MetadataItem> overridesMap = new HashMap<String, MetadataItem>();
            for (MetadataItem override : documentMetadata.getDataOverrides()) {
                MetadataItem result = overridesMap.put(override.getName(), override);
                assert (result == null);
            }
            return overridesMap;
        }

        private void mergeFormatingHints(DataItem dataItem, MetadataItem metadataItem) {
            if (metadataItem.getFormatHints() != null) {
                if (dataItem.getFormatHints() != null) {
                    FormatHints fh = new FormatHints(dataItem.getFormatHints());
                    fh.merge(metadataItem.getFormatHints());
                    dataItem.setFormatHints(fh);
                } else {
                    dataItem.setFormatHints(metadataItem.getFormatHints());
                }
            }
        }

        private void mergeCrosstabInfo(XSheet sheet, DeploymentPlan plan) {
            if (AnalyzeDocumentOp.this.mDataSource.getMetadata() != null && AnalyzeDocumentOp.this.mDataSource.getMetadata().getCrossTabInfo() != null) {
                plan.setCrossTabInfo(AnalyzeDocumentOp.this.mDataSource.getMetadata().getCrossTabInfo());
            } else {
                plan.setCrossTabInfo(sheet.getCrossTabInfo());
            }
        }

        private boolean hasNonNullCells(ICDFRow row) {
            return -1 != this.indexOfFirstNonNullCell(row);
        }

        private int indexOfFirstNonNullCell(ICDFRow row) {
            if (null == row) {
                return -1;
            }
            for (int i = 0; i < row.getCellCount(); ++i) {
                ICDFCell c = row.getCell(i);
                if (null == c || c.isNull()) continue;
                return i;
            }
            return -1;
        }

        private void ensureHeadersAreClean(List<DataItem> dataItems) {
            for (DataItem di : dataItems) {
                String name = di.getName();
                name = StringUtils.replaceChars((String)name, (String)"\n\r", null);
                di.setName(name);
            }
        }

        private void analyzeValues(DeploymentPlan plan, List<DataItem> dataItems, ICDFRowCursor cursor, long expectedRowCount) throws IOException {
            DocumentType docType = AnalyzeDocumentOp.this.mCDFService.getDocumentType(AnalyzeDocumentOp.this.mDocument.getType());
            Assertions.assertFalse((boolean)docType.isUnknown(), (String)"docType.isUnknown()");
            int numDataItems = dataItems.size();
            Object[] typeCounts = new FrequencyCounter[numDataItems];
            Object[] currencySymbolCounts = new FrequencyCounter[numDataItems];
            Object[] currencyCodeCounts = new FrequencyCounter[numDataItems];
            Object[] icuCounts = new FrequencyCounter[numDataItems];
            FrequencyCounter[] extraTypeCounts = new FrequencyCounter[numDataItems];
            FrequencyCounter[] dataItemCaptionCounts = new FrequencyCounter[numDataItems];
            int[] percentCounts = new int[numDataItems];
            int[] currencyCounts = new int[numDataItems];
            int[] maxGroupingSizes = new int[numDataItems];
            for (int i = 0; i < numDataItems; ++i) {
                typeCounts[i] = new FrequencyCounter();
                currencySymbolCounts[i] = new FrequencyCounter();
                currencyCodeCounts[i] = new FrequencyCounter();
                extraTypeCounts[i] = new FrequencyCounter();
                dataItemCaptionCounts[i] = new FrequencyCounter();
                icuCounts[i] = new FrequencyCounter();
            }
            boolean isCrossTab = plan.getCrossTabInfo().isCrossTab();
            int sampleCount = this.walkTheSample(isCrossTab, (FrequencyCounter<TypeDetect.eFactType>[])extraTypeCounts, (FrequencyCounter<String>[])dataItemCaptionCounts, dataItems, cursor, expectedRowCount, (FrequencyCounter<EDataType>[])typeCounts, (FrequencyCounter<String>[])currencySymbolCounts, (FrequencyCounter<String>[])currencyCodeCounts, (FrequencyCounter<String>[])icuCounts, percentCounts, currencyCounts, maxGroupingSizes);
            LOGGER.info("Walked {} sample rows and saw the following:\n- Types: {}\n- Currency symbols: {}\n- Currency codes: {}\n- ICU patterns: {}\n", new Object[]{sampleCount, Arrays.toString(typeCounts), Arrays.toString(currencySymbolCounts), Arrays.toString(currencyCodeCounts), Arrays.toString(icuCounts)});
            for (int i = 0; i < numDataItems; ++i) {
                DataItem di = dataItems.get(i);
                Object typeCounter = typeCounts[i];
                this.decideDataItemTypeAndFormatting((FrequencyCounter<String>[])currencySymbolCounts, (FrequencyCounter<String>[])currencyCodeCounts, (FrequencyCounter<String>[])icuCounts, percentCounts, currencyCounts, maxGroupingSizes, sampleCount, i, di, (FrequencyCounter<EDataType>)typeCounter);
                this.decideDataItemMaxStringLength(di, (FrequencyCounter<EDataType>)typeCounter);
                this.decideDataItemName(extraTypeCounts, dataItemCaptionCounts, i, di);
                this.decideDataItemAggregation(di);
            }
        }

        private void decideDataItemName(FrequencyCounter<TypeDetect.eFactType>[] extraTypeCounts, FrequencyCounter<String>[] dataItemCaptionCounts, int i, DataItem di) {
            if (di.getName() == null || di.getName().trim().length() == 0) {
                switch (di.getDataType()) {
                    case STRING: 
                    case CHAR: {
                        if (extraTypeCounts[i].mostFrequentItem() != null) {
                            di.setName(((TypeDetect.eFactType)((Object)extraTypeCounts[i].mostFrequentItem())).toString());
                            break;
                        }
                        di.setName("Text");
                        break;
                    }
                    case BOOLEAN: {
                        di.setName("Boolean");
                        break;
                    }
                    case INT8: 
                    case INT16: 
                    case INT32: 
                    case INT64: 
                    case FLOAT32: 
                    case FLOAT64: 
                    case DECIMAL64: {
                        di.setName("Number");
                        break;
                    }
                    case DATE: {
                        di.setName("Date");
                        break;
                    }
                    case TIME: {
                        di.setName("Time");
                        break;
                    }
                    case TIMESTAMP: {
                        di.setName("Timestamp");
                        break;
                    }
                    default: {
                        di.setName("Column");
                    }
                }
            }
        }

        private void decideDataItemMaxStringLength(DataItem di, FrequencyCounter<EDataType> typeCounter) {
            int maxStringLength = 1;
            ImportSlipReader.ISDataItem isDataItem = this.mSlipDataset.getItemForDataItem(di);
            if (di.getDataType() == EDataType.STRING) {
                maxStringLength = isDataItem.getMaxStringLength() > 0 ? isDataItem.getMaxStringLength() : Math.max(maxStringLength, di.getMaxStringLength());
            }
            for (EDataType t : typeCounter.items()) {
                if (EDataType.STRING == t) continue;
                maxStringLength = Math.max(maxStringLength, t.maxStringLength());
            }
            di.setMaxStringLength(maxStringLength);
        }

        private int walkTheSample(boolean isCrossTab, FrequencyCounter<TypeDetect.eFactType>[] extraTypeCounts, FrequencyCounter<String>[] dataItemCaptionCounts, List<DataItem> dataItems, ICDFRowCursor cursor, long maxRows, FrequencyCounter<EDataType>[] typeCounts, FrequencyCounter<String>[] currencySymbolCounts, FrequencyCounter<String>[] currencyCodeCounts, FrequencyCounter<String>[] icuCounts, int[] percentCounts, int[] currencyCounts, int[] maxGroupingSizes) throws IOException {
            ICDFRow row;
            TypeDetect td = new TypeDetect(Locale.US);
            Random rand = new Random(1L);
            int rowsSeen = 0;
            double sampleRate = 1.0;
            if (maxRows > (long)AnalyzeDocumentOp.this.mRowSampleCount && (sampleRate = (double)AnalyzeDocumentOp.this.mRowSampleCount / (double)Math.max(maxRows, 1L)) < 0.01) {
                sampleRate = 0.01;
            }
            while (rowsSeen < AnalyzeDocumentOp.this.mRowSampleCount && null != (row = this.nextSampleRow(cursor, sampleRate, maxRows, rand))) {
                ++rowsSeen;
                for (int i = 0; i < dataItems.size(); ++i) {
                    ICDFCell c;
                    Pair<EDataType, FormatHints> dataTypeAndHints;
                    DataItem dataItem = dataItems.get(i);
                    if (dataItem.getSourceColumnIndex() == -1 || dataItem.getSourceColumnIndex() >= row.getCellCount() || null == (dataTypeAndHints = this.mCellAnalyzer.guessTypeAndFormatting(c = row.getCell(dataItem.getSourceColumnIndex())))) continue;
                    EDataType dataType = (EDataType)dataTypeAndHints.getFirst();
                    FormatHints hints = (FormatHints)dataTypeAndHints.getSecond();
                    typeCounts[i].increment((Object)dataType);
                    if (hints.hasCurrency()) {
                        int n = i;
                        currencyCounts[n] = currencyCounts[n] + 1;
                        if (hints.getCurrencyCode() != null) {
                            currencyCodeCounts[i].increment((Object)hints.getCurrencyCode());
                        }
                        if (hints.getCurrencySymbol() != null) {
                            currencySymbolCounts[i].increment((Object)hints.getCurrencySymbol());
                        }
                    }
                    if (hints.getFormatPattern() != null) {
                        icuCounts[i].increment((Object)hints.getFormatPattern());
                    }
                    if (hints.hasPercent()) {
                        int n = i;
                        percentCounts[n] = percentCounts[n] + 1;
                    }
                    if (hints.getGroupingSize() > 0) {
                        maxGroupingSizes[i] = Math.max(maxGroupingSizes[i], hints.getGroupingSize());
                    }
                    if (c.getDataType() != EDataType.STRING) continue;
                    String value = c.stringValue();
                    if (isCrossTab && dataItem.getMaxStringLength() < value.length()) {
                        Double maxSize = (double)value.length() * 1.15;
                        dataItem.setMaxStringLength(maxSize.intValue());
                    }
                    if (dataItem.getName() != null && dataItem.getName().length() != 0 || value == null) continue;
                    TypeDetect.eFactType dF = td.detectFact(value);
                    if (dF != null) {
                        extraTypeCounts[i].increment((Object)dF);
                        continue;
                    }
                    dataItemCaptionCounts[i].increment((Object)value);
                }
            }
            return rowsSeen;
        }

        private ICDFRow nextSampleRow(ICDFRowCursor cursor, double sampleRate, long maxRows, Random rand) throws IOException {
            if (sampleRate <= 0.0 || sampleRate > 1.0) {
                throw new IllegalArgumentException("Invalid sample rate: " + sampleRate);
            }
            if (sampleRate == 1.0) {
                if (cursor.next()) {
                    return cursor.getRow();
                }
            } else {
                long pos = cursor.getRowIndex() + 1L;
                while (rand.nextDouble() > sampleRate) {
                    if (++pos < maxRows) continue;
                    pos = maxRows - 1L;
                    break;
                }
                if (cursor.position(pos)) {
                    return cursor.getRow();
                }
            }
            return null;
        }

        private void decideDataItemTypeAndFormatting(FrequencyCounter<String>[] currencySymbolCounts, FrequencyCounter<String>[] currencyCodeCounts, FrequencyCounter<String>[] icuCounts, int[] percentCounts, int[] currencyCounts, int[] maxGroupingSizes, int sampleCount, int i, DataItem di, FrequencyCounter<EDataType> typeCounter) {
            int totalCount = typeCounter.total();
            int temporalCount = typeCounter.frequency((Collection)ALL_TEMPORAL_TYPES);
            int integerCount = typeCounter.frequency((Collection)ALL_INTEGER_TYPES);
            int floatCount = typeCounter.frequency((Collection)ALL_FLOAT_TYPES);
            int numberCount = integerCount + floatCount;
            ImportSlip.ISDataType isDataType = this.mSlipDataset.getItemForDataItem(di).getDataType();
            if (isDataType != null) {
                EDataType eDataType = EDataType.STRING;
                switch (isDataType) {
                    case BOOLEAN: {
                        eDataType = EDataType.STRING;
                        break;
                    }
                    case INTEGER: 
                    case INT8: 
                    case INT16: 
                    case INT32: 
                    case INT64: {
                        eDataType = EDataType.INT64;
                        break;
                    }
                    case NUMBER: 
                    case FLOAT32: 
                    case FLOAT64: 
                    case DECIMAL64: {
                        eDataType = EDataType.FLOAT64;
                        break;
                    }
                    case STRING: 
                    case CHAR: {
                        eDataType = EDataType.STRING;
                        break;
                    }
                    case DATE: {
                        eDataType = EDataType.DATE;
                        break;
                    }
                    case TIME: {
                        eDataType = EDataType.TIME;
                        break;
                    }
                    case TIMESTAMP: {
                        eDataType = EDataType.TIMESTAMP;
                        break;
                    }
                }
                LOGGER.info("Import slip sets data type ({}) for data item ({})", (Object)isDataType, (Object)di.getName());
                di.setDataType(eDataType);
            } else if (totalCount > 0) {
                if (temporalCount == totalCount) {
                    int dateCount = typeCounter.frequency((Object)EDataType.DATE);
                    int timestampCount = typeCounter.frequency((Object)EDataType.TIMESTAMP);
                    int timeCount = typeCounter.frequency((Object)EDataType.TIME);
                    if (timeCount > dateCount + timestampCount) {
                        di.setDataType(EDataType.TIME);
                    } else if (timestampCount > dateCount) {
                        di.setDataType(EDataType.TIMESTAMP);
                    } else {
                        di.setDataType(EDataType.DATE);
                    }
                } else if (numberCount == totalCount) {
                    if (floatCount > 0) {
                        di.setDataType(EDataType.FLOAT64);
                    } else {
                        di.setDataType(EDataType.INT64);
                    }
                } else {
                    di.setDataType(EDataType.STRING);
                }
            }
            FormatHints formatHints = this.resolveFormatHints(currencySymbolCounts, currencyCodeCounts, icuCounts, percentCounts, currencyCounts, maxGroupingSizes, totalCount, i);
            EnumSet<EDataTypeGroup> formattableTypes = EnumSet.of(EDataTypeGroup.NUMBER, EDataTypeGroup.DATE, EDataTypeGroup.TIME);
            if (formattableTypes.contains(EDataTypeGroup.getGroup((EDataType)di.getDataType()))) {
                di.setFormatHints(formatHints);
            }
        }

        private void decideDataItemAggregation(DataItem di) {
            ImportSlipReader.ISDataItem item = this.mSlipDataset.getItemForDataItem(di);
            String aggregate = item.getString("aggregate");
            if (StringUtils.isEmpty((String)aggregate)) {
                return;
            }
            for (EAggregateType v : EAggregateType.values()) {
                if (!StringUtils.equals((String)v.toString(), (String)aggregate)) continue;
                di.getExtendedFields().put((Object)"aggregate", (Object)aggregate);
                break;
            }
        }

        private FormatHints resolveFormatHints(FrequencyCounter<String>[] currencySymbolCounts, FrequencyCounter<String>[] currencyCodeCounts, FrequencyCounter<String>[] icuCounts, int[] percentCounts, int[] currencyCounts, int[] maxGroupingSizes, int totalCount, int columnIndex) {
            FormatHints hints = new FormatHints();
            if (totalCount > 0) {
                if ((float)icuCounts[columnIndex].total() / (float)totalCount > 0.5f) {
                    hints.setFormatPattern((String)icuCounts[columnIndex].mostFrequentItem());
                }
                if ((float)currencyCounts[columnIndex] / (float)totalCount > 0.5f) {
                    hints.setCurrency(true);
                    hints.setCurrencyCode((String)currencyCodeCounts[columnIndex].mostFrequentItem());
                    hints.setCurrencySymbol((String)currencySymbolCounts[columnIndex].mostFrequentItem());
                }
                if ((float)percentCounts[columnIndex] / (float)totalCount > 0.5f) {
                    hints.setPercent(true);
                }
            }
            if (maxGroupingSizes[columnIndex] > 0) {
                hints.setGroupingSize(maxGroupingSizes[columnIndex]);
            }
            return hints;
        }

        private void buildPlan(List<DataItem> dataItems, DeploymentPlan plan) {
            int tupleValueIndex = 0;
            for (DataItem item : dataItems) {
                DeployNodeBuilder builder = new DeployNodeBuilder();
                builder.push(EDeployAction.SetTupleValue.name(), tupleValueIndex);
                if (0 == tupleValueIndex) {
                    builder.push(EDeployAction.NextRowId.name(), new Object[0]);
                } else {
                    boolean deployAsLocalTz;
                    if (item.getDataType() == EDataType.STRING || item.getDataType() == EDataType.CHAR) {
                        builder.push(EDeployAction.TruncateString.name(), item.getMaxStringLength()).push(EDeployAction.CleanseString.name(), new Object[0]);
                    } else if (item.getDataType() == EDataType.TIMESTAMP && (deployAsLocalTz = item.getExtendedFields().getBoolean("deploy-as-local-tz", false))) {
                        builder.push(EDeployAction.DeployAsLocalTz.name(), new Object[0]);
                    }
                    int sourceColumnIndex = item.getSourceColumnIndex();
                    if (sourceColumnIndex == -1) {
                        sourceColumnIndex = tupleValueIndex - 1;
                    }
                    builder.push(EDeployAction.ReadCellValue.name(), sourceColumnIndex, item.getDataType().externalName(), IONHelper.toION((Object)item.getFormatHints()));
                }
                plan.addDeployNode(builder.build());
                ++tupleValueIndex;
            }
        }

        private void addSectionDetails(WAImportException.Builder builder) {
            builder.withContextAttribute(EImportMessageContext.DATASET_INDEX, (Object)this.mDatasetIndex);
            if (this.mSection.getParent() != null) {
                builder.withContextAttribute(EImportMessageContext.SECTION_NAME, (Object)this.mSection.getName());
            }
        }
    }

    private static class DocumentSectionPair {
        private final int mIndex;
        private final DocumentSection mSection;

        private DocumentSectionPair(int index, DocumentSection section) {
            this.mIndex = index;
            this.mSection = section;
        }
    }
}

