/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.AppendTableOp;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.RemoveDataSourceOp;
import com.ibm.neo.dataimport.ReplaceDocumentOp;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.ops.ReplaceDocumentResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.util.ImportQuotas;
import com.ibm.neo.dataimport.util.LockHelper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.util.ops.IProgress;
import com.ibm.neo.util.ops.ProgressAggregator;
import com.ibm.neo.util.ops.StaticProgressAggregator;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendDocumentOp
extends CallableOperation<ReplaceDocumentResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceDocumentOp.class);
    private static final long TOTAL_WORK = 100L;
    private static final double CLEANUP_WEIGHT = 0.014285714285714285;
    private static final double DEPLOY_WEIGHT = 0.12857142857142856;
    private static final IProgress COMPLETED_OP = new IProgress(){

        public long getTotalWork() {
            return 1L;
        }

        public long getCompletedWork() {
            return 1L;
        }

        public double getPercentCompleted() {
            return 100.0;
        }

        public void addProgressObserver(IObserver<IProgress> observer) {
            observer.updated((Object)this);
        }

        public void removeProgressObserver(IObserver<IProgress> observer) {
        }
    };
    private final ProgressAggregator mProgressAggregator;
    private final AccessControlService mACS;
    private final ImportService mImportService;
    private DocumentDataSource mDataSource;
    private final String mFilename;
    private final InputStream mContentStream;
    private final String mContentType;
    private final Long mContentSize;
    private final String mHashValue;
    private final IONObject mImportSlip;
    private final ImportQuotas mImportQuotas;
    private volatile IOperationWithResult<UploadDataSource> mUploadOp;
    private volatile IOperationWithResult<AnalyzeResult> mAnalyzeOp;
    private volatile IOperationWithResult<DeployResult> mDeployOp;

    public AppendDocumentOp(AccessControlService acs, ImportService importService, DocumentDataSource dataSource, String filename, InputStream contentStream, String contentType, Long contentSize, String hashValue, IONObject importSlip) {
        this.mACS = acs;
        this.mImportService = importService;
        this.mDataSource = dataSource;
        this.mFilename = filename;
        this.mContentStream = contentStream;
        this.mContentType = contentType;
        this.mContentSize = contentSize;
        this.mHashValue = hashValue;
        this.mImportSlip = importSlip;
        this.setTotalWork(100L);
        this.mProgressAggregator = new StaticProgressAggregator((IObserver)new IObserver<ProgressAggregator>(){

            public void updated(ProgressAggregator subject) {
                AppendDocumentOp.this.setCompletedWork((int)Math.ceil(subject.getPercentCompleted()));
            }
        }, 100.0);
        this.mImportQuotas = this.mImportService.getImportQuotas();
    }

    protected ReplaceDocumentResult callImpl() throws Exception {
        try {
            return this.doAppendDocument();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplaceDocumentResult doAppendDocument() throws Exception {
        PersistenceService ps = this.mImportService.getPersistenceService();
        WranglerService wrangler = this.mImportService.getWranglerService();
        DLock dataSourceLock = LockHelper.acquireDataSourceLock(wrangler, this.mDataSource.getId(), 120L);
        if (null == dataSourceLock) {
            LOGGER.error("Timed out waiting for data source lock (dataSourceId={})", (Object)this.mDataSource.getId().getIdentifier());
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.RESOURCE_BUSY).build();
        }
        try {
            NobjectCollection dataSourceCol = ImportPersistence.getUserDataSourceCollection((PersistenceService)ps);
            NobjectCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)ps);
            this.mDataSource = (DocumentDataSource)dataSourceCol.get(this.mDataSource.getId());
            if (null == this.mDataSource) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.DATA_SOURCE_MISSING).withMessage((IMessageKey)NeoImportError.DATA_REMOVED).build();
            }
            ReplaceDocumentResult replaceResult = new ReplaceDocumentResult((UserDataSource)this.mDataSource);
            List<Dataset> oldDatasets = this.mImportService.listDatasets(this.mDataSource.getId());
            if (oldDatasets.isEmpty()) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.DATASET_MISSING).withMessage((IMessageKey)NeoImportError.DATA_REMOVED).build();
            }
            UploadDataSource appendDS = this.upload();
            boolean appendDSRemoved = false;
            try {
                List<Dataset> newDatasets;
                IONObject importSlip = this.mDataSource.getExtendedFields().getIONObject("import-slip");
                try {
                    newDatasets = this.analyze((DocumentDataSource)appendDS, importSlip);
                }
                catch (WAImportException ex) {
                    if (ex.getCode() == EImportMessageCode.ANALYZE_FEEDBACK_NEEDED || ex.getCode() == EImportMessageCode.EMPTY_DATASET) {
                        throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.APPEND_INCONSISTENT_SHAPE).withMessage((IMessageKey)NeoImportError.APPEND_INCONSISTENT_SHAPE).withCause((Throwable)ex).build();
                    }
                    throw ex;
                }
                this.checkQuotasAndDatasetCompatibility(oldDatasets, newDatasets);
                this.mDataSource.getAppendedDocuments().add(appendDS.getDocument());
                appendDS.setDocument(null);
                this.mDataSource.setContentSize(this.mDataSource.getContentSize() + appendDS.getContentSize());
                this.mDataSource.setLastModifiedTime(new Date());
                ArrayList<Table> dropTargets = new ArrayList<Table>();
                HashMap<IONObjectId, ArrayList<Table>> dataset2AppendTargets = new HashMap<IONObjectId, ArrayList<Table>>();
                for (int i = 0; i < oldDatasets.size(); ++i) {
                    Dataset oldDataset = oldDatasets.get(i);
                    Dataset newDataset = newDatasets.get(i);
                    ArrayList<Table> appendTargets = new ArrayList<Table>();
                    this.triageDeployments(oldDataset, appendTargets, dropTargets);
                    dataset2AppendTargets.put(oldDataset.getId(), appendTargets);
                    DeploymentPlan newPlan = newDataset.getPlan();
                    oldDataset.getPlans().add(newPlan);
                    oldDataset.setVersion(oldDataset.getVersion() + 1);
                }
                for (Dataset dataset : oldDatasets) {
                    datasetCol.save((Nobject)dataset);
                }
                dataSourceCol.save((Nobject)this.mDataSource);
                dataSourceCol.save((Nobject)appendDS);
                this.removeDataSource(appendDS.getId());
                appendDSRemoved = true;
                double deployWeightPerDataset = 0.12857142857142856 / (double)oldDatasets.size();
                Exception firstException = null;
                for (Dataset dataset : oldDatasets) {
                    try {
                        List<DeployResult> deployments;
                        List appendTargets = (List)dataset2AppendTargets.get(dataset.getId());
                        boolean appendSuccess = false;
                        if (!appendTargets.isEmpty() && !(deployments = this.appendOrDrop(dataset, appendTargets, dropTargets, deployWeightPerDataset)).isEmpty()) {
                            replaceResult.getDeployments().addAll(deployments);
                            appendSuccess = true;
                        }
                        if (appendSuccess) continue;
                        DeployResult deployment = this.deploy(dataset, deployWeightPerDataset);
                        replaceResult.getDeployments().add(deployment);
                    }
                    catch (Exception ex) {
                        if (null == firstException) continue;
                        firstException = ex;
                    }
                }
                this.dropTables(dropTargets);
                this.mProgressAggregator.addSource(COMPLETED_OP, 0.014285714285714285);
            }
            finally {
                if (!appendDSRemoved) {
                    this.removeDataSource(appendDS.getId());
                }
            }
            ReplaceDocumentResult replaceDocumentResult = replaceResult;
            return replaceDocumentResult;
        }
        finally {
            dataSourceLock.release();
        }
    }

    private UploadDataSource upload() throws WAImportException {
        try {
            this.mUploadOp = this.mImportService.uploadDocument(this.mFilename, this.mContentType, this.mContentStream, this.mContentSize, this.mHashValue, this.mImportSlip);
            this.mProgressAggregator.addSource(this.mUploadOp, 0.5714285714285714);
            UploadDataSource uploadDataSource = (UploadDataSource)this.mUploadOp.joinWithResult();
            return uploadDataSource;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to upload document: " + this.mUploadOp, ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mUploadOp = null;
        }
    }

    private List<Dataset> analyze(DocumentDataSource dataSource, IONObject importSlip) throws WAImportException {
        this.mAnalyzeOp = this.mImportService.analyzeDataSource((UserDataSource)dataSource, importSlip);
        try {
            this.mProgressAggregator.addSource(this.mAnalyzeOp, 0.2857142857142857);
            List list = ((AnalyzeResult)this.mAnalyzeOp.joinWithResult()).getDatasets();
            return list;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to analyze data source: " + dataSource.getId(), ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mAnalyzeOp = null;
        }
    }

    private void checkQuotasAndDatasetCompatibility(List<Dataset> oldDatasets, List<Dataset> newDatasets) throws WAImportException {
        if (oldDatasets.size() != newDatasets.size()) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.REPLACE_INCONSISTENT_DATASET_COUNT).withMessage((IMessageKey)NeoImportError.INCONSISTENT_DATASET_COUNT, new Object[]{String.valueOf(oldDatasets.size()), String.valueOf(newDatasets.size())}).build();
        }
        for (int i = 0; i < oldDatasets.size(); ++i) {
            Dataset oldDataset = oldDatasets.get(i);
            Dataset newDataset = newDatasets.get(i);
            List oldDataItems = oldDataset.getDataItems();
            List newDataItems = newDataset.getDataItems();
            if (newDataItems.size() != oldDataItems.size()) {
                LOGGER.error("Failing due to incompatible number of data items. Expected {}, but found {}.", (Object)oldDataItems.size(), (Object)newDataItems.size());
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.APPEND_INCONSISTENT_SHAPE).withMessage((IMessageKey)NeoImportError.APPEND_INCONSISTENT_SHAPE).build();
            }
            for (int j = 0; j < oldDataItems.size(); ++j) {
                DataItem oldDataItem = (DataItem)oldDataItems.get(j);
                DataItem newDataItem = (DataItem)newDataItems.get(j);
                if (!oldDataItem.getName().equals(newDataItem.getName())) {
                    LOGGER.error("Failing due to incompatible name for data item at index {}. Expected '{}', but found '{}'.", new Object[]{j, oldDataItem.getName(), newDataItem.getName()});
                    throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.APPEND_INCONSISTENT_SHAPE).withMessage((IMessageKey)NeoImportError.APPEND_INCONSISTENT_SHAPE).build();
                }
                if (oldDataItem.getDataType() == newDataItem.getDataType()) continue;
                if (oldDataItem.getDataType() == EDataType.STRING) {
                    LOGGER.warn("Allowing inconsistent data item type at index {}. {} will be cast to {}.", new Object[]{j, newDataItem.getDataType(), oldDataItem.getDataType()});
                    continue;
                }
                if (oldDataItem.getDataType() == EDataType.FLOAT64 && EDataType.isIntegerType((EDataType)newDataItem.getDataType())) {
                    LOGGER.warn("Allowing inconsistent data item type at index {}. {} will be cast to {}.", new Object[]{j, newDataItem.getDataType(), oldDataItem.getDataType()});
                    continue;
                }
                LOGGER.error("Failing due to incompatible type for data item at index {}. Expected {}, but found {}.", new Object[]{j, oldDataItem.getDataType(), newDataItem.getDataType()});
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.APPEND_INCONSISTENT_SHAPE).withMessage((IMessageKey)NeoImportError.APPEND_INCONSISTENT_SHAPE).build();
            }
            this.mImportQuotas.checkRowCount(oldDataset.getRowCount() + newDataset.getRowCount());
        }
    }

    private void removeDataSource(IONObjectId dataSourceId) throws WAImportException {
        try {
            RemoveDataSourceOp op = new RemoveDataSourceOp(this.mImportService, dataSourceId, true, true, false, false, false);
            op.run();
            op.join();
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to remove data source: " + dataSourceId, ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
    }

    private List<DeployResult> appendOrDrop(Dataset dataset, List<Table> appendTargets, List<Table> dropTargets, double deployWeight) throws WAImportException {
        ArrayList<DeployResult> deployments = new ArrayList<DeployResult>();
        long firstRowId = dataset.getRowCount() + 1L;
        for (Table table : appendTargets) {
            try {
                Database database = this.mImportService.getStorageService().getDatabase(table.getDatabaseId());
                List plans = dataset.getPlans();
                this.mDeployOp = new AppendTableOp(this.mImportService, (UserDataSource)this.mDataSource, dataset, database, table, plans.subList(plans.size() - 1, plans.size()), firstRowId);
                this.mProgressAggregator.addSource(this.mDeployOp, deployWeight);
                DeployResult result = (DeployResult)((CallableOperation)this.mDeployOp).call();
                deployments.add(result);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to append table", (Throwable)ex);
                dropTargets.add(table);
            }
        }
        return deployments;
    }

    private DeployResult deploy(Dataset dataset, double deployWeight) throws WAImportException {
        try {
            this.mDeployOp = this.mImportService.deployDataset(dataset);
            this.mProgressAggregator.addSource(this.mDeployOp, deployWeight);
            DeployResult deployResult = (DeployResult)this.mDeployOp.joinWithResult();
            return deployResult;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to deploy dataset: " + dataset.getName(), ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mDeployOp = null;
        }
    }

    private void triageDeployments(Dataset dataset, List<Table> appendTargets, List<Table> dropTargets) throws WAStorageException, PersistenceException {
        StorageService storageService = this.mImportService.getStorageService();
        HashSet<IONObjectId> databaseIds = new HashSet<IONObjectId>();
        Tenant tenant = this.mACS.getCurrentTenant();
        String requiredDbPool = null != tenant.getDatabasePool() ? tenant.getDatabasePool() : "default";
        List tables = storageService.listTables(ACSHelper.getCurrentTenantId(), null, dataset.getId(), null, null, false, false);
        LOGGER.info("Found {} tables where dataset (_id={}) may be deployed to", (Object)tables.size(), (Object)dataset.getId().getIdentifier());
        dropTargets.addAll(tables);
        for (Table t : tables) {
            LOGGER.info("Inspecting table (_id={}, tableName={}, databaseId={})", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier()});
            if (t.getVersion() != dataset.getVersion()) {
                LOGGER.warn("Table (_id={}, tableName={}) has inconsistent version compared to dataset (name={}, _id={}) - expected {}, but was {}", new Object[]{t.getTableName(), t.getId().getIdentifier(), dataset.getName(), dataset.getId().getIdentifier(), dataset.getVersion(), t.getVersion()});
                continue;
            }
            if (databaseIds.contains(t.getDatabaseId())) {
                LOGGER.info("We already saw this databases - skipping it");
                continue;
            }
            Database db = null;
            try {
                db = storageService.getDatabase(t.getDatabaseId());
            }
            catch (WAStorageException.NoSuchObjectException ex) {
                LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}) that does not exist - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier()});
                continue;
            }
            if ("default".equals(requiredDbPool)) {
                if (db.getPool() != null && !"default".equals(db.getPool())) {
                    LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, pool={}), but tenant is associated with different pool ({}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getPool(), requiredDbPool});
                    continue;
                }
            } else if (!requiredDbPool.equals(db.getPool())) {
                LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, pool={}), but tenant is associated with different pool ({}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getPool(), requiredDbPool});
                continue;
            }
            if (db.isDisabled() || !storageService.checkDatabase(db)) {
                LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, url={}) that is disable or unreachable - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getJdbcUrl()});
                continue;
            }
            if (!storageService.checkTable(db, t.getSchemaName(), t.getTableName())) {
                LOGGER.warn("Table (_id={}, tableName={}) does not exist in database (_id={}, url={}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getJdbcUrl()});
                continue;
            }
            LOGGER.info("Table (_id={}, tableName={}) exists in database (_id={}, url={}) - we will append here!", new Object[]{t.getId().getIdentifier(), t.getTableName(), db.getId().getIdentifier(), db.getJdbcUrl()});
            databaseIds.add(db.getId());
            appendTargets.add(t);
            dropTargets.remove(t);
        }
    }

    private void dropTables(List<Table> tables) {
        StorageService storageService = this.mImportService.getStorageService();
        for (Table t : tables) {
            try {
                storageService.dropTable(t, 15);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to drop table", (Throwable)ex);
            }
        }
    }

    protected void cancelImpl() {
        IOperationWithResult<UploadDataSource> op = this.mUploadOp;
        if (null != op) {
            op.cancel();
        }
        if (null != (op = this.mAnalyzeOp)) {
            op.cancel();
        }
        if (null != (op = this.mDeployOp)) {
            op.cancel();
        }
    }
}

