/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.DatasetDeployer;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.StoragePersistence;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.util.DeployPluginHelper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IProgress;
import com.ibm.neo.util.ops.ProgressHelper;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendTableOp
extends CallableOperation<DeployResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendTableOp.class);
    private final ImportService mImportService;
    private final StorageService mStorageService;
    private final PersistenceService mPersistenceService;
    private final DatasetDeployer mDeployer;
    private final UserDataSource mDataSource;
    private final Dataset mDataset;
    private final Database mDatabase;
    private final Table mTable;
    private final List<DeploymentPlan> mPlans;
    private final long mFirstRowId;
    private NobjectCollection<Dataset> mDatasetCollection;
    private NobjectCollection<Table> mTableCollection;
    private DeployPluginHelper mPluginHelper;

    public AppendTableOp(ImportService importService, UserDataSource dataSource, Dataset dataset, Database database, Table table, List<DeploymentPlan> plans, long firstRowId) throws ImportException {
        if (null == importService) {
            throw new NullArgumentException("importService");
        }
        if (null == dataSource) {
            throw new NullArgumentException("dataSource");
        }
        if (null == dataset) {
            throw new NullArgumentException("dataset");
        }
        if (null == database) {
            throw new NullArgumentException("database");
        }
        if (null == table) {
            throw new NullArgumentException("table");
        }
        if (null == plans) {
            throw new NullArgumentException("plans");
        }
        this.mImportService = importService;
        this.mStorageService = this.mImportService.getStorageService();
        this.mPersistenceService = PersistenceService.getInstance();
        this.mDeployer = new DatasetDeployer(importService, this.mStorageService);
        this.mDataSource = dataSource;
        this.mDataset = dataset;
        this.mDatabase = database;
        this.mTable = table;
        this.mPlans = plans;
        this.mFirstRowId = firstRowId;
        this.mDeployer.setDataSource(this.mDataSource);
        this.mDeployer.setDataset(this.mDataset);
        this.mDeployer.setDatabase(this.mDatabase);
        this.mPluginHelper = new DeployPluginHelper(importService.getPluginManager()).withCDFService(importService.getCDFService()).withPersistenceService(this.mPersistenceService).withConfiguration(importService.getConfiguration()).withSampleProvider(importService.getSampleProvider()).withDataset(this.mDataset).withDataSource(this.mDataSource).withDatabase(this.mDatabase).withTable(this.mTable);
        this.setTotalWork(100L);
    }

    public UserDataSource getDataSource() {
        return this.mDataSource;
    }

    public Dataset getDataset() {
        return this.mDataset;
    }

    protected DeployResult callImpl() throws Exception {
        try {
            return this.doAppendTable();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private DeployResult doAppendTable() throws Exception {
        LOGGER.info("Appending rows to table (_id={}, name={}, db={}) for dataset (_id={}, name={})", new Object[]{this.mTable.getId().getIdentifier(), this.mTable.getTableName(), this.mDatabase.getJdbcUrl(), this.mDataset.getId().getIdentifier(), this.mDataset.getName()});
        this.mDatasetCollection = ImportPersistence.getDatasetCollection((PersistenceService)this.mPersistenceService);
        this.mTableCollection = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
        this.mPluginHelper.preDeploy();
        DeployResult result = new DeployResult(this.mDataSource, this.mDataset, this.mDatabase, true);
        result.setTable(this.mTable);
        try {
            if (this.isCanceled()) {
                throw new CancellationException();
            }
            try {
                this.appendRows();
                this.setCompletedWork(this.getTotalWork());
            }
            catch (WAStorageException ex) {
                LOGGER.error("Append failed", (Throwable)ex);
                throw ex;
            }
        }
        catch (Exception ex) {
            this.mPluginHelper.postDeploy(ex);
            throw ex;
        }
        this.mPluginHelper.postDeploy(null);
        return result;
    }

    private void appendRows() throws Exception {
        IONObjectId tenantId = ACSHelper.getCurrentTenantId();
        Map headers = ACSHelper.getCurrentHttpHeaders();
        Properties transactionIds = WatsonHeaders.getTransactionIds((Map)headers);
        this.mDeployer.setTenantId(tenantId);
        this.mDeployer.setTransactionIds(transactionIds);
        ProgressHelper loadProgress = new ProgressHelper();
        loadProgress.addProgressObserver((IObserver)new IObserver<IProgress>(){

            public void updated(IProgress subject) {
                AppendTableOp.this.setCompletedWork((int)Math.round(0.8 * subject.getPercentCompleted()));
            }
        });
        this.mDeployer.setFirstRowId(this.mFirstRowId);
        this.mStorageService.setTableInconsistentFlag(this.mTable, true);
        this.mDeployer.loadTableData(this.mTable, this.mPlans, true, loadProgress);
        this.mStorageService.setTableInconsistentFlag(this.mTable, false);
        this.setCompletedWork(80L);
        if (this.isCanceled()) {
            throw new CancellationException();
        }
        this.mDeployer.collectTableStats(this.mTable);
        this.setCompletedWork(90L);
        if (this.isCanceled()) {
            throw new CancellationException();
        }
        if (this.mDataset.getRowCount() == 0L) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.DATASET_EMPTY).build();
        }
        this.mPluginHelper.tableLoaded();
        Date now = new Date();
        this.mDataset.setModifiedTime(now);
        this.mDataset.setLastAccessTime(now);
        this.mTable.setCreatedTime(now);
        this.mTable.setLastAccessTime(now);
        this.mTable.setLastValidatedTime(now);
        this.mTable.setVersion(this.mDataset.getVersion());
        this.mDatasetCollection.save((Nobject)this.mDataset);
        this.mTableCollection.save((Nobject)this.mTable);
        this.setCompletedWork(100L);
    }

    protected void cancelImpl() {
        DatasetDeployer deployer = this.mDeployer;
        if (null != deployer) {
            deployer.cancel();
        }
    }
}

