/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.neo.dataimport.api.EImportFeedbackCode;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.ImportSlipReader;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.EDataTypeGroup;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnRemapHelper {
    private static final String OLD_COLUMNS = "old";
    private static final String NEW_COLUMNS = "new";
    private static final Logger LOG = LoggerFactory.getLogger(ColumnRemapHelper.class);
    private final Dataset mOldDataset;
    private final Dataset mNewDataset;
    private final ImportSlipReader.ISDataset mDatasetSlip;
    private final ImportSlip.UnmatchedColumnsMode mUnmatchedMode;
    private final Map<EImportFeedbackCode, Boolean> mFeedbackModes;

    public ColumnRemapHelper(Dataset oldDataset, Dataset newDataset, ImportSlip.UnmatchedColumnsMode unmatchedColumnsMode, ImportSlipReader.ISDataset datasetSlip, Map<EImportFeedbackCode, Boolean> feedbackModes) {
        this.mOldDataset = oldDataset;
        this.mNewDataset = newDataset;
        this.mDatasetSlip = datasetSlip;
        this.mUnmatchedMode = unmatchedColumnsMode;
        this.mFeedbackModes = feedbackModes;
    }

    public void apply() throws WAImportException {
        List remappedDataItems;
        if (!this.isEnabled(EImportFeedbackCode.REMAP_COLUMNS) && !this.isEnabled(EImportFeedbackCode.REMAP_COLUMNS_DEBUG)) {
            LOG.info("Column remapping is disabled.");
            return;
        }
        LOG.info(this.toString());
        Map<String, String> replacedColumnMap = Collections.emptyMap();
        if (this.mDatasetSlip != null && !(remappedDataItems = this.mDatasetSlip.getDataItemsWithField("replaces")).isEmpty()) {
            replacedColumnMap = this.remap(remappedDataItems);
        }
        if (EnumSet.of(ImportSlip.UnmatchedColumnsMode.ignore, ImportSlip.UnmatchedColumnsMode.drop, ImportSlip.UnmatchedColumnsMode.auto).contains(this.mUnmatchedMode)) {
            LOG.info("Column remap mode is {}. Not checking for missing column or changing data types.");
            return;
        }
        this.checkColumns(replacedColumnMap);
    }

    private Map<String, String> remap(List<ImportSlipReader.ISDataItem> remappedDataItems) throws WAImportException {
        HashSet<String> oldColumnNames = new HashSet<String>();
        for (DataItem item : this.mOldDataset.getDataItems()) {
            oldColumnNames.add(item.getName());
        }
        HashSet<String> newNamesForRemappedColumns = new HashSet<String>();
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder msgBuilder = new StringBuilder();
        for (ImportSlipReader.ISDataItem isItem : remappedDataItems) {
            if (oldColumnNames.contains(isItem.getReplaces())) {
                DataItem newItem = isItem.getDataItem(this.mNewDataset.getDataItems());
                if (newItem != null) {
                    result.put(isItem.getReplaces(), newItem.getName());
                    msgBuilder.append("Renaming data item ");
                    msgBuilder.append(isItem.getReplaces());
                    msgBuilder.append(" to ");
                    msgBuilder.append(newItem.getName());
                    msgBuilder.append(", and setting its label to ");
                    msgBuilder.append(newItem.getName()).append("\n");
                    newItem.setLabel(newItem.getName());
                    newItem.setName(isItem.getReplaces());
                    newNamesForRemappedColumns.add(newItem.getName());
                    continue;
                }
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INVALID_IMPORT_SLIP).withContextAttribute(EImportMessageContext.IMPORT_SLIP, (Object)this.mDatasetSlip).build();
            }
            LOG.warn("A replace directive is meant to replace a column called {}, but the latter does not exist. Ignoring directive.", (Object)isItem.getReplaces());
        }
        if (msgBuilder.length() > 1) {
            LOG.info(msgBuilder.toString());
        }
        this.ensureItemNamesAreUnique(newNamesForRemappedColumns);
        return result;
    }

    private void ensureItemNamesAreUnique(Set<String> newNamesForRemappedColumns) {
        if (!newNamesForRemappedColumns.isEmpty()) {
            HashSet<String> newColumnNames = new HashSet<String>();
            boolean conflictExists = false;
            for (DataItem item : this.mNewDataset.getDataItems()) {
                if (newColumnNames.add(item.getName())) continue;
                conflictExists = true;
            }
            if (conflictExists) {
                for (DataItem item : this.mNewDataset.getDataItems()) {
                    String uniqueName;
                    if (!newNamesForRemappedColumns.contains(item.getName()) || item.getLabel() != null) continue;
                    item.setLabel(item.getName());
                    int suffix = 0;
                    while (newColumnNames.contains(uniqueName = item.getName() + "-" + ++suffix)) {
                    }
                    LOG.info("Data item {} conflicts with another remapped data item. Renaming to {} with label {}.", new Object[]{item.getName(), uniqueName, item.getName()});
                    item.setName(uniqueName);
                }
            }
        }
    }

    private void checkColumns(Map<String, String> replacedColumnMap) throws WAImportException {
        boolean remapNeeded = false;
        SortedMap<String, ColumnEntry> oldItemMap = this.buildColumnEntryMapByName(this.mOldDataset, Reason.MISSING);
        SortedMap<String, ColumnEntry> newItemMap = this.buildColumnEntryMapByName(this.mNewDataset, Reason.NEW);
        int oldEntryIndex = 0;
        for (ColumnEntry oldEntry : oldItemMap.values()) {
            if (newItemMap.containsKey(oldEntry.label)) {
                ColumnEntry newEntry = (ColumnEntry)newItemMap.get(oldEntry.label);
                if (replacedColumnMap.containsKey(oldEntry.label)) {
                    newEntry.reason = null;
                    newEntry.replaces = oldEntryIndex;
                } else if (oldEntry.type.equals((Object)newEntry.type)) {
                    newEntry.reason = null;
                    newEntry.match = oldEntryIndex;
                } else {
                    DataItem newDataItem;
                    ImportSlip.ISDataType isDataType = null;
                    if (this.mDatasetSlip != null && (newDataItem = this.mNewDataset.findDataItem(newEntry.id)) != null) {
                        isDataType = this.mDatasetSlip.getItemForDataItem(newDataItem).getDataType();
                    }
                    if (isDataType != null) {
                        newEntry.reason = null;
                        newEntry.replaces = oldEntryIndex;
                    } else {
                        newEntry.reason = Reason.TYPE_MISMATCH;
                        newEntry.suggestedMatch = oldEntryIndex;
                        remapNeeded = true;
                    }
                }
                oldEntry.reason = null;
            } else {
                remapNeeded = true;
            }
            ++oldEntryIndex;
        }
        if (remapNeeded || this.isEnabled(EImportFeedbackCode.REMAP_COLUMNS_DEBUG)) {
            JSONObject columnRemap = this.buildColumnMap(oldItemMap.values(), newItemMap.values());
            try {
                LOG.error("Raising exception to remap columns: {}", (Object)columnRemap.serialize());
            }
            catch (IOException e) {
                LOG.error("Unexpected exception while serializing a column map.", (Throwable)e);
            }
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.ANALYZE_FEEDBACK_NEEDED).withContextAttribute(EImportMessageContext.FEEDBACK_CODE, (Object)EImportFeedbackCode.REMAP_COLUMNS.toString()).withContextAttribute(EImportMessageContext.COLUMNS, (Object)columnRemap).build();
        }
    }

    private boolean isEnabled(EImportFeedbackCode code) {
        return Boolean.TRUE.equals(this.mFeedbackModes.get(code));
    }

    private SortedMap<String, ColumnEntry> buildColumnEntryMapByName(Dataset dataset, Reason initialReason) {
        TreeMap<String, ColumnEntry> map = new TreeMap<String, ColumnEntry>();
        for (DataItem item : dataset.getDataItems()) {
            if (item.getName().equals("__row_id__")) continue;
            map.put(item.getName(), new ColumnEntry(item, initialReason));
        }
        return map;
    }

    private JSONObject buildColumnMap(Collection<ColumnEntry> oldEntries, Collection<ColumnEntry> newEntries) {
        OrderedJSONObject map = new OrderedJSONObject();
        JSONArray oldArray = new JSONArray(oldEntries.size());
        for (ColumnEntry entry : oldEntries) {
            oldArray.add((Object)entry.toJSON());
        }
        map.put((Object)OLD_COLUMNS, (Object)oldArray);
        JSONArray newArray = new JSONArray(newEntries.size());
        for (ColumnEntry entry : newEntries) {
            newArray.add((Object)entry.toJSON());
        }
        map.put((Object)NEW_COLUMNS, (Object)newArray);
        return map;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("oldDatasetId", (Object)(this.mOldDataset.getId() == null ? "<_id not set>" : this.mOldDataset.getId().getIdentifier())).append("newDatasetId", (Object)(this.mNewDataset.getId() == null ? "<_id not set>" : this.mNewDataset.getId().getIdentifier())).append("unmatchedMode", (Object)this.mUnmatchedMode.toString()).append("datasetSlip", (Object)(this.mDatasetSlip == null ? "<null>" : this.mDatasetSlip.toString())).toString();
    }

    public static enum Reason {
        MISSING("missing"),
        TYPE_MISMATCH("type-mismatch"),
        NEW("new");

        private final String mLabel;

        private Reason(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public class ColumnEntry {
        public static final String STR_ID = "id";
        public static final String STR_LABEL = "label";
        public static final String STR_TYPE = "type";
        public static final String STR_REASON = "reason";
        public static final String STR_MATCH = "match";
        public static final String STR_SUGGESTED_MATCH = "suggested-match";
        public static final String STR_REPLACES = "replaces";
        private static final int NOT_SET = -1;
        private final String id;
        private String label;
        private final EDataTypeGroup type;
        private Reason reason;
        private int match = -1;
        private int suggestedMatch = -1;
        private int replaces = -1;

        private ColumnEntry(DataItem item, Reason reason) {
            this.id = item.getName();
            this.label = item.getLabel() != null ? item.getLabel() : item.getName();
            this.type = EDataTypeGroup.getGroup((EDataType)item.getDataType());
            this.reason = reason;
        }

        private JSONObject toJSON() {
            OrderedJSONObject entry = new OrderedJSONObject();
            entry.put((Object)STR_ID, (Object)this.id);
            if (this.label != null) {
                entry.put((Object)STR_LABEL, (Object)this.label);
            }
            entry.put((Object)STR_TYPE, (Object)this.type.getLabel());
            if (this.reason != null) {
                entry.put((Object)STR_REASON, (Object)this.reason.getLabel());
            }
            if (this.match != -1) {
                entry.put((Object)STR_MATCH, (Object)this.match);
            }
            if (this.suggestedMatch != -1) {
                entry.put((Object)STR_SUGGESTED_MATCH, (Object)this.suggestedMatch);
            }
            if (this.replaces != -1) {
                entry.put((Object)STR_REPLACES, (Object)this.replaces);
            }
            return entry;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(STR_ID, (Object)this.id).append(STR_LABEL, (Object)this.label).append(STR_TYPE, (Object)this.type).append(STR_REASON, (Object)this.reason).append(STR_MATCH, this.match).append(STR_SUGGESTED_MATCH, this.suggestedMatch).append(STR_REPLACES, this.replaces).toString();
        }
    }
}

