/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.io.CancellableInputStream;
import com.ibm.neo.io.ObservableCountingInputStream;
import com.ibm.neo.util.ops.CallableOperation;
import java.io.InputStream;
import java.util.concurrent.CancellationException;

public class CreateBlobOp
extends CallableOperation<IBlob> {
    private static final int PROGRESS_MILESTONE_SIZE = 102400;
    private final IBlobContainer mContainer;
    private final String mFilename;
    private final String mContentType;
    private final boolean mCompressable;
    private final CancellableInputStream mCancellableStream;

    public CreateBlobOp(IBlobContainer container, String filename, String contentType, InputStream contentStream, long contentLength, boolean isCompressable) {
        this.mContainer = container;
        this.mFilename = filename;
        this.mContentType = contentType;
        this.mCompressable = isCompressable;
        this.mCancellableStream = new CancellableInputStream((InputStream)new ObservableCountingInputStream(contentStream, new ObservableCountingInputStream.IByteCountObserver(){

            public void onByteCountChanged(long delta, long count) {
                CreateBlobOp.this.setCompletedWork(count);
            }
        }, 102400L));
        this.setTotalWork(contentLength);
    }

    protected IBlob callImpl() throws Exception {
        try {
            return this.doCreateBlob();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private IBlob doCreateBlob() throws Exception {
        try {
            IBlob blob = this.mContainer.create(this.mFilename, this.mContentType, (InputStream)this.mCancellableStream, this.mCompressable);
            if (this.isCanceled()) {
                blob.remove();
                throw new CancellationException();
            }
            IBlob iBlob = blob;
            return iBlob;
        }
        finally {
            this.mCancellableStream.close();
        }
    }

    protected void cancelImpl() {
        this.mCancellableStream.cancel();
    }
}

