/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.IDatasetSampleProvider;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.storage.Column;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.EOrderByDirection;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IRowReader;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.util.Assertions;
import java.util.List;

public class DatasetSampleProviderImpl
implements IDatasetSampleProvider {
    private final ImportService mImportService;

    public DatasetSampleProviderImpl(ImportService importService) {
        this.mImportService = importService;
    }

    public IValueTupleIterator getRowSample(Dataset dataset, double sampleRate, int sampleSeed, int sampleLimit) throws WAImportException {
        return this.getRowSample(dataset, sampleRate, sampleSeed, sampleLimit, true);
    }

    public IValueTupleIterator getRowSample(Dataset dataset, double sampleRate, int sampleSeed, int sampleLimit, boolean sourceOrder) throws WAImportException {
        List dataItems = dataset.getDataItems();
        String[] dataItemNames = new String[dataItems.size()];
        for (int i = 0; i < dataItemNames.length; ++i) {
            dataItemNames[i] = ((DataItem)dataItems.get(i)).getName();
        }
        return this.getRowSample(dataset, dataItemNames, sampleRate, sampleSeed, sampleLimit, sourceOrder);
    }

    public IValueTupleIterator getRowSample(Dataset dataset, String[] projectedDataItems, double sampleRate, int sampleSeed, int sampleLimit) throws WAImportException {
        return this.getRowSample(dataset, projectedDataItems, sampleRate, sampleSeed, sampleLimit, true);
    }

    public IValueTupleIterator getRowSample(Dataset dataset, String[] projectedDataItems, double sampleRate, int sampleSeed, int sampleLimit, boolean sourceOrder) throws WAImportException {
        return this.getRowSample(dataset, projectedDataItems, null, sampleRate, sampleSeed, sampleLimit, sourceOrder);
    }

    public IValueTupleIterator getRowSample(Dataset dataset, String[] projectedDataItems, String[] groupByDataItems, double sampleRate, int sampleSeed, int sampleLimit, boolean sourceOrder) throws WAImportException {
        IRowReader reader;
        String[] groupByColumnNames;
        DeployResult result = this.mImportService.ensureDatasetDeployed(dataset);
        Database db = result.getDatabase();
        Table table = result.getTable();
        String[] projectedColumnNames = new String[projectedDataItems.length];
        int i = 0;
        for (String diName : projectedDataItems) {
            Column column = table.getColumnByDataItemName(diName);
            Assertions.assertNotNull((Object)column, (String)("Failed to resolve column for data item: " + diName));
            projectedColumnNames[i++] = column.getColumnName();
        }
        if (null != groupByDataItems && groupByDataItems.length > 0) {
            groupByColumnNames = new String[groupByDataItems.length];
            i = 0;
            for (String diName : groupByDataItems) {
                Column column = table.getColumnByDataItemName(diName);
                Assertions.assertNotNull((Object)column, (String)("Failed to resolve column for data item: " + diName));
                groupByColumnNames[i++] = column.getColumnName();
            }
        } else {
            groupByColumnNames = null;
        }
        StorageService storageService = this.mImportService.getStorageService();
        IDatabaseAccessor accessor = storageService.getOrCreateAccessor(db.getDbType());
        if (sourceOrder) {
            Column rowIdCol = table.getColumnByDataItemName("__row_id__");
            Assertions.assertNotNull((Object)rowIdCol, (String)"Failed to resolve column for data item: __row_id__");
            reader = accessor.getTableSample(db, table.getSchemaName(), table.getTableName(), projectedColumnNames, new String[]{rowIdCol.getColumnName()}, new EOrderByDirection[]{EOrderByDirection.ASCENDING}, groupByColumnNames, null != groupByColumnNames ? "MIN" : null, sampleRate, sampleSeed, sampleLimit, null);
        } else {
            reader = accessor.getTableSample(db, table.getSchemaName(), table.getTableName(), projectedColumnNames, null, null, groupByColumnNames, null != groupByColumnNames ? "MIN" : null, sampleRate, sampleSeed, sampleLimit, null);
        }
        return new ValueTupleIterAdapter(reader);
    }

    public IValueIterator getDistinctValueSample(Dataset dataset, String dataItem, double sampleRate, int sampleSeed, int sampleLimit) throws WAImportException {
        DeployResult result = this.mImportService.ensureDatasetDeployed(dataset);
        Database db = result.getDatabase();
        Table table = result.getTable();
        Column column = table.getColumnByDataItemName(dataItem);
        Assertions.assertNotNull((Object)column, (String)("Failed to resolve column for data item: " + dataItem));
        StorageService storageService = this.mImportService.getStorageService();
        IDatabaseAccessor accessor = storageService.getOrCreateAccessor(db.getDbType());
        IRowReader reader = accessor.getColumnDistinctValues(db, table.getSchemaName(), table.getTableName(), column.getColumnName(), sampleRate, sampleSeed, sampleLimit, null);
        return new ValueIterAdapter(reader);
    }

    private static final class ValueIterAdapter
    implements IValueIterator {
        private final IRowReader mReader;
        private final IValue[] mRowBuffer = new IValue[1];
        private boolean mClosed = false;

        public ValueIterAdapter(IRowReader reader) {
            this.mReader = reader;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            catch (Throwable t) {
                return;
            }
            finally {
                super.finalize();
            }
        }

        public boolean hasNext() {
            try {
                return this.mReader.hasMore();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public IValue next() {
            try {
                IValue[] row = this.mReader.read(this.mRowBuffer);
                if (null == row) {
                    return null;
                }
                Assertions.assertEqual((Object)1, (Object)row.length, (String)"Expected row length of 1");
                return row[0];
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void reset() {
            try {
                if (!this.mReader.isResetable()) {
                    throw new UnsupportedOperationException();
                }
                this.mReader.reset();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void close() {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            try {
                this.mReader.close();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static final class ValueTupleIterAdapter
    implements IValueTupleIterator {
        private final IRowReader mReader;
        private boolean mClosed = false;

        public ValueTupleIterAdapter(IRowReader reader) {
            this.mReader = reader;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            catch (Throwable t) {
                return;
            }
            finally {
                super.finalize();
            }
        }

        public boolean hasNext() {
            try {
                return this.mReader.hasMore();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public IValue[] next() {
            try {
                return this.mReader.read(null);
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void reset() {
            try {
                if (!this.mReader.isResetable()) {
                    throw new UnsupportedOperationException();
                }
                this.mReader.reset();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void close() {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            try {
                this.mReader.close();
            }
            catch (WAStorageException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

