/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.dataimport.INamingStrategy;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.dsv.DSVScraperFactory;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.storage.SQLDataType;
import com.ibm.neo.persist.ion.IONObjectId;

public class DefaultNamingStrategy
implements INamingStrategy {
    @Override
    public String makeDatasetName(DocumentDataSource dataSource, DocumentSection section) {
        return String.format("%s %s", section.getDocument().getTitle(), section.getPath());
    }

    @Override
    public String makeDatasetLabel(DocumentType documentType, DocumentSection section) {
        if (DSVScraperFactory.DSV_DOC_TYPE.equals((Object)documentType)) {
            String title = section.getDocument().getTitle();
            for (String extension : documentType.getFileExtensions()) {
                String dotExtension = "." + extension;
                if (!title.endsWith(dotExtension)) continue;
                return title.substring(0, title.lastIndexOf(dotExtension));
            }
            return title;
        }
        return section.getName();
    }

    @Override
    public String makeTenantSchemaName(IONObjectId tenantId) {
        return String.format("tenant-%s", tenantId.getIdentifier());
    }

    @Override
    public String makeTableName(Dataset dataset) {
        return String.format("T_%s_%d", dataset.getId().getIdentifier(), System.currentTimeMillis());
    }

    @Override
    public String makeColumnName(DataItem dataItem, SQLDataType dataType, int index) {
        return String.format("C%d_%s", index, dataType.toName());
    }
}

