/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.EImportFeatureFlag;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.DatasetDeployer;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.StoragePersistence;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.storage.util.DeployJobTracker;
import com.ibm.neo.dataimport.util.DeployPluginHelper;
import com.ibm.neo.dataimport.util.ImportFeatureFlagHelper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IProgress;
import com.ibm.neo.util.ops.ProgressHelper;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployDatasetOp
extends CallableOperation<DeployResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployDatasetOp.class);
    private final Map<EImportFeatureFlag, Boolean> mImportFeatureFlags;
    private final ImportService mImportService;
    private final StorageService mStorageService;
    private final PersistenceService mPersistenceService;
    private final DatasetDeployer mDeployer;
    private final UserDataSource mDataSource;
    private final Dataset mDataset;
    private final Database mDatabase;
    private final String mSchemaName;
    private final String mTableName;
    private NobjectCollection<Dataset> mDatasetCollection;
    private NobjectCollection<Table> mTableCollection;
    private DeployPluginHelper mPluginHelper;

    public DeployDatasetOp(ImportService importService, UserDataSource dataSource, Dataset dataset, Database database, String schemaName, String tableName, EOrganizedBy tableOrganization) throws ImportException {
        if (null == importService) {
            throw new NullArgumentException("importService");
        }
        if (null == dataSource) {
            throw new NullArgumentException("dataSource");
        }
        if (null == dataset) {
            throw new NullArgumentException("dataset");
        }
        if (null == database) {
            throw new NullArgumentException("database");
        }
        if (null == schemaName) {
            throw new NullArgumentException("schemaName");
        }
        if (null == tableName) {
            throw new NullArgumentException("tableName");
        }
        if (dataset.getExtendedFields().getBoolean("skip-deploy", false)) {
            throw new IllegalStateException("Deployment is not allowed for the dataset");
        }
        this.mImportService = importService;
        this.mStorageService = this.mImportService.getStorageService();
        this.mPersistenceService = PersistenceService.getInstance();
        this.mDeployer = new DatasetDeployer(importService, this.mStorageService);
        this.mDataSource = dataSource;
        this.mDataset = dataset;
        this.mDatabase = database;
        this.mSchemaName = schemaName;
        this.mTableName = tableName;
        this.mImportFeatureFlags = ImportFeatureFlagHelper.determineFeatureFlags();
        this.mDeployer.setDataSource(this.mDataSource);
        this.mDeployer.setDataset(this.mDataset);
        this.mDeployer.setDatabase(this.mDatabase);
        if (null != tableOrganization) {
            this.mDeployer.setTableOrganization(tableOrganization);
        } else if (this.isRowOrganizationForced()) {
            this.mDeployer.setTableOrganization(EOrganizedBy.ROW);
        } else if (null != database.getDefaultOrganizedBy()) {
            this.mDeployer.setTableOrganization(database.getDefaultOrganizedBy());
        } else {
            this.mDeployer.setTableOrganization(this.mImportService.getDefaultTableOrganization());
        }
        this.mPluginHelper = new DeployPluginHelper(importService.getPluginManager()).withCDFService(importService.getCDFService()).withPersistenceService(this.mPersistenceService).withConfiguration(importService.getConfiguration()).withSampleProvider(importService.getSampleProvider()).withDataset(this.mDataset).withDataSource(this.mDataSource).withDatabase(this.mDatabase);
        this.setTotalWork(100L);
    }

    private boolean isRowOrganizationForced() {
        if (Boolean.TRUE.equals(this.mImportFeatureFlags.get(EImportFeatureFlag.FORCE_ROW_ORGANIZED))) {
            return true;
        }
        IONObject relatedArtifacts = this.mDataset.getExtendedFields().getIONObject("related-artifacts");
        return null != relatedArtifacts && relatedArtifacts.getBoolean("force-row-organized", false);
    }

    public UserDataSource getDataSource() {
        return this.mDataSource;
    }

    public Dataset getDataset() {
        return this.mDataset;
    }

    protected DeployResult callImpl() throws Exception {
        try {
            return this.doDeployDataset();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeployResult doDeployDataset() throws Exception {
        LOGGER.info("Deploying dataset '{}' to database '{}' with schema '{}' and table '{}'", new Object[]{this.mDataset.getName(), this.mDatabase.getJdbcUrl(), this.mSchemaName, this.mTableName});
        this.mDatasetCollection = ImportPersistence.getDatasetCollection((PersistenceService)this.mPersistenceService);
        this.mTableCollection = StoragePersistence.getTableCollection((PersistenceService)this.mPersistenceService);
        IONObjectId tenantId = ACSHelper.getCurrentTenantId();
        Map headers = ACSHelper.getCurrentHttpHeaders();
        Properties transactionIds = WatsonHeaders.getTransactionIds((Map)headers);
        this.mDeployer.setTenantId(tenantId);
        this.mDeployer.setTransactionIds(transactionIds);
        DeployResult result = new DeployResult(this.mDataSource, this.mDataset, this.mDatabase, false);
        DeployJobTracker deployTracker = this.mStorageService.getDeployJobTracker();
        IONObjectId jobId = deployTracker.startJob(tenantId, this.mDataset.getId(), this.mDatabase.getId());
        this.mPluginHelper.preDeploy();
        try {
            UploadDataSource ds;
            Table table = null;
            boolean success = false;
            try {
                table = this.mDeployer.createTable(this.mSchemaName, this.mTableName, true);
            }
            catch (WAStorageException.TableRowLengthExceeded ex) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.TOO_MANY_COLUMNS).withMessage((IMessageKey)NeoImportError.DATASET_TOO_MANY_COLUMNS).withCause((Throwable)ex).build();
            }
            this.mPluginHelper = this.mPluginHelper.withTable(table);
            this.mPluginHelper.tableCreated();
            try {
                ProgressHelper loadProgress = new ProgressHelper();
                loadProgress.addProgressObserver((IObserver)new IObserver<IProgress>(){

                    public void updated(IProgress subject) {
                        DeployDatasetOp.this.setCompletedWork((int)Math.round(0.8 * subject.getPercentCompleted()));
                    }
                });
                this.mDeployer.loadTableData(table, loadProgress);
                this.setCompletedWork(80L);
                if (this.isCanceled()) {
                    throw new CancellationException();
                }
                this.mDeployer.collectTableStats(table);
                this.setCompletedWork(90L);
                if (this.isCanceled()) {
                    throw new CancellationException();
                }
                if (this.mDataset.getRowCount() == 0L) {
                    throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.DATASET_EMPTY).build();
                }
                this.mPluginHelper.tableLoaded();
                Date now = new Date();
                this.mDataset.setModifiedTime(now);
                this.mDataset.setLastAccessTime(now);
                table.setCreatedTime(now);
                table.setLastAccessTime(now);
                table.setLastValidatedTime(now);
                this.mDatasetCollection.save((Nobject)this.mDataset);
                this.mTableCollection.save((Nobject)table);
                this.setCompletedWork(100L);
                success = true;
                result.setTable(table);
            }
            finally {
                if (!success && null != table) {
                    try {
                        this.mStorageService.dropTable(table, 15);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception occured while cleaning up table", (Throwable)ex);
                    }
                }
            }
            if (this.mDataSource instanceof UploadDataSource && (ds = (UploadDataSource)this.mDataSource).getModelMetadata() != null) {
                this.mImportService.getBackPackService().callModelService(JSONObject.parse((String)ds.getModelMetadata()));
            }
        }
        catch (Exception ex) {
            this.mPluginHelper.postDeploy(ex);
            throw ex;
        }
        finally {
            deployTracker.endJob(jobId);
        }
        this.mPluginHelper.postDeploy(null);
        return result;
    }

    protected void cancelImpl() {
        DatasetDeployer deployer = this.mDeployer;
        if (null != deployer) {
            deployer.cancel();
        }
    }
}

