/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.EDataType;

public enum EGeneratedDateField {
    YEAR("Year", EDataType.INT16),
    QUARTER("Quarter", EDataType.INT16),
    QUARTER_NAME("Quarter Name", EDataType.STRING, 5),
    MONTH("Month", EDataType.INT16),
    MONTH_NAME("Month Name", EDataType.STRING, 15),
    DAY_OF_MONTH("Day of Month", EDataType.INT16),
    WEEKDAY("Weekday", EDataType.INT16),
    WEEKDAY_NAME("Weekday Name", EDataType.STRING, 15);

    private final String mName;
    private final EDataType mDataType;
    private final int mMaxStringLength;

    private EGeneratedDateField(String name, EDataType dataType) {
        this(name, dataType, dataType.maxStringLength());
    }

    private EGeneratedDateField(String name, EDataType dataType, int maxStringLength) {
        this.mName = name;
        this.mDataType = dataType;
        this.mMaxStringLength = maxStringLength;
    }

    public EDataType getEDataType() {
        return this.mDataType;
    }

    public int getMaxStringLength() {
        return this.mMaxStringLength;
    }

    DataItem getDataItem(DataItem sourceDate) {
        DataItem di = new DataItem();
        di.setName(this.mName + " (" + sourceDate.getName() + ")");
        di.setDataType(this.mDataType);
        di.setMaxStringLength(this.mMaxStringLength);
        di.getExtendedFields().put((Object)"generated-field-type", (Object)this.name());
        di.getExtendedFields().put((Object)"generated-field-source", (Object)sourceDate.getName());
        return di;
    }
}

