/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.deploy.DeploymentResolver;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.util.ops.CallableOperation;
import java.util.List;

public class EnsureDeployedOp
extends CallableOperation<List<DeployResult>> {
    private final DeploymentResolver resolver;
    private final List<Dataset> datasets;
    private final boolean collocated;
    private final long timeoutSeconds;

    public EnsureDeployedOp(DeploymentResolver resolver, List<Dataset> datasets, boolean collocated, long timeoutSeconds) {
        this.resolver = resolver;
        this.datasets = datasets;
        this.collocated = collocated;
        this.timeoutSeconds = timeoutSeconds;
        this.setTotalWork(1L);
    }

    protected List<DeployResult> callImpl() throws Exception {
        try {
            return this.resolver.ensureDeployed(this.datasets, this.collocated, this.timeoutSeconds);
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    protected void cancelImpl() {
    }
}

