/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.json.java.JSONArray;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.blobstore.IBlobStoreFactory;
import com.ibm.neo.dataimport.AnalyzeDocumentOp;
import com.ibm.neo.dataimport.AppendDocumentOp;
import com.ibm.neo.dataimport.DatasetSampleProviderImpl;
import com.ibm.neo.dataimport.DefaultNamingStrategy;
import com.ibm.neo.dataimport.DeployDatasetOp;
import com.ibm.neo.dataimport.EnsureDeployedOp;
import com.ibm.neo.dataimport.INamingStrategy;
import com.ibm.neo.dataimport.QuickImportOp;
import com.ibm.neo.dataimport.RemoveDataSourceOp;
import com.ibm.neo.dataimport.ReplaceDocumentOp;
import com.ibm.neo.dataimport.UploadDocumentOp;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.IDatasetSampleProvider;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.backpack.BackPackMetadata;
import com.ibm.neo.dataimport.backpack.BackPackMetadataOp;
import com.ibm.neo.dataimport.backpack.IBackPackService;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.deploy.DeploymentResolver;
import com.ibm.neo.dataimport.deploy.IDatabaseSelectionStrategy;
import com.ibm.neo.dataimport.deploy.IDatabaseSelectionStrategyFactory;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.ops.QuickImportResult;
import com.ibm.neo.dataimport.nodel.ops.ReplaceDocumentResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.plugin.framework.PluginManager;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.util.ImportQuotas;
import com.ibm.neo.dataimport.util.NeoImportQuotas;
import com.ibm.neo.dataimport.util.RemovePluginHelper;
import com.ibm.neo.exception.IllegalPropertyValueException;
import com.ibm.neo.g11n.LocaleProvider;
import com.ibm.neo.g11n.LocaleUtil;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.util.Assertions;
import com.ibm.neo.util.ThreadFactories;
import com.ibm.neo.util.ops.IOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.util.ops.OperationExecutor;
import com.ibm.neo.wrangler.api.WranglerService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;
import org.apache.shiro.concurrent.SubjectAwareScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportService {
    public static final String PROP_BLOBSTORE_FACTORY = "com.ibm.neo.blobstore.factory";
    public static final String BLOB_ROOT_DIRECTORY = "com.ibm.neo.blobstore.file.root-dir";
    public static final String PROP_TEMP_DIR = "com.ibm.neo.dataimport.temp-dir";
    public static final String PROP_NULL_PLACEHOLDERS = "com.ibm.neo.dataimport.null-placeholders";
    public static final String PROP_STRING_LENGTH_LIMIT = "com.ibm.neo.dataimport.string-length-limit";
    public static final String PROP_SKIP_EMPTY_ROWS = "com.ibm.neo.dataimport.boolean-skip-empty-rows";
    public static final String PROP_TABLE_ORGANIZATION = "com.ibm.neo.dataimport.table-organization";
    public static final String PROP_SHUTDOWN_WAIT_TIME = "com.ibm.neo.dataimport.shutdown-wait-time";
    public static final String PROP_NAMING_STRATEGY = "com.ibm.neo.dataimport.naming-strategy";
    public static final String PROP_DATASET_REPAIR_DELAY_TIME = "com.ibm.neo.dataimport.dataset-repair-delay-time";
    public static final String PROP_DB_SELECTION_STRATEGY_FACTORY = "com.ibm.neo.dataimport.db-selection-strategy-factory";
    private static final String CONTENT_STREAM = "contentStream";
    private static final String DATASET = "dataset";
    private static final String DATA_SOURCE = "dataSource";
    private static final String EXCEPTION_CAUGHT_IN_DISPOSE = "Exception caught in dispose";
    private static final String DEFAULT_BLOBSTORE_FACTORY = "com.ibm.neo.blobstore.ps.PSBlobStoreFactory";
    private static final String DEFAULT_DB_SELECTION_STRATEGY_FACTORY = "com.ibm.neo.dataimport.deploy.CostBiasedDbSelectionStrategyFactory";
    private static final String DEFAULT_NULL_PLACEHOLDERS = "[\"n/a\", \"-\", \"--\", \"null\"]";
    private static final int DEFAULT_STRING_LENGTH_LIMIT = 100;
    private static final boolean DEFAULT_SKIP_EMPTY_ROWS = false;
    private static final String DEFAULT_SHEET_LIB_FACTORY = "com.ibm.neo.dataimport.cdf.sheet.impl.BlobSheetLibraryFactory";
    private static final int DEFAULT_SHUTDOWN_WAIT_TIME = 120;
    private static final int DEFAULT_DATASET_REPAIR_DELAY_TIME = 300;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportService.class);
    private static ImportService sInstance = null;
    private final Properties mConfiguration;
    private final CDFService mCDFService;
    private IBackPackService mBackPackService = null;
    private final OperationExecutor mWorkerPool;
    private final ScheduledExecutorService mScheduledExecutor;
    private final AccessControlService mACS;
    private final PersistenceService mPersistenceService;
    private final WranglerService mWranglerService;
    private final StorageService mStorageService;
    private final IDatasetSampleProvider mSampleProvider;
    private final File mTempDir;
    private final List<String> mNullPlaceholders;
    private int mStringLengthLimit = 100;
    private boolean mSkipEmptyRows = false;
    private EOrganizedBy mDefaultTableOrganization = EOrganizedBy.COLUMN;
    private int mShutdownWaitTime = 120;
    private int mDatasetRepairDelayTime = 300;
    private final IBlobStore mBlobStore;
    private final PluginManager mPluginManager;
    private final INamingStrategy mNamingStrategy;
    private final IDatabaseSelectionStrategy mDbSelectionStrategy;
    private final DeploymentResolver mDeploymentResolver;

    public static boolean isInitialized() {
        return null != sInstance;
    }

    public static void initialize(Properties cfg) throws Exception {
        if (null != sInstance) {
            throw new IllegalStateException("ImportService was already initialized.");
        }
        sInstance = new ImportService(cfg);
    }

    public static void initialize(Properties cfg, AccessControlService acs, PersistenceService ps, WranglerService wrangler) throws Exception {
        if (null != sInstance) {
            throw new IllegalStateException("ImportService was already initialized.");
        }
        sInstance = new ImportService(cfg, acs, ps, wrangler);
    }

    public static void terminate() {
        if (null != sInstance) {
            try {
                sInstance.dispose();
            }
            finally {
                sInstance = null;
            }
        }
    }

    public static ImportService getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("ImportService was not initialized.");
        }
        return sInstance;
    }

    public static void setLocaleProvider(LocaleProvider provider) {
        LocaleUtil.setLocaleProvider((LocaleProvider)provider);
    }

    protected ImportService() throws Exception {
        this.mWorkerPool = null;
        this.mTempDir = null;
        this.mStorageService = null;
        this.mScheduledExecutor = null;
        this.mSampleProvider = null;
        this.mPluginManager = null;
        this.mPersistenceService = null;
        this.mNullPlaceholders = null;
        this.mNamingStrategy = null;
        this.mConfiguration = null;
        this.mCDFService = null;
        this.mBlobStore = null;
        this.mACS = null;
        this.mWranglerService = null;
        this.mDbSelectionStrategy = null;
        this.mDeploymentResolver = null;
    }

    public ImportService(Properties configuration) throws Exception {
        this(configuration, AccessControlService.getInstance(), PersistenceService.getInstance(), WranglerService.getInstance());
    }

    public ImportService(Properties configuration, AccessControlService acs, PersistenceService persistenceService, WranglerService wranglerService) throws Exception {
        this.mConfiguration = new Properties();
        this.mConfiguration.putAll((Map<?, ?>)configuration);
        this.mACS = acs;
        this.mPersistenceService = persistenceService;
        this.mWranglerService = wranglerService;
        if (null != this.mConfiguration.get(PROP_STRING_LENGTH_LIMIT)) {
            this.mStringLengthLimit = Integer.parseInt(this.mConfiguration.getProperty(PROP_STRING_LENGTH_LIMIT));
        }
        if (null != this.mConfiguration.get(PROP_SKIP_EMPTY_ROWS)) {
            this.mSkipEmptyRows = Boolean.parseBoolean(this.mConfiguration.getProperty(PROP_SKIP_EMPTY_ROWS));
        }
        if (null != this.mConfiguration.get(PROP_TABLE_ORGANIZATION)) {
            String tableOrgStr = this.mConfiguration.getProperty(PROP_TABLE_ORGANIZATION);
            this.mDefaultTableOrganization = EOrganizedBy.valueOf((String)tableOrgStr.toUpperCase());
        }
        if (null != this.mConfiguration.get(PROP_SHUTDOWN_WAIT_TIME)) {
            this.mShutdownWaitTime = Integer.parseInt(this.mConfiguration.getProperty(PROP_SHUTDOWN_WAIT_TIME));
        }
        if (null != this.mConfiguration.get(PROP_DATASET_REPAIR_DELAY_TIME)) {
            this.mDatasetRepairDelayTime = Integer.parseInt(this.mConfiguration.getProperty(PROP_DATASET_REPAIR_DELAY_TIME));
        }
        this.mTempDir = null != this.mConfiguration.get(PROP_TEMP_DIR) ? new File(this.mConfiguration.getProperty(PROP_TEMP_DIR)) : new File(FileUtils.getTempDirectoryPath(), "NeoImportTemp");
        if (this.mTempDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)this.mTempDir);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to clean temp directory", (Throwable)ex);
            }
        } else {
            FileUtils.forceMkdir((File)this.mTempDir);
        }
        if (null == this.mConfiguration.get("com.ibm.neo.dataimport.sheet.data-dir")) {
            this.mConfiguration.put("com.ibm.neo.dataimport.sheet.data-dir", FilenameUtils.concat((String)this.mTempDir.getAbsolutePath(), (String)"SheetCache"));
        }
        if (null == this.mConfiguration.get("com.ibm.neo.dataimport.sheet.library.factory")) {
            this.mConfiguration.put("com.ibm.neo.dataimport.sheet.library.factory", DEFAULT_SHEET_LIB_FACTORY);
        }
        this.mNamingStrategy = ImportService.createNamingStrategy(this.mConfiguration);
        this.mNullPlaceholders = ImportService.resolveNullPlaceholders(this.mConfiguration);
        this.mWorkerPool = new OperationExecutor((ExecutorService)new SubjectAwareExecutorService(Executors.newCachedThreadPool(ThreadFactories.create((String)"ImportService-Worker", (boolean)false))));
        ScheduledThreadPoolExecutor schedPoolExec = new ScheduledThreadPoolExecutor(2, ThreadFactories.create((String)"ImportService-Scheduler", (boolean)true));
        schedPoolExec.setMaximumPoolSize(20);
        schedPoolExec.setKeepAliveTime(30L, TimeUnit.SECONDS);
        this.mScheduledExecutor = new SubjectAwareScheduledExecutorService((ScheduledExecutorService)schedPoolExec);
        String blobStoreFactoryName = this.mConfiguration.getProperty(PROP_BLOBSTORE_FACTORY, DEFAULT_BLOBSTORE_FACTORY);
        Class factoryClass = ClassUtils.getClass((String)blobStoreFactoryName);
        IBlobStoreFactory factoryInst = (IBlobStoreFactory)factoryClass.newInstance();
        LOGGER.info("Using blob store implementation provided by {}", (Object)factoryClass);
        this.mBlobStore = factoryInst.create(this.mConfiguration, this.mPersistenceService);
        this.mCDFService = new CDFService(this.mConfiguration, this.mBlobStore);
        this.mStorageService = new StorageService(this.mConfiguration, this.mPersistenceService, this.mWranglerService);
        for (IBackPackService backPackService : ServiceLoader.load(IBackPackService.class)) {
            assert (this.mBackPackService == null);
            this.mBackPackService = backPackService;
        }
        this.mPluginManager = new PluginManager(this.mConfiguration);
        this.mSampleProvider = new DatasetSampleProviderImpl(this);
        this.mDbSelectionStrategy = this.makeDbSelectionStrategy(this.mStorageService);
        this.mDeploymentResolver = new DeploymentResolver(this.mPersistenceService, this.mWranglerService, this.mACS, this.mStorageService, this, this.mDbSelectionStrategy, this.mDatasetRepairDelayTime);
    }

    public IBackPackService getBackPackService() {
        return this.mBackPackService;
    }

    public Properties getConfiguration() {
        return this.mConfiguration;
    }

    public OperationExecutor getWorkerPool() {
        return this.mWorkerPool;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.mScheduledExecutor;
    }

    public IBlobStore getBlobStore() {
        return this.mBlobStore;
    }

    public CDFService getCDFService() {
        return this.mCDFService;
    }

    public StorageService getStorageService() {
        return this.mStorageService;
    }

    public PersistenceService getPersistenceService() {
        return this.mPersistenceService;
    }

    public WranglerService getWranglerService() {
        return this.mWranglerService;
    }

    public PluginManager getPluginManager() {
        return this.mPluginManager;
    }

    public IDatasetSampleProvider getSampleProvider() {
        return this.mSampleProvider;
    }

    public File getTempDir() {
        return this.mTempDir;
    }

    public List<String> getNullPlaceholders() {
        return this.mNullPlaceholders;
    }

    public int getStringLengthLimit() {
        return this.mStringLengthLimit;
    }

    public boolean getSkipEmptyRows() {
        return this.mSkipEmptyRows;
    }

    public EOrganizedBy getDefaultTableOrganization() {
        return this.mDefaultTableOrganization;
    }

    public void setDefaultTableOrganization(EOrganizedBy orgranizedBy) {
        this.mDefaultTableOrganization = orgranizedBy;
    }

    public INamingStrategy getNamingStrategy() {
        return this.mNamingStrategy;
    }

    public IDatabaseSelectionStrategy getDBSelectionStrategy() {
        return this.mDbSelectionStrategy;
    }

    public UserDataSource getDataSource(IONObjectId dataSourceId) throws WAImportException {
        try {
            return (UserDataSource)ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mPersistenceService).get(dataSourceId);
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public List<UserDataSource> listDataSources(String name) throws WAImportException {
        QueryBuilder query = new QueryBuilder();
        if (null != name) {
            query.equalTo("name", (Object)name);
        }
        try {
            return ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mPersistenceService).find(query.toDocument()).toListAndClose();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public IOperation removeDataSource(IONObjectId dataSourceId, boolean dropDatasets) throws WAImportException {
        return this.removeDataSource(dataSourceId, dropDatasets, true);
    }

    public IOperation removeDataSource(IONObjectId dataSourceId, boolean dropDatasets, boolean acquireLock) throws WAImportException {
        if (null == dataSourceId) {
            throw new NullArgumentException("dataSourceId");
        }
        LOGGER.info("Removing data source (_id={}, dropDatasets={})", (Object)dataSourceId.getIdentifier(), (Object)dropDatasets);
        RemoveDataSourceOp op = new RemoveDataSourceOp(this, dataSourceId, dropDatasets, true, true, false, true);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public Dataset getDataset(IONObjectId datasetId) throws WAImportException {
        try {
            return (Dataset)ImportPersistence.getDatasetCollection((PersistenceService)this.mPersistenceService).get(datasetId);
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public List<Dataset> listDatasets(IONObjectId dataSourceId) throws WAImportException {
        QueryBuilder query = new QueryBuilder();
        if (null != dataSourceId) {
            query.equalTo("data-source-id", (Object)dataSourceId);
        }
        try {
            return ImportPersistence.getDatasetCollection((PersistenceService)this.mPersistenceService).find(query.toDocument()).toListAndClose();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public void removeDataset(IONObjectId datasetId, boolean replaceHint) throws WAImportException {
        this.removeDataset(datasetId, true, replaceHint);
    }

    public void removeDataset(IONObjectId datasetId, boolean dropTables, boolean replaceHint) throws WAImportException {
        if (null == datasetId) {
            throw new NullArgumentException("datasetId");
        }
        Dataset dataset = this.getDataset(datasetId);
        if (null == dataset) {
            return;
        }
        this.removeDataset(dataset, dropTables, replaceHint);
    }

    public void removeDataset(Dataset dataset, boolean dropTables, boolean replaceHint) throws WAImportException {
        if (null == dataset) {
            throw new NullArgumentException(DATASET);
        }
        LOGGER.info("Removing dataset (name={}, _id={})", (Object)dataset.getName(), (Object)(null != dataset.getId() ? dataset.getId().getIdentifier() : "?"));
        RemovePluginHelper helper = new RemovePluginHelper(this.getPluginManager()).withCDFService(this.getCDFService()).withPersistenceService(this.mPersistenceService).withConfiguration(this.getConfiguration()).withReplaceHint(replaceHint);
        UserDataSource dataSource = this.getDataSource(dataset.getDataSourceId());
        Assertions.assertNotNull((Object)dataSource);
        try {
            if (dropTables) {
                List deployedTables = this.getStorageService().listTables(ACSHelper.getCurrentTenantId(), null, dataset.getId(), null, null, true, true);
                for (Table tbl : deployedTables) {
                    this.mStorageService.dropTable(tbl, 15);
                    Database db = null;
                    try {
                        db = this.mStorageService.getDatabase(tbl.getDatabaseId());
                    }
                    catch (WAStorageException ex) {
                        continue;
                    }
                    helper.tableDropped(dataSource, dataset, db, tbl);
                }
            }
            ImportPersistence.getDatasetCollection((PersistenceService)this.mPersistenceService).remove(dataset.getId());
            helper.datasetRemoved(dataSource, dataset);
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public boolean dropTenantSchema() throws WAImportException {
        LOGGER.info("Dropping all schemas for current tenant");
        List databases = this.getStorageService().listDatabases(null, false);
        IONObjectId tenantId = ACSHelper.getCurrentTenantId();
        String schemaName = this.getNamingStrategy().makeTenantSchemaName(tenantId);
        boolean droppedAllSchemas = true;
        for (Database db : databases) {
            boolean schemaExists;
            block5: {
                schemaExists = false;
                try {
                    if (!this.mStorageService.checkDatabase(db) || !this.mStorageService.checkSchema(db, schemaName)) break block5;
                    schemaExists = true;
                }
                catch (WAImportException e) {
                    continue;
                }
            }
            try {
                if (!schemaExists) continue;
                droppedAllSchemas = this.mStorageService.dropSchema(db, schemaName) && droppedAllSchemas;
            }
            catch (WAStorageException e) {
                LOGGER.info("Swallowed an exception while dropping schema {}. Databases and schemas are not required to exist.", (Object)schemaName, (Object)e);
            }
        }
        return droppedAllSchemas;
    }

    public IOperationWithResult<UploadDataSource> uploadDocument(String fileName, String contentType, InputStream contentStream, Long contentSize, String hashValue) throws WAImportException {
        return this.uploadDocument(fileName, contentType, contentStream, contentSize, hashValue, null);
    }

    public IOperationWithResult<UploadDataSource> uploadDocument(String fileName, String contentType, InputStream contentStream, Long expectedSize, String expectedHash, IONObject importSlip) throws WAImportException {
        return this.uploadDocument(fileName, contentType, contentStream, expectedSize, expectedHash, importSlip, 0L);
    }

    public IOperationWithResult<UploadDataSource> uploadDocument(String fileName, String contentType, InputStream contentStream, Long expectedSize, String expectedHash, IONObject importSlip, long storageQuotaDeduction) throws WAImportException {
        if (null == fileName) {
            throw new NullArgumentException("fileName");
        }
        if (null == contentStream) {
            throw new NullArgumentException(CONTENT_STREAM);
        }
        LOGGER.info("Uploading document [fileName={}, contentType={}, expectedSize={}, expectedHash={}, storageQuotaDeduction={}]", new Object[]{fileName, contentType, expectedSize, expectedHash, storageQuotaDeduction});
        IONObjectId newDataSourceId = this.mPersistenceService.generateId();
        UploadDocumentOp op = new UploadDocumentOp(this, fileName, contentType, contentStream, expectedSize, expectedHash, newDataSourceId, importSlip, storageQuotaDeduction);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public IBlob getUploadedBlob(UploadDataSource ds) throws WAImportException {
        try {
            IBlobContainer container = this.getBlobStore().getContainer(ds.getBlobContainer(), false);
            Assertions.assertNotNull((Object)container);
            return container.get(ds.getBlobKey());
        }
        catch (BlobStoreException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public IOperationWithResult<AnalyzeResult> analyzeDataSource(UserDataSource dataSource, IONObject importSlip) throws WAImportException {
        if (null == dataSource) {
            throw new NullArgumentException(DATA_SOURCE);
        }
        LOGGER.info("Analyzing data source (name={}, _id={})", (Object)dataSource.getName(), (Object)(null != dataSource.getId() ? dataSource.getId().getIdentifier() : "?"));
        if (dataSource instanceof BackPackMetadata) {
            BackPackMetadata bm = (BackPackMetadata)dataSource;
            BackPackMetadataOp op = new BackPackMetadataOp(bm);
            this.mWorkerPool.submit((IOperation)op);
            return op;
        }
        if (dataSource instanceof DocumentDataSource) {
            DocumentDataSource documentDataSource = (DocumentDataSource)dataSource;
            AnalyzeDocumentOp op = new AnalyzeDocumentOp(this, this.mACS, documentDataSource, importSlip);
            this.mWorkerPool.submit((IOperation)op);
            return op;
        }
        throw new UnsupportedOperationException("Data source type is not yet supported");
    }

    public IOperationWithResult<DeployResult> deployDataset(Dataset dataset) throws WAImportException {
        return this.deployDataset(dataset, null);
    }

    public IOperationWithResult<DeployResult> deployDatasetWithPrejudice(Dataset dataset, List<IONObjectId> auxiliaryDatabaseIds) throws WAImportException {
        Tenant tenant;
        try {
            tenant = this.mACS.getCurrentTenant();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
        Database db = this.selectDatabase(tenant, dataset, auxiliaryDatabaseIds);
        return this.deployDataset(dataset, db);
    }

    public IOperationWithResult<DeployResult> deployDataset(Dataset dataset, Database db) throws WAImportException {
        Tenant tenant;
        if (null == dataset) {
            throw new NullArgumentException(DATASET);
        }
        try {
            tenant = this.mACS.getCurrentTenant();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
        UserDataSource dataSource = this.getDataSource(dataset.getDataSourceId());
        if (null == dataSource) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_DATASOURCE_REMOVED).build();
        }
        if (null == dataset.getId()) {
            dataset.setId(this.mPersistenceService.generateId());
        }
        if (null == db) {
            db = this.selectDatabase(tenant, dataset, null);
        }
        String schemaName = null != db.getDeploySchema() ? db.getDeploySchema() : this.mNamingStrategy.makeTenantSchemaName(tenant.getId());
        String tableName = this.mNamingStrategy.makeTableName(dataset);
        LOGGER.info("Deploying dataset (name={}, _id={}) to database (name={}, _id={}) using table name {}.{}", new Object[]{dataset.getName(), null != dataset.getId() ? dataset.getId().getIdentifier() : "?", db.getName(), null != db.getId() ? db.getId().getIdentifier() : "?", schemaName, tableName});
        DeployDatasetOp op = new DeployDatasetOp(this, dataSource, dataset, db, schemaName, tableName, null);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public IOperationWithResult<DeployResult> deployDataset(Dataset dataset, Database db, String schemaName, String tableName, EOrganizedBy tableOrganization) throws WAImportException {
        if (null == dataset) {
            throw new NullArgumentException(DATASET);
        }
        if (null == db) {
            throw new NullArgumentException("db");
        }
        if (null == schemaName) {
            throw new NullArgumentException("schemaName");
        }
        if (null == tableName) {
            throw new NullArgumentException("tableName");
        }
        LOGGER.info("Deploying dataset (name={}, _id={}) to database (name={}, _id={}) using table name '{}.{}' and table organization '{}'", new Object[]{dataset.getName(), null != dataset.getId() ? dataset.getId().getIdentifier() : "?", db.getName(), null != db.getId() ? db.getId().getIdentifier() : "?", schemaName, tableName, tableOrganization});
        try {
            UserDataSource dataSource = (UserDataSource)ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mPersistenceService).get(dataset.getDataSourceId());
            if (null == dataset.getId()) {
                dataset.setId(this.mPersistenceService.generateId());
            }
            DeployDatasetOp op = new DeployDatasetOp(this, dataSource, dataset, db, schemaName, tableName, tableOrganization);
            this.mWorkerPool.submit((IOperation)op);
            return op;
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    public IOperationWithResult<QuickImportResult> quickImport(UserDataSource dataSource) throws WAImportException {
        if (null == dataSource) {
            throw new NullArgumentException(DATA_SOURCE);
        }
        LOGGER.info("Quick-importing data source (name={}, _id={})", (Object)dataSource.getName(), (Object)(null != dataSource.getId() ? dataSource.getId().getIdentifier() : "?"));
        QuickImportOp op = new QuickImportOp(this, dataSource);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public IOperationWithResult<ReplaceDocumentResult> replaceDocument(DocumentDataSource dataSource, String filename, InputStream contentStream, String contentType, Long expectedSize, String expectedHash, IONObject importSlip) throws WAImportException {
        if (null == dataSource) {
            throw new NullArgumentException(DATA_SOURCE);
        }
        if (null == contentStream) {
            throw new NullArgumentException(CONTENT_STREAM);
        }
        LOGGER.info("Replacing document for data source (name={}, _id={}) [fileName={}, contentType={}, expectedSize={}, expectedHash={}, importSlip={}]", new Object[]{dataSource.getName(), null != dataSource.getId() ? dataSource.getId().getIdentifier() : "?", filename, contentType, expectedSize, expectedHash, importSlip});
        ReplaceDocumentOp op = new ReplaceDocumentOp(this.mACS, this, dataSource, filename, contentStream, contentType, expectedSize, expectedHash, importSlip);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public IOperationWithResult<ReplaceDocumentResult> appendDocument(DocumentDataSource dataSource, String filename, InputStream contentStream, String contentType, Long expectedSize, String expectedHash, IONObject importSlip) throws WAImportException {
        if (null == dataSource) {
            throw new NullArgumentException(DATA_SOURCE);
        }
        if (null == contentStream) {
            throw new NullArgumentException(CONTENT_STREAM);
        }
        LOGGER.info("Appending document for data source (name={}, _id={}) [fileName={}, contentType={}, expectedSize={}, expectedHash={}, importSlip={}]", new Object[]{dataSource.getName(), null != dataSource.getId() ? dataSource.getId().getIdentifier() : "?", filename, contentType, expectedSize, expectedHash, importSlip});
        AppendDocumentOp op = new AppendDocumentOp(this.mACS, this, dataSource, filename, contentStream, contentType, expectedSize, expectedHash, importSlip);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public DeployResult ensureDatasetDeployed(Dataset dataset) throws WAImportException {
        return this.ensureDatasetDeployed(dataset, 300L);
    }

    public DeployResult ensureDatasetDeployed(Dataset dataset, long timeoutSeconds) throws WAImportException {
        LOGGER.info("Ensuring dataset (_id={}, name={}) is deployed with a timeout of {} seconds", new Object[]{dataset.getId() != null ? dataset.getId().getIdentifier() : "?", dataset.getName(), timeoutSeconds});
        return this.mDeploymentResolver.ensureDeployed(dataset, timeoutSeconds);
    }

    public IOperationWithResult<List<DeployResult>> ensureDatasetsDeployed(List<Dataset> datasets, boolean collocated) throws WAImportException {
        return this.ensureDatasetsDeployed(datasets, collocated, 300L);
    }

    public IOperationWithResult<List<DeployResult>> ensureDatasetsDeployed(List<Dataset> datasets, boolean collocated, long timeoutSeconds) throws WAImportException {
        if (LOGGER.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < datasets.size(); ++i) {
                Dataset ds = datasets.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append("(name=").append(ds.getName()).append(", _id=");
                if (ds.getId() != null) {
                    builder.append(ds.getId().getIdentifier());
                } else {
                    builder.append("?");
                }
                builder.append(")");
            }
            LOGGER.info("Ensuring datasets [{}] are deployed with collocation={} and timeout={} seconds", new Object[]{builder, collocated, timeoutSeconds});
        }
        EnsureDeployedOp op = new EnsureDeployedOp(this.mDeploymentResolver, datasets, collocated, timeoutSeconds);
        this.mWorkerPool.submit((IOperation)op);
        return op;
    }

    public ImportQuotas getImportQuotas() {
        return new NeoImportQuotas(this.mConfiguration, this.mPersistenceService, this.mACS);
    }

    public void dispose() {
        LOGGER.info("Disposing ImportService");
        try {
            this.mWorkerPool.shutdown();
            long startNanos = System.nanoTime();
            while (!this.mWorkerPool.isTerminated()) {
                LOGGER.warn("ImportService has running jobs; shutdown will be blocked for 15 seconds");
                this.mWorkerPool.awaitTermination(15L, TimeUnit.SECONDS);
                long elapsedNanos = System.nanoTime() - startNanos;
                if (TimeUnit.NANOSECONDS.toSeconds(elapsedNanos) <= (long)this.mShutdownWaitTime) continue;
                LOGGER.warn("ImportService shutdown timeout has occured ({} seconds); running jobs will be cancelled", (Object)this.mShutdownWaitTime);
                this.mWorkerPool.shutdownNow(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        try {
            this.mScheduledExecutor.shutdown();
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        try {
            this.mPluginManager.unregisterAllPlugins();
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        try {
            this.mStorageService.dispose();
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        try {
            this.mCDFService.dispose();
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        try {
            this.mBlobStore.shutdown();
        }
        catch (Exception ex) {
            LOGGER.error(EXCEPTION_CAUGHT_IN_DISPOSE, (Throwable)ex);
        }
        FileUtils.deleteQuietly((File)this.mTempDir);
    }

    private static List<String> resolveNullPlaceholders(Properties config) {
        ArrayList<String> placeholders = new ArrayList<String>();
        String json = config.getProperty(PROP_NULL_PLACEHOLDERS, DEFAULT_NULL_PLACEHOLDERS);
        try {
            for (Object e : JSONArray.parse((String)json)) {
                placeholders.add(e.toString());
            }
        }
        catch (Exception ex) {
            throw new IllegalPropertyValueException(PROP_NULL_PLACEHOLDERS, (Object)json);
        }
        return placeholders;
    }

    private static INamingStrategy createNamingStrategy(Properties config) throws Exception {
        INamingStrategy strategy;
        String strategyClassName = null;
        strategyClassName = System.getProperty(PROP_NAMING_STRATEGY);
        if (null == strategyClassName) {
            strategyClassName = config.getProperty(PROP_NAMING_STRATEGY);
        }
        if (null != strategyClassName) {
            Class clazz = ClassUtils.getClass((String)strategyClassName);
            strategy = (INamingStrategy)clazz.newInstance();
            LOGGER.info("Using naming strategy {}", (Object)clazz.getName());
        } else {
            strategy = new DefaultNamingStrategy();
            LOGGER.info("Using default naming strategy");
        }
        return strategy;
    }

    private IDatabaseSelectionStrategy makeDbSelectionStrategy(StorageService storageService) throws Exception {
        String selectionFactoryName = this.mConfiguration.getProperty(PROP_DB_SELECTION_STRATEGY_FACTORY, DEFAULT_DB_SELECTION_STRATEGY_FACTORY);
        Class factoryClass = ClassUtils.getClass((String)selectionFactoryName);
        IDatabaseSelectionStrategyFactory factoryInst = (IDatabaseSelectionStrategyFactory)factoryClass.newInstance();
        LOGGER.info("Using db selection strategy implementation provided by {}", (Object)factoryClass);
        return factoryInst.create(storageService);
    }

    private Database selectDatabase(Tenant tenant, Dataset dataset, List<IONObjectId> auxiliaryDbIds) throws WAStorageException.NoDatabaseAvailable {
        Database db = null;
        db = auxiliaryDbIds == null ? this.mDbSelectionStrategy.select(tenant, Arrays.asList(dataset)) : this.mDbSelectionStrategy.select(tenant, Arrays.asList(dataset), auxiliaryDbIds);
        if (null == db) {
            throw new WAStorageException.NoDatabaseAvailable();
        }
        return db;
    }
}

