/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.ops.QuickImportResult;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.util.ops.ProgressAggregator;
import com.ibm.neo.util.ops.StaticProgressAggregator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QuickImportOp
extends CallableOperation<QuickImportResult> {
    private final ImportService mImportService;
    private final UserDataSource mDataSource;
    private final ConcurrentLinkedQueue<IOperation> mPendingOps = new ConcurrentLinkedQueue();

    public QuickImportOp(ImportService importService, UserDataSource dataSource) {
        this.mImportService = importService;
        this.mDataSource = dataSource;
        this.setTotalWork(100L);
    }

    protected QuickImportResult callImpl() throws Exception {
        try {
            return this.doQuickImport();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private QuickImportResult doQuickImport() throws Exception {
        QuickImportResult result = new QuickImportResult(this.mDataSource);
        double analyseWeight = 0.15;
        double deployWeight = 1.0;
        double totalWeight = analyseWeight + deployWeight;
        StaticProgressAggregator overallProgress = new StaticProgressAggregator((IObserver)new IObserver<ProgressAggregator>(){

            public void updated(ProgressAggregator subject) {
                QuickImportOp.this.setCompletedWork((long)Math.ceil(subject.getPercentCompleted()));
            }
        }, totalWeight);
        IOperationWithResult<AnalyzeResult> analyzeOp = this.mImportService.analyzeDataSource(this.mDataSource, null);
        overallProgress.addSource(analyzeOp, analyseWeight);
        this.mPendingOps.add((IOperation)analyzeOp);
        analyzeOp.waitFor();
        this.mPendingOps.remove(analyzeOp);
        if (analyzeOp.isCanceled()) {
            this.cancel();
            throw new CancellationException();
        }
        if (analyzeOp.hasFailed()) {
            Throwable error = analyzeOp.getError();
            if (error instanceof Exception) {
                throw (Exception)error;
            }
            throw new RuntimeException("Fatal error: " + error.toString(), error);
        }
        AnalyzeResult analyzeResult = (AnalyzeResult)analyzeOp.getResult();
        for (Dataset ds : analyzeResult.getDatasets()) {
            IOperationWithResult<DeployResult> deployOp = this.mImportService.deployDataset(ds);
            overallProgress.addSource(deployOp, deployWeight);
            this.mPendingOps.add((IOperation)deployOp);
        }
        Throwable deployError = null;
        for (IOperation op : this.mPendingOps) {
            op.waitFor();
            this.mPendingOps.remove(op);
            if (op.isCanceled()) {
                this.cancel();
                throw new CancellationException();
            }
            if (op.hasFailed()) {
                deployError = op.getError();
                break;
            }
            result.getDeployments().add(((IOperationWithResult)op).getResult());
        }
        if (null != deployError) {
            for (IOperation op : this.mPendingOps) {
                op.cancel();
            }
            if (deployError instanceof Exception) {
                throw (Exception)deployError;
            }
            throw new RuntimeException("Fatal error: " + deployError.toString(), deployError);
        }
        return result;
    }

    protected void cancelImpl() {
        for (IOperation op : this.mPendingOps) {
            op.cancel();
        }
    }
}

