/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.util.BlobStoreHelper;
import com.ibm.neo.dataimport.util.LockHelper;
import com.ibm.neo.dataimport.util.RemovePluginHelper;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.util.ops.RunnableOperation;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataSourceOp
extends RunnableOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveDataSourceOp.class);
    private final ImportService mImportService;
    private final IONObjectId mDataSourceId;
    private final boolean mDropDatasets;
    private final boolean mDropTables;
    private final boolean mReplaceHint;
    private final boolean mRemoveReplacementDs;
    private final boolean mRequiresLock;
    private RemovePluginHelper mPluginHelper;
    private final Logger mLogger = LoggerFactory.getLogger(RemoveDataSourceOp.class);

    public RemoveDataSourceOp(ImportService importService, IONObjectId dataSourceId, boolean dropDatasets, boolean dropTables, boolean removeReplacementDataSource, boolean replaceHint, boolean requiresLock) {
        if (null == importService) {
            throw new NullArgumentException("importService");
        }
        if (null == dataSourceId) {
            throw new NullArgumentException("dataSourceId");
        }
        this.mImportService = importService;
        this.mDataSourceId = dataSourceId;
        this.mDropDatasets = dropDatasets;
        this.mDropTables = dropTables;
        this.mRemoveReplacementDs = removeReplacementDataSource;
        this.mReplaceHint = replaceHint;
        this.mRequiresLock = requiresLock;
        this.mPluginHelper = new RemovePluginHelper(this.mImportService.getPluginManager()).withConfiguration(this.mImportService.getConfiguration()).withCDFService(this.mImportService.getCDFService()).withPersistenceService(PersistenceService.getInstance()).withReplaceHint(replaceHint);
        this.setTotalWork(3L);
    }

    protected void runImpl() throws Exception {
        try {
            this.doRemoveDataSource();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveDataSource() throws Exception {
        DLock dataSourceLock;
        PersistenceService ps = this.mImportService.getPersistenceService();
        WranglerService wrangler = this.mImportService.getWranglerService();
        if (this.mRequiresLock) {
            dataSourceLock = LockHelper.acquireDataSourceLock(wrangler, this.mDataSourceId, 120L);
            if (null == dataSourceLock) {
                LOGGER.error("Timed out waiting for data source lock (dataSourceId={})", (Object)this.mDataSourceId.getIdentifier());
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.RESOURCE_BUSY).build();
            }
        } else {
            dataSourceLock = null;
        }
        try {
            NobjectCollection dataSourceCol = ImportPersistence.getUserDataSourceCollection((PersistenceService)ps);
            UserDataSource dataSource = (UserDataSource)dataSourceCol.get(this.mDataSourceId);
            if (null == dataSource) {
                return;
            }
            if (this.mRemoveReplacementDs) {
                this.removeReplacementDataSource(dataSource);
            }
            this.removeDataSource(dataSource);
            this.setCompletedWork(this.getTotalWork());
        }
        finally {
            if (null != dataSourceLock) {
                dataSourceLock.release();
            }
        }
    }

    private void removeDataSource(UserDataSource dataSource) throws Exception {
        PersistenceService ps = this.mImportService.getPersistenceService();
        this.mLogger.info("Removing data source (name={}, _id={})", (Object)dataSource.getName(), (Object)dataSource.getId().getIdentifier());
        if (dataSource instanceof DocumentDataSource) {
            this.removeSheets(((DocumentDataSource)dataSource).getDocument());
            for (DocumentModel doc : ((DocumentDataSource)dataSource).getAppendedDocuments()) {
                this.removeSheets(doc);
            }
            if (dataSource instanceof UploadDataSource) {
                this.deleteUploadedFile((UploadDataSource)dataSource);
            }
        }
        this.setCompletedWork(this.getCompletedWork() + 1L);
        if (this.isCanceled()) {
            throw new CancellationException();
        }
        if (this.mDropDatasets) {
            NobjectCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)ps);
            List datasets = datasetCol.find(new QueryBuilder().equalTo("data-source-id", (Object)dataSource.getId()).toDocument()).toListAndClose();
            for (Dataset ds : datasets) {
                if (this.isCanceled()) {
                    throw new CancellationException();
                }
                this.mImportService.removeDataset(ds, this.mDropTables, this.mReplaceHint);
            }
        }
        this.setCompletedWork(this.getCompletedWork() + 1L);
        if (this.isCanceled()) {
            throw new CancellationException();
        }
        ImportPersistence.getUserDataSourceCollection((PersistenceService)ps).remove(dataSource.getId());
        this.mPluginHelper.dataSourceRemoved(dataSource);
        this.setCompletedWork(this.getCompletedWork() + 1L);
    }

    private void removeReplacementDataSource(UserDataSource dataSource) throws Exception {
        IONObjectId replacementId = dataSource.getReplacementDataSourceId();
        if (replacementId != null) {
            UserDataSource replaceDs = (UserDataSource)ImportPersistence.getUserDataSourceCollection().get(replacementId);
            if (replaceDs != null) {
                this.mLogger.info("Removing replacement data source (name={}, _id={})", (Object)replaceDs.getName(), (Object)replacementId.getIdentifier());
                RemoveDataSourceOp removeOp = new RemoveDataSourceOp(this.mImportService, replacementId, true, true, false, false, false);
                removeOp.run();
                removeOp.join();
            }
            dataSource.setReplacementDataSourceId(null);
        }
    }

    private void removeSheets(DocumentModel doc) throws IOException {
        if (null == doc) {
            return;
        }
        ICDFSheetLibrary sheetLib = this.mImportService.getCDFService().getSheetLibrary();
        ArrayList<String> sheetsToRemove = new ArrayList<String>();
        for (DocumentSection section : doc.getSections()) {
            this.collectSheets(section, sheetsToRemove);
        }
        this.mLogger.info("Removing sheets: {}", sheetsToRemove);
        for (String sheetId : sheetsToRemove) {
            try {
                ICDFSheet sheet = this.mImportService.getCDFService().getSheetLibrary().load(sheetId);
                sheetLib.remove(sheetId);
                if (sheet == null) continue;
                sheet.destroy();
            }
            catch (NoSuchSheetException ex) {
                this.mLogger.warn("Sheet not found: " + sheetId);
            }
        }
    }

    private void collectSheets(DocumentSection section, List<String> sheetList) {
        SheetInfo sheetInfo = section.getSheetInfo();
        if (null != sheetInfo && null != sheetInfo.getSheetId()) {
            sheetList.add(sheetInfo.getSheetId());
        }
        for (DocumentSection child : section.getChildren()) {
            this.collectSheets(child, sheetList);
        }
    }

    private void deleteUploadedFile(UploadDataSource dataSource) {
        if (null != dataSource.getBlobContainer() && null != dataSource.getBlobKey()) {
            try {
                IBlobStore store = this.mImportService.getBlobStore();
                IBlobContainer container = BlobStoreHelper.getUploadsContainer(store);
                container.delete(dataSource.getBlobKey());
            }
            catch (Exception ex) {
                this.mLogger.error("Failed to delete uploaded file", (Throwable)ex);
            }
        }
    }

    protected void cancelImpl() {
    }
}

