/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.dataimport.ColumnRemapHelper;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.RemoveDataSourceOp;
import com.ibm.neo.dataimport.api.EImportFeedbackCode;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.ImportSlip;
import com.ibm.neo.dataimport.api.ImportSlipReader;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.ops.AnalyzeResult;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.ops.ReplaceDocumentResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.util.BlobStoreHelper;
import com.ibm.neo.dataimport.util.ImportFeedbackParser;
import com.ibm.neo.dataimport.util.LockHelper;
import com.ibm.neo.exception.WatsonMessageContext;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.util.ops.IProgress;
import com.ibm.neo.util.ops.ProgressAggregator;
import com.ibm.neo.util.ops.StaticProgressAggregator;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerService;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceDocumentOp
extends CallableOperation<ReplaceDocumentResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceDocumentOp.class);
    private static final long TOTAL_WORK = 100L;
    private static final double CLEANUP_WEIGHT = 0.014285714285714285;
    private static final double DEPLOY_WEIGHT = 0.12857142857142856;
    private static final IProgress COMPLETED_OP = new IProgress(){

        public long getTotalWork() {
            return 1L;
        }

        public long getCompletedWork() {
            return 1L;
        }

        public double getPercentCompleted() {
            return 100.0;
        }

        public void addProgressObserver(IObserver<IProgress> observer) {
            observer.updated((Object)this);
        }

        public void removeProgressObserver(IObserver<IProgress> observer) {
        }
    };
    private final ProgressAggregator mProgressAggregator;
    private final AccessControlService mACS;
    private final ImportService mImportService;
    private DocumentDataSource mDataSource;
    private final String mFilename;
    private final InputStream mContentStream;
    private final String mContentType;
    private final Long mContentSize;
    private final String mHashValue;
    private final IONObject mImportSlip;
    private volatile IOperationWithResult<UploadDataSource> mUploadOp;
    private volatile IOperationWithResult<AnalyzeResult> mAnalyzeOp;
    private volatile IOperationWithResult<DeployResult> mDeployOp;
    private boolean mResumeFromAnalyse = false;

    public ReplaceDocumentOp(AccessControlService acs, ImportService importService, DocumentDataSource dataSource, String filename, InputStream contentStream, String contentType, Long contentSize, String hashValue, IONObject importSlip) {
        this.mACS = acs;
        this.mImportService = importService;
        this.mDataSource = dataSource;
        this.mFilename = filename;
        this.mContentStream = contentStream.markSupported() ? contentStream : new BufferedInputStream(contentStream);
        this.mContentType = contentType;
        this.mContentSize = contentSize;
        this.mHashValue = hashValue;
        this.mImportSlip = importSlip;
        this.setTotalWork(100L);
        this.mProgressAggregator = new StaticProgressAggregator((IObserver)new IObserver<ProgressAggregator>(){

            public void updated(ProgressAggregator subject) {
                ReplaceDocumentOp.this.setCompletedWork((int)Math.ceil(subject.getPercentCompleted()));
            }
        }, 100.0);
    }

    protected ReplaceDocumentResult callImpl() throws Exception {
        try {
            return this.doReplaceDocument();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplaceDocumentResult doReplaceDocument() throws Exception {
        PersistenceService ps = this.mImportService.getPersistenceService();
        WranglerService wrangler = this.mImportService.getWranglerService();
        DLock dataSourceLock = LockHelper.acquireDataSourceLock(wrangler, this.mDataSource.getId(), 120L);
        if (null == dataSourceLock) {
            LOGGER.error("Timed out waiting for data source lock (dataSourceId={})", (Object)this.mDataSource.getId().getIdentifier());
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.RESOURCE_BUSY).build();
        }
        try {
            List<Database> deployTargetDbs;
            List<Dataset> newDatasets;
            NobjectCollection dataSourceCol = ImportPersistence.getUserDataSourceCollection((PersistenceService)ps);
            NobjectCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)ps);
            this.mDataSource = (DocumentDataSource)dataSourceCol.get(this.mDataSource.getId());
            if (null == this.mDataSource) {
                throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.DATA_SOURCE_MISSING).withMessage((IMessageKey)NeoImportError.DATA_REMOVED).build();
            }
            List<Dataset> oldDatasets = this.mImportService.listDatasets(this.mDataSource.getId());
            this.setResumeFlag();
            DocumentDataSource replacementDS = this.selectReplacementDataSource();
            try {
                newDatasets = this.analyze(replacementDS);
                this.ensureDatasetCompatibility((UserDataSource)replacementDS, oldDatasets, newDatasets);
                this.incrementVersions(oldDatasets, newDatasets);
                deployTargetDbs = this.findExistingDeploymentDatabases(oldDatasets);
            }
            catch (Exception e) {
                if (replacementDS != this.mDataSource) {
                    if (this.isExceptionResumable(e)) {
                        this.linkToReplacementDataSource(replacementDS);
                    } else {
                        this.removeReplacementDataSource(replacementDS.getId());
                    }
                }
                throw e;
            }
            CleanupOrphansTransaction cleanupTx = this.prepareCleanupTransaction((UserDataSource)this.mDataSource, (UserDataSource)replacementDS, oldDatasets);
            if (replacementDS != this.mDataSource) {
                replacementDS.setId(this.mDataSource.getId());
                replacementDS.setLastModifiedTime(new Date());
                replacementDS.setOwnerId(this.mDataSource.getOwnerId());
            }
            dataSourceCol.save((Nobject)replacementDS);
            for (Dataset dataset : newDatasets) {
                datasetCol.save((Nobject)dataset);
            }
            cleanupTx.commit();
            this.mProgressAggregator.addSource(COMPLETED_OP, 0.014285714285714285);
            ReplaceDocumentResult replaceResult = new ReplaceDocumentResult((UserDataSource)replacementDS);
            for (Dataset dataset : newDatasets) {
                List<DeployResult> deployments = this.deploy(dataset, deployTargetDbs, 0.12857142857142856 / (double)newDatasets.size());
                replaceResult.getDeployments().addAll(deployments);
            }
            ReplaceDocumentResult replaceDocumentResult = replaceResult;
            return replaceDocumentResult;
        }
        finally {
            dataSourceLock.release();
        }
    }

    private void linkToReplacementDataSource(DocumentDataSource replacementDS) throws PersistenceException, WAImportException {
        IONObjectId existingReplacementDsId = this.mDataSource.getReplacementDataSourceId();
        if (replacementDS.getId().equals((Object)existingReplacementDsId)) {
            return;
        }
        if (existingReplacementDsId != null) {
            this.removeReplacementDataSource(existingReplacementDsId);
        }
        this.mDataSource.setReplacementDataSourceId(replacementDS.getId());
        ImportPersistence.getUserDataSourceCollection((PersistenceService)this.mImportService.getPersistenceService()).save((Nobject)this.mDataSource);
    }

    private DocumentDataSource selectReplacementDataSource() throws WAImportException {
        UploadDataSource replacementDS;
        if (this.mResumeFromAnalyse) {
            IONObjectId replacementId = this.mDataSource.getReplacementDataSourceId();
            if (replacementId != null) {
                replacementDS = (UploadDataSource)this.mImportService.getDataSource(replacementId);
                if (replacementDS == null) {
                    throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_REPLACEMENT_DS_MISSING, new Object[]{replacementId}).build();
                }
                LOGGER.info("Resuming the replacement of data source {} with the contents of data source {}.", (Object)this.mDataSource.getId().getIdentifier(), (Object)replacementId.getIdentifier());
            } else {
                replacementDS = this.mDataSource;
            }
            replacementDS.getExtendedFields().put((Object)"import-slip", (Object)this.mImportSlip);
            this.mProgressAggregator.addSource(COMPLETED_OP, 0.5714285714285714);
        } else {
            replacementDS = this.upload();
        }
        return replacementDS;
    }

    private List<Database> findExistingDeploymentDatabases(List<Dataset> oldDatasets) throws WAStorageException, PersistenceException {
        StorageService storageService = this.mImportService.getStorageService();
        HashMap<IONObjectId, Database> id2Db = new HashMap<IONObjectId, Database>();
        Tenant tenant = this.mACS.getCurrentTenant();
        String requiredDbPool = null != tenant.getDatabasePool() ? tenant.getDatabasePool() : "default";
        for (Dataset dataset : oldDatasets) {
            List tables = storageService.listTables(tenant.getId(), null, dataset.getId(), null, null, false, false);
            LOGGER.info("Found {} tables where dataset (_id={}) may be deployed to", (Object)tables.size(), (Object)dataset.getId().getIdentifier());
            for (Table t : tables) {
                LOGGER.info("Inspecting table (_id={}, tableName={}, databaseId={})", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier()});
                if (t.getVersion() != dataset.getVersion()) {
                    LOGGER.warn("Table (_id={}, tableName={}) has inconsistent version compared to dataset (name={}, _id={}) - expected {}, but was {}", new Object[]{t.getTableName(), t.getId().getIdentifier(), dataset.getName(), dataset.getId().getIdentifier(), dataset.getVersion(), t.getVersion()});
                    continue;
                }
                if (id2Db.containsKey(t.getDatabaseId())) {
                    LOGGER.info("We already saw this databases - skipping it");
                    continue;
                }
                Database db = null;
                try {
                    db = storageService.getDatabase(t.getDatabaseId());
                }
                catch (WAStorageException.NoSuchObjectException ex) {
                    LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}) that does not exist - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier()});
                    continue;
                }
                if ("default".equals(requiredDbPool)) {
                    if (db.getPool() != null && !"default".equals(db.getPool())) {
                        LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, pool={}), but tenant is associated with different pool ({}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getPool(), requiredDbPool});
                        continue;
                    }
                } else if (!requiredDbPool.equals(db.getPool())) {
                    LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, pool={}), but tenant is associated with different pool ({}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getPool(), requiredDbPool});
                    continue;
                }
                if (db.isDisabled() || !storageService.checkDatabase(db)) {
                    LOGGER.warn("Table (_id={}, tableName={}) refers to database (_id={}, url={}) that is disable or unreachable - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getJdbcUrl()});
                    continue;
                }
                if (!storageService.checkTable(db, t.getSchemaName(), t.getTableName())) {
                    LOGGER.warn("Table (_id={}, tableName={}) does not exist in database (_id={}, url={}) - skipping it", new Object[]{t.getId().getIdentifier(), t.getTableName(), t.getDatabaseId().getIdentifier(), db.getJdbcUrl()});
                    continue;
                }
                LOGGER.info("Table (_id={}, tableName={}) exists in database (_id={}, url={}) - we will deploy here!", new Object[]{t.getId().getIdentifier(), t.getTableName(), db.getId().getIdentifier(), db.getJdbcUrl()});
                id2Db.put(db.getId(), db);
            }
        }
        return new ArrayList<Database>(id2Db.values());
    }

    private boolean isExceptionResumable(Exception e) {
        WAImportException importException;
        return e instanceof WAImportException && EImportMessageCode.ANALYZE_FEEDBACK_NEEDED.equals((Object)(importException = (WAImportException)((Object)e)).getCode());
    }

    private void setResumeFlag() throws WAImportException {
        this.mContentStream.mark(1);
        try {
            if (this.mImportSlip != null && !this.mImportSlip.isEmpty() && this.mContentStream.read() == -1) {
                LOGGER.info("Resuming import for existing data source {}.", (Object)this.mDataSource.getId().getIdentifier());
                this.mResumeFromAnalyse = true;
            } else {
                this.mContentStream.reset();
            }
        }
        catch (Exception e) {
            throw new WAImportException(null, (Throwable)e, null);
        }
    }

    private UploadDataSource upload() throws WAImportException {
        try {
            this.mUploadOp = this.mImportService.uploadDocument(this.mFilename, this.mContentType, this.mContentStream, this.mContentSize, this.mHashValue, this.mImportSlip, this.mDataSource.getContentSize());
            this.mProgressAggregator.addSource(this.mUploadOp, 0.5714285714285714);
            UploadDataSource uploadDataSource = (UploadDataSource)this.mUploadOp.joinWithResult();
            return uploadDataSource;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to upload document: " + this.mFilename, ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mUploadOp = null;
        }
    }

    private List<Dataset> analyze(DocumentDataSource dataSource) throws WAImportException {
        this.mAnalyzeOp = this.mImportService.analyzeDataSource((UserDataSource)dataSource, this.mImportSlip);
        try {
            this.mProgressAggregator.addSource(this.mAnalyzeOp, 0.2857142857142857);
            List list = ((AnalyzeResult)this.mAnalyzeOp.joinWithResult()).getDatasets();
            return list;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to analyze data source: " + dataSource.getId(), ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mAnalyzeOp = null;
        }
    }

    private CleanupOrphansTransaction prepareCleanupTransaction(UserDataSource currentDataSource, UserDataSource replacementDataSource, List<Dataset> datasets) throws Exception {
        CleanupOrphansTransaction cleanupTx = new CleanupOrphansTransaction();
        if (currentDataSource != replacementDataSource) {
            UserDataSource otherReplacementDataSource;
            cleanupTx.addDataSourceId(replacementDataSource.getId());
            if (currentDataSource instanceof DocumentDataSource) {
                cleanupTx.addSheets(this.collectSheets(((DocumentDataSource)currentDataSource).getDocument()));
                if (currentDataSource instanceof UploadDataSource) {
                    cleanupTx.addBlobKey(((UploadDataSource)currentDataSource).getBlobKey());
                }
            }
            if (null != currentDataSource.getReplacementDataSourceId() && !replacementDataSource.getId().equals((Object)currentDataSource.getReplacementDataSourceId()) && null != (otherReplacementDataSource = (UserDataSource)ImportPersistence.getUserDataSourceCollection().get(currentDataSource.getReplacementDataSourceId()))) {
                cleanupTx.addDataSourceId(otherReplacementDataSource.getId());
                if (otherReplacementDataSource instanceof DocumentDataSource) {
                    cleanupTx.addSheets(this.collectSheets(((DocumentDataSource)otherReplacementDataSource).getDocument()));
                    if (otherReplacementDataSource instanceof UploadDataSource) {
                        cleanupTx.addBlobKey(((UploadDataSource)otherReplacementDataSource).getBlobKey());
                    }
                }
            }
        }
        if (null != datasets) {
            cleanupTx.addTables(this.collectTables(datasets));
        }
        return cleanupTx;
    }

    private List<DeployResult> deploy(Dataset dataset, List<Database> deployTargetDbs, double deployWeight) throws WAImportException {
        ArrayList<DeployResult> deployments = new ArrayList<DeployResult>();
        try {
            if (deployTargetDbs.size() > 0) {
                double adjustedDeployWeight = deployWeight / (double)deployTargetDbs.size();
                for (Database db : deployTargetDbs) {
                    this.mDeployOp = this.mImportService.deployDataset(dataset, db);
                    this.mProgressAggregator.addSource(this.mDeployOp, adjustedDeployWeight);
                    deployments.add((DeployResult)this.mDeployOp.joinWithResult());
                }
            } else {
                this.mDeployOp = this.mImportService.deployDataset(dataset);
                this.mProgressAggregator.addSource(this.mDeployOp, deployWeight);
                deployments.add((DeployResult)this.mDeployOp.joinWithResult());
            }
        }
        catch (ExecutionException ex) {
            LOGGER.error("Failed to deploy dataset: " + dataset.getName(), ex.getCause());
            if (ex.getCause() instanceof WAImportException) {
                throw (WAImportException)ex.getCause();
            }
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.UNEXPECTED_ERROR).withCause(ex.getCause()).build();
        }
        finally {
            this.mDeployOp = null;
        }
        return deployments;
    }

    private void ensureDatasetCompatibility(UserDataSource replacementDataSource, List<Dataset> oldDatasets, List<Dataset> newDatasets) throws WAImportException {
        if (replacementDataSource != this.mDataSource && oldDatasets.size() > 0 && oldDatasets.size() != newDatasets.size()) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.INCONSISTENT_DATASET_COUNT, new Object[]{String.valueOf(oldDatasets.size()), String.valueOf(newDatasets.size())}).withConditionCode(EImportMessageCode.REPLACE_INCONSISTENT_DATASET_COUNT).build();
        }
        ImportSlipReader.ISDataSource dataSourceSlip = new ImportSlipReader(this.mImportSlip).dataSource();
        ImportSlip.UnmatchedColumnsMode unmatchedColumnsMode = dataSourceSlip.getUnmatchedColumnsMode();
        for (int i = 0; i < newDatasets.size(); ++i) {
            Dataset newDataset = newDatasets.get(i);
            if (oldDatasets.size() > i) {
                Dataset oldDataset = oldDatasets.get(i);
                try {
                    Map<EImportFeedbackCode, Boolean> feedbackModes = ImportFeedbackParser.determineFeedbackModes(this.mImportService.getConfiguration());
                    new ColumnRemapHelper(oldDataset, newDataset, unmatchedColumnsMode, dataSourceSlip.getDataset(i), feedbackModes).apply();
                }
                catch (WAImportException e) {
                    if (EImportMessageCode.ANALYZE_FEEDBACK_NEEDED.equals((Object)e.getCode())) {
                        WatsonMessageContext context = e.getWatsonMessageContext();
                        context.putItem((Enum)EImportMessageContext.DATASET_INDEX, (Object)i);
                        context.putItem((Enum)EImportMessageContext.DATA_SOURCE_NAME, (Object)this.mDataSource.getName());
                    }
                    throw e;
                }
                newDataset.setId(oldDataset.getId());
                newDataset.setName(oldDataset.getName());
            }
            newDataset.setDataSourceId(this.mDataSource.getId());
        }
    }

    private void incrementVersions(List<Dataset> oldDatasets, List<Dataset> newDatasets) {
        for (int i = 0; i < newDatasets.size(); ++i) {
            if (oldDatasets.size() <= i) continue;
            Dataset newDataset = newDatasets.get(i);
            Dataset oldDataset = oldDatasets.get(i);
            newDataset.setVersion(oldDataset.getVersion() + 1);
        }
    }

    private void removeReplacementDataSource(IONObjectId dataSourceId) {
        if (dataSourceId != null) {
            try {
                UserDataSource replaceDs = (UserDataSource)ImportPersistence.getUserDataSourceCollection().get(dataSourceId);
                if (replaceDs != null) {
                    LOGGER.info("Removing replacement data source (name={}, _id={})", (Object)replaceDs.getName(), (Object)dataSourceId.getIdentifier());
                    RemoveDataSourceOp removeOp = new RemoveDataSourceOp(this.mImportService, dataSourceId, false, false, false, false, false);
                    removeOp.run();
                    removeOp.join();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to remove replacement data source", (Throwable)ex);
            }
        }
    }

    private List<String> collectSheets(DocumentModel model) {
        ArrayList<String> sheets = new ArrayList<String>();
        for (DocumentSection section : model.getSections()) {
            this.collectSheets(section, sheets);
        }
        return sheets;
    }

    private void collectSheets(DocumentSection section, List<String> sheetList) {
        SheetInfo sheetInfo = section.getSheetInfo();
        if (null != sheetInfo && null != sheetInfo.getSheetId()) {
            sheetList.add(sheetInfo.getSheetId());
        }
        for (DocumentSection child : section.getChildren()) {
            this.collectSheets(child, sheetList);
        }
    }

    private List<Table> collectTables(List<Dataset> datasets) throws WAStorageException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StorageService storage = this.mImportService.getStorageService();
        for (Dataset ds : datasets) {
            for (Table t : storage.listTables(null, null, ds.getId(), null, null, true, true)) {
                if (t.getVersion() > ds.getVersion()) continue;
                tables.add(t);
            }
        }
        return tables;
    }

    protected void cancelImpl() {
        IOperationWithResult<UploadDataSource> op = this.mUploadOp;
        if (null != op) {
            op.cancel();
        }
        if (null != (op = this.mAnalyzeOp)) {
            op.cancel();
        }
        if (null != (op = this.mDeployOp)) {
            op.cancel();
        }
    }

    private final class CleanupOrphansTransaction {
        private final List<String> sheets = new ArrayList<String>();
        private final List<String> blobKeys = new ArrayList<String>();
        private final List<IONObjectId> dataSourceIds = new ArrayList<IONObjectId>();
        private final List<Table> tables = new ArrayList<Table>();

        private CleanupOrphansTransaction() {
        }

        public void addSheets(List<String> sheets) {
            this.sheets.addAll(sheets);
        }

        public void addBlobKey(String blobKey) {
            this.blobKeys.add(blobKey);
        }

        public void addDataSourceId(IONObjectId dataSourceId) {
            this.dataSourceIds.add(dataSourceId);
        }

        public void addTables(List<Table> tables) {
            this.tables.addAll(tables);
        }

        public void commit() {
            StorageService storage = ReplaceDocumentOp.this.mImportService.getStorageService();
            IBlobStore store = ReplaceDocumentOp.this.mImportService.getBlobStore();
            ICDFSheetLibrary sheetLib = ReplaceDocumentOp.this.mImportService.getCDFService().getSheetLibrary();
            LOGGER.info("Commiting cleanup of orphaned artifacts");
            for (String sheetId : this.sheets) {
                try {
                    LOGGER.info("Removing orphaned sheet: {}", (Object)sheetId);
                    sheetLib.remove(sheetId);
                }
                catch (NoSuchSheetException ex) {
                    LOGGER.warn("Sheet not found: {}" + sheetId);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to remove sheet", (Throwable)ex);
                }
            }
            for (String blobKey : this.blobKeys) {
                try {
                    IBlobContainer container = BlobStoreHelper.getUploadsContainer(store);
                    LOGGER.info("Deleting orphaned upload blob: {}", (Object)blobKey);
                    container.delete(blobKey);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to delete upload blob", (Throwable)ex);
                }
            }
            for (IONObjectId dataSourceId : this.dataSourceIds) {
                try {
                    LOGGER.info("Removing orphaned data source (_id={})", (Object)dataSourceId.getIdentifier());
                    ImportPersistence.getUserDataSourceCollection().remove(dataSourceId);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to remove orphaned data source", (Throwable)ex);
                }
            }
            for (Table t : this.tables) {
                try {
                    LOGGER.info("Attempting to drop orphaned table (_id={}, name={})", (Object)t.getId().getIdentifier(), (Object)t.getTableName());
                    storage.dropTable(t, 15);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to drop table", (Throwable)ex);
                }
            }
        }
    }
}

