/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.CDFService;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.util.ops.CallableOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrapeDocumentOp
extends CallableOperation<ScrapeResult> {
    private static final Logger LOG = LoggerFactory.getLogger(ScrapeDocumentOp.class);
    private final ImportService mImportService;
    private final FileResource mResource;
    private final String mMimeType;
    private final ScrapeOptions mOptions;

    public ScrapeDocumentOp(ImportService importService, FileResource resource, String mimeType, ScrapeOptions options) {
        this.mImportService = importService;
        this.mResource = resource;
        this.mMimeType = mimeType;
        this.mOptions = options;
        this.setTotalWork(resource.length());
    }

    protected ScrapeResult callImpl() throws Exception {
        try {
            return this.doScrape();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private synchronized ScrapeResult doScrape() throws Exception {
        CDFService cdfService = this.mImportService.getCDFService();
        return cdfService.scrapeDocument(this.mResource.getName(), this.mMimeType, this.mResource.getPhysicalFile(), this.mOptions);
    }

    protected synchronized void cancelImpl() {
        ScrapeResult result = (ScrapeResult)this.getResult();
        if (null != result) {
            ICDFSheetLibrary sheetLib = this.mImportService.getCDFService().getSheetLibrary();
            for (ICDFSheet s : result.getSheets().values()) {
                try {
                    sheetLib.remove(s.getId());
                }
                catch (Exception ex) {
                    LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
                try {
                    s.destroy();
                }
                catch (Exception ex) {
                    LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
    }
}

