/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.dataimport.CreateBlobOp;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.ScrapeDocumentOp;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.EImportMessageContext;
import com.ibm.neo.dataimport.api.ImportSlipReader;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.backpack.IBackPackIndex;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.nodel.DocumentMetadata;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UploadDataSource;
import com.ibm.neo.dataimport.resource.FileResource;
import com.ibm.neo.dataimport.resource.FileResourceGovernor;
import com.ibm.neo.dataimport.resource.WriteResourceOp;
import com.ibm.neo.dataimport.resource.WriteResourceOpFactory;
import com.ibm.neo.dataimport.util.BlobStoreHelper;
import com.ibm.neo.dataimport.util.ImportQuotas;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.CallableOperation;
import com.ibm.neo.util.ops.IOperation;
import com.ibm.neo.util.ops.IOperationWithResult;
import com.ibm.neo.util.ops.IProgress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class UploadDocumentOp
extends CallableOperation<UploadDataSource> {
    private static final int CONSUME_PROGRESS_WEIGHT = 100;
    private static final int STORE_PROGRESS_WEIGHT = 100;
    private static final int SCRAPE_PROGRESS_WEIGHT = 100;
    private final ImportService mImportService;
    private final String mFileName;
    private final String mContentType;
    private final InputStream mContentStream;
    private final Long mExpectedContentSize;
    private final String mExpectedHash;
    private String mComputedHash = null;
    private final IONObjectId mDataSourceId;
    private IONObject mImportSlip;
    private final long mStorageQuotaDeduction;
    private volatile IOperation mConsumeOp;
    private volatile IOperation mStoreOp;
    private volatile IOperation mScrapeOp;

    public UploadDocumentOp(ImportService importService, String fileName, String contentType, InputStream contentStream, Long contentSize, String expectedHash, IONObjectId dataSourceId, IONObject importSlip) {
        this(importService, fileName, contentType, contentStream, contentSize, expectedHash, dataSourceId, importSlip, 0L);
    }

    public UploadDocumentOp(ImportService importService, String fileName, String contentType, InputStream contentStream, Long contentSize, String expectedHash, IONObjectId dataSourceId, IONObject importSlip, long storageQuotaDeduction) {
        this.mImportService = importService;
        this.mFileName = fileName;
        this.mContentType = contentType;
        this.mContentStream = contentStream;
        this.mExpectedContentSize = contentSize;
        this.mDataSourceId = dataSourceId;
        this.mImportSlip = importSlip;
        this.mStorageQuotaDeduction = storageQuotaDeduction;
        this.mExpectedHash = null != expectedHash ? expectedHash.toLowerCase() : null;
        this.setTotalWork(300L);
    }

    public IONObjectId getDataSourceId() {
        return this.mDataSourceId;
    }

    protected UploadDataSource callImpl() throws Exception {
        try {
            return this.doUploadDocument();
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
    }

    private UploadDataSource doUploadDocument() throws Exception {
        FileResource[] resources = this.consumeContentStream();
        IBackPackIndex backpackIndex = null;
        if (this.mImportService.getBackPackService() != null) {
            backpackIndex = this.mImportService.getBackPackService().getBackPack(resources, this.mContentType);
        }
        try {
            if (backpackIndex != null && backpackIndex.isBackPack(resources)) {
                resources = this.mImportService.getBackPackService().getDataSources(backpackIndex);
            }
            UploadDataSource uploadDataSource = this.createDatasource(resources, backpackIndex);
            return uploadDataSource;
        }
        catch (WAImportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WAImportException.Builder().withCause((Throwable)ex).build();
        }
        finally {
            if (resources != null) {
                for (int i = 0; i < resources.length; ++i) {
                    if (null == resources[i]) continue;
                    resources[i].deleteQuietly();
                }
            }
        }
    }

    private UploadDataSource createDatasource(FileResource[] resources, IBackPackIndex backpackIndex) throws Exception {
        if (this.isCanceled()) {
            throw new CancellationException();
        }
        if (resources == null && backpackIndex == null) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.NO_DATASETS_FOUND).build();
        }
        UploadDataSource dataSource = null;
        ArrayList<DocumentType> unknownTypes = new ArrayList<DocumentType>();
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                FileResource res = resources[i];
                DocumentType docType = this.mImportService.getCDFService().inferDocumentType(res.getName(), this.mContentType);
                if (!docType.isUnknown()) {
                    if (res.getContentType() == null && !docType.getMimeTypes().isEmpty()) {
                        res.setContentType((String)docType.getMimeTypes().get(0));
                    }
                    dataSource = this.createUploadDataSource(res, !docType.isCompressed(), backpackIndex);
                    break;
                }
                unknownTypes.add(docType);
            }
        }
        if (backpackIndex != null && dataSource == null) {
            dataSource = this.mImportService.getBackPackService().loadCommonMetadata(backpackIndex);
        }
        if (dataSource == null && !unknownTypes.isEmpty()) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).withMessage((IMessageKey)NeoImportError.DOCUMENT_TYPE_NOT_SUPPORTED).build();
        }
        if (dataSource == null) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.NO_DATASETS_FOUND).build();
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileResource[] consumeContentStream() throws Exception {
        FileResource[] resources;
        ImportQuotas quotas = this.mImportService.getImportQuotas();
        FileResourceGovernor gov = new FileResourceGovernor(quotas.getMaxFileSize(), quotas.getMaxFileUploadCount());
        MessageDigest sha1 = DigestUtils.getSha1Digest();
        DigestInputStream digestStream = new DigestInputStream(this.mContentStream, sha1);
        try {
            WriteResourceOp consumeOp = WriteResourceOpFactory.create(new File(this.mImportService.getTempDir(), "Uploads"), this.mFileName, this.mContentType, digestStream, this.mExpectedContentSize, gov);
            consumeOp.addProgressObserver((IObserver)new IObserver<IProgress>(){

                public void updated(IProgress subject) {
                    UploadDocumentOp.this.updateOverallProgress();
                }
            });
            this.mConsumeOp = consumeOp;
            resources = (FileResource[])consumeOp.call();
            if (consumeOp.hasFailed()) {
                Throwable t = consumeOp.getError();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw WAImportException.newBuilder().withCause(t).build();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)digestStream);
        }
        this.verifyContentNotEmpty(resources);
        this.mComputedHash = new String(Hex.encodeHex((byte[])sha1.digest(), (boolean)true));
        if (null != this.mExpectedHash && this.mExpectedHash.length() > 0 && !this.mExpectedHash.equals(this.mComputedHash)) {
            for (FileResource resource : resources) {
                resource.deleteQuietly();
            }
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.SHA1_HASH_MISMATCH).withContextAttribute(EImportMessageContext.FILE_NAME, (Object)this.mFileName).withContextAttribute(EImportMessageContext.FILE_CONTENT_TYPE, (Object)this.mContentType).withContextAttribute(EImportMessageContext.EXPECTED_SHA1_HASH, (Object)this.mExpectedHash).withContextAttribute(EImportMessageContext.COMPUTED_SHA1_HASH, (Object)this.mComputedHash).build();
        }
        return resources;
    }

    private void verifyContentNotEmpty(FileResource[] resources) throws WAImportException {
        boolean foundNonEmptyFile = false;
        for (FileResource resource : resources) {
            if (resource.length() <= 0L) continue;
            foundNonEmptyFile = true;
            break;
        }
        if (!foundNonEmptyFile) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.EMPTY_DATASET).withMessage((IMessageKey)NeoImportError.NO_DATASETS_FOUND).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadDataSource createUploadDataSource(FileResource resource, boolean isCompressable, IBackPackIndex bp) throws Exception {
        UploadDataSource dataSource = new UploadDataSource();
        ImportSlipReader isReader = new ImportSlipReader(this.mImportSlip);
        if (StringUtils.isEmpty((String)isReader.dataSource().getName())) {
            dataSource.setName(resource.getName());
        } else {
            dataSource.setName(isReader.dataSource().getName());
        }
        dataSource.setContentSize(resource.length());
        if (this.mImportSlip != null) {
            dataSource.getExtendedFields().put((Object)"import-slip", (Object)this.mImportSlip);
        }
        boolean shouldDetectXTab = dataSource.getName().contains("XTAB");
        dataSource.getExtendedFields().put((Object)"xtab-detect", (Object)shouldDetectXTab);
        if (this.mImportService.getBackPackService() != null) {
            this.mImportService.getBackPackService().addMetadata((DocumentDataSource)dataSource, bp);
        }
        IOperationWithResult<IBlob> storeOp = this.beginStoreDocument(resource, isCompressable);
        IOperationWithResult<ScrapeResult> scrapeOp = this.beginScrapeDocument(resource, dataSource.getMetadata());
        IBlob blob = null;
        ScrapeResult scrapeResult = null;
        Exception childOpException = null;
        try {
            try {
                scrapeResult = (ScrapeResult)scrapeOp.joinWithResult();
            }
            catch (Exception ex) {
                childOpException = ex;
                storeOp.cancel();
                storeOp.waitFor();
                blob = (IBlob)storeOp.getResult();
            }
            if (blob == null && !storeOp.isCanceled()) {
                try {
                    blob = (IBlob)storeOp.joinWithResult();
                }
                catch (Exception ex) {
                    childOpException = ex;
                }
            }
            try {
                this.mImportService.getImportQuotas().checkDiskUsage(dataSource.getContentSize() - this.mStorageQuotaDeduction);
            }
            catch (Exception ex) {
                childOpException = ex;
            }
        }
        finally {
            if (childOpException != null) {
                if (scrapeResult != null) {
                    for (ICDFSheet sheet : scrapeResult.getSheets().values()) {
                        try {
                            this.mImportService.getCDFService().getSheetLibrary().remove(sheet.getId());
                        }
                        catch (Exception exception) {}
                        try {
                            sheet.destroy();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (blob != null) {
                    try {
                        blob.remove();
                    }
                    catch (Exception ex) {}
                }
                if (childOpException instanceof ExecutionException) {
                    Throwable cause = childOpException.getCause();
                    childOpException = cause instanceof Exception ? (Exception)cause : new RuntimeException("Fatal internal error: " + cause.toString(), cause);
                }
                throw childOpException;
            }
        }
        dataSource.setId(this.mDataSourceId);
        dataSource.setBlobContainer(blob.getContainer().getName());
        dataSource.setBlobKey(blob.getKey());
        dataSource.setCreatedTime(new Date());
        dataSource.setLastModifiedTime(dataSource.getCreatedTime());
        dataSource.setDocument(scrapeResult.getDocument());
        if (null != resource.getParent()) {
            dataSource.setArchivePath(resource.getParent());
        }
        dataSource.getExtendedFields().put((Object)"hash:SHA1", (Object)this.mComputedHash);
        if (bp != null) {
            this.mImportService.getBackPackService().loadCommonMetadata(bp, (DocumentDataSource)dataSource);
        }
        ImportPersistence.getUserDataSourceCollection().save((Nobject)dataSource);
        return dataSource;
    }

    private IOperationWithResult<IBlob> beginStoreDocument(FileResource resource, boolean isCompressable) throws BlobStoreException, IOException {
        IBlobStore store = this.mImportService.getBlobStore();
        IBlobContainer container = BlobStoreHelper.getUploadsContainer(store);
        CreateBlobOp op = new CreateBlobOp(container, resource.getName(), resource.getContentType(), resource.openInputStream(), resource.length(), isCompressable);
        op.addProgressObserver((IObserver)new IObserver<IProgress>(){

            public void updated(IProgress subject) {
                UploadDocumentOp.this.updateOverallProgress();
            }
        });
        this.mStoreOp = op;
        this.mImportService.getWorkerPool().submit((IOperation)op);
        return op;
    }

    private IOperationWithResult<ScrapeResult> beginScrapeDocument(FileResource resource, DocumentMetadata documentMetadata) throws Exception {
        ScrapeOptions opts = new ScrapeOptions();
        opts.setDefaultStringLengthLimit(this.mImportService.getStringLengthLimit());
        opts.setSkipEmptyRows(this.mImportService.getSkipEmptyRows());
        if (null != documentMetadata) {
            if (documentMetadata.getStringLenghtLimit() != null) {
                opts.setDefaultStringLengthLimit(documentMetadata.getStringLenghtLimit().intValue());
            }
            if (documentMetadata.getFieldStringLengthLimits() != null) {
                opts.setFieldStringLengthLimits(documentMetadata.getFieldStringLengthLimits());
            }
            if (documentMetadata.getRowLimit() != null) {
                opts.setRowLimit(documentMetadata.getRowLimit().intValue());
            }
            if (StringUtils.isNotEmpty((String)documentMetadata.getLocale())) {
                opts.setLocale(new Locale(documentMetadata.getLocale()));
            }
            this.setCharsetScrapeOption(documentMetadata.getCharset(), opts);
            if (StringUtils.isNotEmpty((String)documentMetadata.getQuotesChar())) {
                opts.setQuoteChar(Character.valueOf(documentMetadata.getQuotesChar().charAt(0)));
            }
            if (StringUtils.isNotEmpty((String)documentMetadata.getFieldDelimiter())) {
                opts.setFieldDelimiter(documentMetadata.getFieldDelimiter());
            }
        }
        ImportSlipReader reader = new ImportSlipReader(this.mImportSlip);
        ImportSlipReader.ISDataSource dataSourceSlip = reader.dataSource();
        this.setCharsetScrapeOption(dataSourceSlip.getCharacterSetEncoding(), opts);
        if (dataSourceSlip.getFieldEncapsulator() != null) {
            opts.setQuoteChar(dataSourceSlip.getFieldEncapsulator());
        }
        ImportSlipReader.ISDataset datasetSlip = dataSourceSlip.getDataset(0);
        for (ImportSlipReader.ISDataItem di : datasetSlip.getDataItemsWithField("max-string-length")) {
            if (!di.containsKey((Object)"index") || di.getMaxStringLength() < 0) continue;
            opts.setFieldStringLengthLimit(di.getIndex(), di.getMaxStringLength());
        }
        ScrapeDocumentOp scrapeOp = new ScrapeDocumentOp(this.mImportService, resource, this.mContentType, opts);
        scrapeOp.addProgressObserver((IObserver)new IObserver<IProgress>(){

            public void updated(IProgress subject) {
                UploadDocumentOp.this.updateOverallProgress();
            }
        });
        this.mScrapeOp = scrapeOp;
        this.mImportService.getWorkerPool().submit((IOperation)scrapeOp);
        return scrapeOp;
    }

    private void setCharsetScrapeOption(String charsetName, ScrapeOptions opts) throws WAImportException {
        if (StringUtils.isNotEmpty((String)charsetName)) {
            try {
                opts.setCharset(Charset.forName(charsetName));
            }
            catch (IllegalCharsetNameException e) {
                throw WAImportException.newBuilder().withCause((Throwable)e).withMessage((IMessageKey)NeoImportError.CHARACTERSET_NOT_SUPPORTED, new Object[]{charsetName}).withConditionCode(EImportMessageCode.CHARSET_ENCODING_UNSUPPORTED).build();
            }
            catch (UnsupportedCharsetException e) {
                throw WAImportException.newBuilder().withCause((Throwable)e).withMessage((IMessageKey)NeoImportError.CHARACTERSET_NOT_SUPPORTED, new Object[]{charsetName}).withConditionCode(EImportMessageCode.CHARSET_ENCODING_UNSUPPORTED).build();
            }
        }
    }

    private void updateOverallProgress() {
        double completed = 0.0;
        if (null != this.mConsumeOp) {
            completed += 100.0 * this.mConsumeOp.getPercentCompleted() / 100.0;
        }
        if (null != this.mStoreOp) {
            completed += 100.0 * this.mStoreOp.getPercentCompleted() / 100.0;
        }
        if (null != this.mScrapeOp) {
            completed += 100.0 * this.mScrapeOp.getPercentCompleted() / 100.0;
        }
        this.setCompletedWork((long)completed);
    }

    protected void cancelImpl() {
        if (null != this.mConsumeOp) {
            this.mConsumeOp.cancel();
        }
        if (null != this.mStoreOp) {
            this.mStoreOp.cancel();
        }
        if (null != this.mScrapeOp) {
            this.mScrapeOp.cancel();
        }
    }
}

