/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.analyze;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.core.extract.parser.BooleanParser;
import com.ibm.cognos.aurora.core.extract.parser.CurrencyParser;
import com.ibm.cognos.aurora.core.extract.parser.DateParser;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.NumberParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.cognos.aurora.core.extract.parser.PercentParser;
import com.ibm.cognos.aurora.core.extract.parser.TimeParser;
import com.ibm.cognos.aurora.core.extract.parser.TimestampParser;
import com.ibm.cognos.aurora.core.extract.parser.UberParser;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.icu.util.ULocale;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.decoration.CurrencyDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.DecorationMap;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.FormatHints;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CellAnalyzer {
    private final DocumentType mDocumentType;
    private UberParser mUberParser;
    private final List<String> mNullPlaceholders;

    public CellAnalyzer(DocumentType type) {
        this(type, Collections.emptyList());
    }

    public CellAnalyzer(DocumentType type, List<String> nullPlaceholders) {
        this(type, null, nullPlaceholders);
    }

    public CellAnalyzer(DocumentType type, UberParser uberParser, List<String> nullPlaceholders) {
        this.mDocumentType = type;
        this.mUberParser = uberParser;
        this.mNullPlaceholders = nullPlaceholders;
    }

    public FormatHints guessFormatting(ICDFCell cell) {
        Pair<EDataType, FormatHints> pair = this.guessItsTimeToRefactor(cell, true, false);
        return pair == null ? null : (FormatHints)pair.getSecond();
    }

    public EDataType guessType(ICDFCell cell) {
        Pair<EDataType, FormatHints> pair = this.guessItsTimeToRefactor(cell, false, true);
        return pair == null ? null : (EDataType)pair.getFirst();
    }

    public Pair<EDataType, FormatHints> guessTypeAndFormatting(ICDFCell cell) {
        return this.guessItsTimeToRefactor(cell, true, true);
    }

    private Pair<EDataType, FormatHints> guessItsTimeToRefactor(ICDFCell cell, boolean guessFormat, boolean guessType) {
        if (this.isNull(cell)) {
            return null;
        }
        FormatHints hints = new FormatHints();
        EDataType dataType = EDataType.STRING;
        if (this.mDocumentType.hasRichDataTypes() || cell.getDataType() != EDataType.STRING) {
            DecorationMap decorations;
            if (guessFormat && null != (decorations = cell.getDecorations())) {
                for (Decoration d : decorations) {
                    NumberFormatDecoration fd;
                    if (d.getDecorationType() == EDecorationType.CURRENCY) {
                        CurrencyDecoration cd = (CurrencyDecoration)d;
                        hints.setCurrency(true);
                        hints.setCurrencySymbol(cd.getCurrencySymbol());
                        hints.setCurrencyCode(cd.getCurrencyCode());
                        continue;
                    }
                    if (d.getDecorationType() == EDecorationType.NUMBER_FORMAT) {
                        fd = (NumberFormatDecoration)d;
                        if (fd.getMultiplier() == 100) {
                            hints.setPercent(true);
                        } else if (fd.getMultiplier() == 1000) {
                            hints.setPermil(true);
                        }
                        if (fd.getFormatPattern() != null) {
                            hints.setFormatPattern(fd.getFormatPattern());
                        }
                        if (fd.getPrimaryGroupingSize() <= 0) continue;
                        hints.setGroupingSize(fd.getPrimaryGroupingSize());
                        continue;
                    }
                    if (d.getDecorationType() != EDecorationType.DATETIME_FORMAT || null == (fd = (DateTimeFormatDecoration)d).getFormatPattern()) continue;
                    hints.setFormatPattern(fd.getFormatPattern());
                }
            }
            if (guessType) {
                dataType = cell.getDataType();
            }
        } else {
            ParseResult result = new ParseResult();
            this.getParser().parse(cell.stringValue().trim(), result);
            IValue v = result.getValue();
            if (null != v) {
                if (guessFormat && v.isOK()) {
                    for (IValueDecoration d : result.getDecorations()) {
                        if (d.isCurrency()) {
                            com.ibm.cognos.aurora.api.model.value.decor.CurrencyDecoration cd = (com.ibm.cognos.aurora.api.model.value.decor.CurrencyDecoration)d;
                            hints.setCurrency(true);
                            hints.setCurrencySymbol(cd.getCurrency().getSymbol(Locale.US));
                            continue;
                        }
                        if (d.isPercent()) {
                            hints.setPercent(true);
                            continue;
                        }
                        if (!d.isThousandsSeparator()) continue;
                        hints.setGroupingSize(3);
                    }
                }
                if (guessType) {
                    switch (v.getType().getBaseType()) {
                        case BOOLEAN: {
                            dataType = EDataType.BOOLEAN;
                            break;
                        }
                        case DECIMAL: {
                            dataType = EDataType.DECIMAL64;
                            break;
                        }
                        case DOUBLE: 
                        case FLOAT: {
                            dataType = EDataType.FLOAT64;
                            break;
                        }
                        case INTEGER: {
                            dataType = EDataType.INT32;
                            break;
                        }
                        case LONG: {
                            dataType = EDataType.INT64;
                            break;
                        }
                        case DATE: {
                            dataType = EDataType.DATE;
                            break;
                        }
                        case TIME: {
                            dataType = EDataType.TIME;
                            break;
                        }
                        case TIMESTAMP: {
                            dataType = EDataType.TIMESTAMP;
                            break;
                        }
                    }
                }
            }
        }
        return new Pair((Object)dataType, (Object)hints);
    }

    private UberParser getParser() {
        if (null == this.mUberParser) {
            this.mUberParser = new UberParser();
            this.mUberParser.addParser((ITextParser)new BooleanParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new TimestampParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new TimeParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new DateParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new CurrencyParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new PercentParser(ULocale.US));
            this.mUberParser.addParser((ITextParser)new NumberParser(ULocale.US));
        }
        return this.mUberParser;
    }

    private boolean isNull(ICDFCell cell) {
        if (null == cell || cell.isNull()) {
            return true;
        }
        if (cell.getDataType() == EDataType.STRING) {
            return this.isNullPlaceHolder(cell.stringValue());
        }
        return false;
    }

    private boolean isNullPlaceHolder(String str) {
        if ((str = str.trim()).length() == 0) {
            return true;
        }
        if (this.mNullPlaceholders != null) {
            for (String s : this.mNullPlaceholders) {
                if (!s.equalsIgnoreCase(str)) continue;
                return true;
            }
        }
        return false;
    }
}

