/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.analyze;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.analyze.CellAnalyzer;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.EDataTypeGroup;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.util.FrequencyCounter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class HeaderRowAnalyzer {
    private final CellAnalyzer mCellAnalyzer;
    private long mBestRow;
    private long[] mCandidateIndexes;
    private List<Integer> mScores;

    public HeaderRowAnalyzer(CellAnalyzer cellAnalyzer) {
        this.mCellAnalyzer = cellAnalyzer;
        this.mScores = new ArrayList<Integer>();
        this.reset();
    }

    public void analyze(ICDFSheetReader reader, long startingIndex, int sampleSize) throws IOException, WAImportException {
        this.reset();
        long bestCandidateIndex = -1L;
        int bestCandidateScore = 0;
        ICDFRowCursor cursor = reader.cursor();
        if (!cursor.position(startingIndex)) {
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_ILLEGAL_ROW, new Object[]{startingIndex, reader.getSheet().getId()}).build();
        }
        long maxRow = Math.min(startingIndex + (long)sampleSize, reader.getSheet().getRowCount());
        FrequencyCounter<EDataTypeGroup>[] columnTypeFrequencies = this.countTypeFrequencies(cursor, maxRow);
        cursor = reader.cursor();
        cursor.position(startingIndex);
        int nonEmptyRowsSeen = 0;
        ArrayList<Long> candidates = new ArrayList<Long>();
        for (long rowIndex = startingIndex; rowIndex < maxRow; ++rowIndex) {
            ICDFRow row = cursor.getRow();
            int currentScore = this.countNonNullCells(row);
            if (currentScore > 0) {
                candidates.add(rowIndex);
                EDataType[] currentTypes = this.getCellTypes(row);
                currentScore += this.countTypeDifferences(currentTypes, columnTypeFrequencies);
                if ((currentScore -= ++nonEmptyRowsSeen) > bestCandidateScore) {
                    bestCandidateScore = currentScore;
                    bestCandidateIndex = row.getRowIndex();
                }
            }
            this.mScores.add(currentScore);
            cursor.next();
        }
        this.mBestRow = bestCandidateIndex;
        this.mCandidateIndexes = ArrayUtils.toPrimitive((Long[])candidates.toArray(new Long[0]));
    }

    public long getBestCandidateIndex() {
        return this.mBestRow;
    }

    public long[] getCandidateIndexes() {
        return this.mCandidateIndexes;
    }

    public List<Integer> getScores() {
        return this.mScores;
    }

    private void reset() {
        this.mBestRow = -1L;
        this.mCandidateIndexes = new long[0];
        this.mScores.clear();
    }

    private FrequencyCounter<EDataTypeGroup>[] countTypeFrequencies(ICDFRowCursor cursor, long maxRowIndex) throws IOException {
        int numRows = (int)(maxRowIndex - cursor.getRowIndex());
        ArrayList<FrequencyCounter> counters = new ArrayList<FrequencyCounter>();
        for (int i = 0; i < numRows; ++i) {
            ICDFRow row = cursor.getRow();
            EDataType[] types = this.getCellTypes(row);
            while (types.length > counters.size()) {
                counters.add(new FrequencyCounter());
            }
            for (int typeIndex = 0; typeIndex < types.length; ++typeIndex) {
                EDataType type = types[typeIndex];
                if (type == null) continue;
                ((FrequencyCounter)counters.get(typeIndex)).increment((Object)EDataTypeGroup.getGroup((EDataType)type));
            }
            cursor.next();
        }
        return counters.toArray(new FrequencyCounter[0]);
    }

    private EDataType[] getCellTypes(ICDFRow row) {
        EDataType[] types = new EDataType[row.getCellCount()];
        for (int i = 0; i < row.getCellCount(); ++i) {
            ICDFCell cell = row.getCell(i);
            types[i] = this.mCellAnalyzer.guessType(cell);
        }
        return types;
    }

    private int countNonNullCells(ICDFRow row) {
        int count = 0;
        for (int i = 0; i < row.getCellCount(); ++i) {
            ICDFCell cell = row.getCell(i);
            if (cell == null || cell.isNull()) continue;
            ++count;
        }
        return count;
    }

    private int countTypeDifferences(EDataType[] currentTypes, FrequencyCounter<EDataTypeGroup>[] columnTypeFrequencies) {
        int count = 0;
        for (int i = 0; i < currentTypes.length; ++i) {
            EDataType currentType = currentTypes[i];
            if (currentType == null) continue;
            EDataTypeGroup currentTypeGroup = EDataTypeGroup.getGroup((EDataType)currentType);
            if (columnTypeFrequencies[i].mostFrequentItems().contains(currentTypeGroup)) continue;
            ++count;
        }
        return count;
    }
}

