/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.artifacts;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.nodel.artifacts.ImportArtifact;
import com.ibm.neo.dataimport.nodel.artifacts.ImportArtifactPersistence;
import com.ibm.neo.dataimport.util.BlobStoreHelper;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.util.ThreadFactories;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportArtifactManager {
    public static final String QUERY_PARAM_ACCESS_KEY = "accessKey";
    private static final String sContainerName = "import-artifacts";
    private static final Logger LOG = LoggerFactory.getLogger(ImportArtifactManager.class);
    private PersistenceService ps;
    private AccessControlService acs;
    private ImportService is;
    private ScheduledExecutorService scheduledExecutor;
    private final long expirationDelayInMillis;
    private final ConcurrentLinkedQueue<ArtifactKeepAliveTask> activeTasks;
    private final String baseArtifactsUri;

    protected ImportArtifactManager() {
        this.expirationDelayInMillis = 0L;
        this.activeTasks = null;
        this.baseArtifactsUri = "artifacts";
    }

    public ImportArtifactManager(PersistenceService ps, AccessControlService acs, ImportService is, long asyncArtifactExpirationDelay, String baseArtifactsUri) {
        this.ps = ps;
        this.acs = acs;
        this.is = is;
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.create((String)"ImportArtifact-Scheduled", (boolean)true));
        this.expirationDelayInMillis = asyncArtifactExpirationDelay;
        this.activeTasks = new ConcurrentLinkedQueue();
        this.baseArtifactsUri = baseArtifactsUri;
    }

    public void init() {
        long period = Math.max(this.expirationDelayInMillis / 2L, 1L);
        this.scheduledExecutor.scheduleAtFixedRate(new UpdateArtifactExpirationRunnable(), 0L, period, TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        this.activeTasks.clear();
        this.scheduledExecutor.shutdown();
    }

    public ImportArtifact createArtifact(IBlob blob, String type, boolean generateAccessKey) throws WAImportException {
        ImportArtifact artifact;
        try {
            IBlob artifactBlob = this.createArtifactBlob(blob);
            artifact = this.createArtifactRecord(type, ImportArtifact.State.done, generateAccessKey);
            artifact.setBlobId(artifactBlob.getKey());
            ImportArtifactPersistence.getArtifactsCollection((PersistenceService)this.ps).save((Nobject)artifact);
        }
        catch (Exception e) {
            throw WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
        }
        return artifact;
    }

    public ImportArtifact createArtifactAsync(IBlob blob, boolean generateAccessKey, ExecutorService executor) throws WAImportException {
        return this.createArtifactAsync(blob, null, generateAccessKey, executor);
    }

    public ImportArtifact createArtifactAsync(IBlob blob, String type, boolean generateAccessKey, ExecutorService executor) throws WAImportException {
        ImportArtifact artifact;
        try {
            artifact = this.createArtifactRecord(type, ImportArtifact.State.creating, generateAccessKey);
            CreateArtifactRunnable createArtifactRunnable = new CreateArtifactRunnable(artifact, blob);
            ArtifactKeepAliveTask task = new ArtifactKeepAliveTask((Runnable)createArtifactRunnable, artifact.getArtifactId());
            executor.execute(task);
            this.activeTasks.add(task);
        }
        catch (Exception e) {
            throw WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
        }
        return artifact;
    }

    private static Date generateExpirationTime(long expirationDelay) {
        return new Date(System.currentTimeMillis() + expirationDelay);
    }

    private IONObject makeSignalIONForArtifact(ImportArtifact artifact) {
        return new IONObjectBuilder().put("artifact-id", (Object)artifact.getArtifactId()).toDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBlob createArtifactBlob(IBlob sourceBlob) throws BlobStoreException, IOException {
        IBlobStore blobStore = this.is.getBlobStore();
        InputStream blobContents = sourceBlob.open();
        try {
            IBlobContainer container = blobStore.getContainer(sContainerName, true);
            IBlob artifactBlob = null;
            int retryCount = 0;
            while (true) {
                try {
                    artifactBlob = container.create(sourceBlob.getFilename(), sourceBlob.getContentType(), blobContents, sourceBlob.isCompressed());
                }
                catch (BlobStoreException.ContainerNotFound e) {
                    if (++retryCount < 5) {
                        LOG.warn("Container {} was recently created but can no longer be found. Retry attempt #{}.", (Object)container.getName(), (Object)retryCount);
                        continue;
                    }
                    LOG.error("Container {} count not be found after {} retries. Aborting.", new Object[]{container.getName(), retryCount, e});
                    throw e;
                }
                break;
            }
            for (String key : sourceBlob.getMetadataKeys()) {
                artifactBlob.setMetadataValue(key, sourceBlob.getMetadataValue(key));
            }
            if (!artifactBlob.getMetadataKeys().isEmpty()) {
                artifactBlob.saveMetadata();
            }
            IBlob iBlob = artifactBlob;
            return iBlob;
        }
        finally {
            IOUtils.closeQuietly((InputStream)blobContents);
        }
    }

    private ImportArtifact createArtifactRecord(String type, ImportArtifact.State state, boolean generateAccessKey) throws PersistenceException {
        ImportArtifact artifact = new ImportArtifact();
        artifact.setArtifactId(UUID.randomUUID().toString());
        artifact.setType(type);
        artifact.setState(state);
        artifact.setTenantId(ACSHelper.getCurrentTenantId());
        URI link = UriBuilder.fromPath((String)this.baseArtifactsUri).segment(new String[]{"{artifactId}"}).build(new Object[]{artifact.getArtifactId()});
        String linkStr = link.toString();
        if (generateAccessKey) {
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            artifact.setAccessKey(Hex.encodeHexString((byte[])bytes));
            linkStr = String.format("%s?%s=%s", linkStr, QUERY_PARAM_ACCESS_KEY, artifact.getAccessKey());
        }
        artifact.setLink(linkStr);
        return artifact;
    }

    public ImportArtifact findArtifact(String artifactId, String accessKey) throws WAImportException {
        try {
            IONObject query = new QueryBuilder().equalTo("artifact-id", (Object)artifactId).equalTo("access-key", (Object)accessKey).toDocument();
            return (ImportArtifact)ImportArtifactPersistence.getArtifactsCollection((PersistenceService)this.ps).findOne(query);
        }
        catch (PersistenceException e) {
            throw WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
        }
    }

    public BlobStoreHelper.ProxyBlob readArtifact(ImportArtifact artifact) throws PersistenceException, BlobStoreException {
        if (!ImportArtifact.State.done.equals((Object)artifact.getState())) {
            LOG.error("Import artifact {} is currently in the {} state, and cannot be read.", (Object)artifact.getArtifactId(), (Object)artifact.getState().toString());
            return null;
        }
        if (artifact.getBlobId() == null) {
            LOG.error("Import artifact {} has no blob id.", (Object)artifact.getArtifactId());
            return null;
        }
        Tenant tenant = null;
        Account account = null;
        if (artifact.getTenantId() != null) {
            tenant = this.acs.getTenant(artifact.getTenantId());
            account = this.acs.getAccount(tenant.getAccountId());
        } else {
            tenant = this.acs.getCurrentTenant();
            account = this.acs.getCurrentAccount();
        }
        return BlobStoreHelper.getProxyBlobAsTenant(this.is.getBlobStore(), this.acs, account, tenant, sContainerName, artifact.getBlobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArtifact(ImportArtifact artifact) throws WAImportException {
        if (artifact.getState().equals((Object)ImportArtifact.State.creating)) {
            WAImportException.newBuilder().withConditionCode(EImportMessageCode.UNUSABLE_IMPORT_ARTIFACT).withMessage((IMessageKey)NeoImportError.CANNOT_DELETE_AN_ARTIFACT).build();
        }
        try {
            BlobStoreHelper.ProxyBlob blob = this.readArtifact(artifact);
            try {
                if (blob != null) {
                    try {
                        blob.remove();
                    }
                    catch (Exception e) {
                        LOG.warn("Exception deleting artifact {}'s source blob {}. Ignoring.", new Object[]{artifact.getArtifactId(), artifact.getBlobId(), e});
                    }
                }
            }
            finally {
                IONObject query = new QueryBuilder().equalTo("artifact-id", (Object)artifact.getArtifactId()).toDocument();
                ImportArtifactPersistence.getArtifactsCollection((PersistenceService)this.ps).remove(query);
            }
        }
        catch (Exception e) {
            WAImportException.newBuilder().withCause((Throwable)e).withConditionCode(EImportMessageCode.UNUSABLE_IMPORT_ARTIFACT).withMessage((IMessageKey)NeoImportError.FAILED_TO_DELETE_IMPORT_ARTIFACT).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportArtifact waitForArtifact(ImportArtifact artifact, long timeout) throws PersistenceException {
        if (!ImportArtifact.State.creating.equals((Object)artifact.getState())) {
            return artifact;
        }
        final Thread threadToInterrupt = Thread.currentThread();
        Runnable interruptRunnable = new Runnable(){

            @Override
            public void run() {
                threadToInterrupt.interrupt();
            }
        };
        long startTime = System.currentTimeMillis();
        String artifactId = artifact.getArtifactId();
        IONObject query = new QueryBuilder().equalTo("artifact-id", (Object)artifactId).toDocument();
        ScheduledFuture<?> future = null;
        do {
            try {
                future = this.scheduledExecutor.schedule(interruptRunnable, timeout, TimeUnit.MILLISECONDS);
                try (ICursor tailableCursor = ImportArtifactPersistence.getArtifactSignalsCappedCollection((PersistenceService)this.ps).find(query).setOptions(EnumSet.of(ECursorOption.TAILABLE, ECursorOption.AWAIT_DATA));){
                    if (tailableCursor.supportsMaxTime()) {
                        tailableCursor = tailableCursor.maxTime(timeout, TimeUnit.MILLISECONDS);
                    }
                    if (!tailableCursor.hasNext()) continue;
                    LOG.info("Received signal that the processing of artifact {} has finished.", (Object)artifactId);
                    break;
                }
            }
            catch (PersistenceException.Interrupted tailableCursor) {
            }
            catch (Exception e) {
                LOG.error("Unexpected error while tailing the import-artifact-signals collection, waiting for artifact {} to finish.", (Object)artifactId, (Object)e);
                break;
            }
            finally {
                if (future != null) {
                    future.cancel(false);
                }
            }
        } while (System.currentTimeMillis() - startTime < timeout);
        return (ImportArtifact)ImportArtifactPersistence.getArtifactsCollection((PersistenceService)this.ps).findOne(query);
    }

    public void deleteTenantArtifacts(Tenant tenant) throws PersistenceException {
        IONObject query = new QueryBuilder().equalTo("tenant-id", (Object)tenant.getId()).toDocument();
        NobjectCollection artifactsCol = ImportArtifactPersistence.getArtifactsCollection((PersistenceService)this.ps);
        List tenantArtifacts = artifactsCol.find(query).toListAndClose();
        for (ImportArtifact artifact : tenantArtifacts) {
            try {
                this.deleteArtifact(artifact);
            }
            catch (WAImportException e) {
                LOG.warn("Exception while deleting import artifact {}. Marking as orphaned.", (Object)artifact.getArtifactId(), (Object)e);
                try {
                    artifactsCol.getDocumentCollection().update(artifact.getId(), new UpdateBuilder().set("orphaned", (Object)true).toDocument());
                }
                catch (PersistenceException f) {
                    LOG.warn("Error marking import artifact {} as orphaned.", (Object)artifact.getArtifactId(), (Object)f);
                }
            }
        }
    }

    private class CreateArtifactRunnable
    implements Runnable {
        private final ImportArtifact artifact;
        private final IBlob blob;

        private CreateArtifactRunnable(ImportArtifact artifact, IBlob sourceBlob) {
            this.artifact = artifact;
            this.blob = sourceBlob;
        }

        @Override
        public void run() {
            this.artifact.setExpires(ImportArtifactManager.generateExpirationTime(ImportArtifactManager.this.expirationDelayInMillis));
            try {
                ImportArtifactPersistence.getArtifactsCollection((PersistenceService)ImportArtifactManager.this.ps).save((Nobject)this.artifact);
                IBlob artifactBlob = ImportArtifactManager.this.createArtifactBlob(this.blob);
                this.artifact.setBlobId(artifactBlob.getKey());
                this.artifact.setState(ImportArtifact.State.done);
            }
            catch (Exception e) {
                LOG.error("Could not create import artifact {}. Aborting async artifact creation.", (Object)this.artifact.getArtifactId(), (Object)e);
                this.artifact.setState(ImportArtifact.State.failed);
            }
            finally {
                try {
                    this.artifact.setExpires(null);
                    try {
                        ImportArtifactPersistence.getArtifactsCollection((PersistenceService)ImportArtifactManager.this.ps).save((Nobject)this.artifact);
                    }
                    catch (PersistenceException e) {
                        LOG.error("Could not save import artifact {}. Aborting async artifact creation.", (Object)this.artifact.getArtifactId(), (Object)e);
                    }
                    try {
                        ImportArtifactPersistence.getArtifactSignalsCappedCollection((PersistenceService)ImportArtifactManager.this.ps).insert(ImportArtifactManager.this.makeSignalIONForArtifact(this.artifact));
                    }
                    catch (PersistenceException e) {
                        LOG.error("Error inserting import artifact signal.", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unexpected error while updating the artifact {}. Aborting async artifact creation.", (Object)this.artifact.getArtifactId(), (Object)e);
                }
            }
        }
    }

    private class UpdateArtifactExpirationRunnable
    implements Runnable {
        private UpdateArtifactExpirationRunnable() {
        }

        @Override
        public void run() {
            block3: {
                ArtifactKeepAliveTask activeTask = null;
                try {
                    NobjectCollection col = ImportArtifactPersistence.getArtifactsCollection((PersistenceService)ImportArtifactManager.this.ps);
                    Iterator iterator = ImportArtifactManager.this.activeTasks.iterator();
                    while (iterator.hasNext()) {
                        ArtifactKeepAliveTask task;
                        activeTask = task = (ArtifactKeepAliveTask)iterator.next();
                        ImportArtifact artifact = (ImportArtifact)col.findOne(new QueryBuilder().equalTo("artifact-id", (Object)task.artifactId).toDocument());
                        if (artifact == null) continue;
                        Date newExpiration = task.isDone() ? null : ImportArtifactManager.generateExpirationTime(ImportArtifactManager.this.expirationDelayInMillis);
                        artifact.setExpires(newExpiration);
                        ImportArtifactPersistence.getArtifactsCollection((PersistenceService)ImportArtifactManager.this.ps).save((Nobject)artifact);
                    }
                }
                catch (PersistenceException e) {
                    LOG.error("Unexpected exception while keeping an import artifact task {} alive. Abandoning task.", activeTask, (Object)e);
                    if (activeTask == null) break block3;
                    ImportArtifactManager.this.activeTasks.remove(activeTask);
                }
            }
        }
    }

    private static class ArtifactKeepAliveTask
    extends FutureTask<String> {
        private String artifactId;

        public ArtifactKeepAliveTask(Runnable runnable, String artifactId) {
            super(runnable, artifactId);
            this.artifactId = artifactId;
        }

        @Override
        public String toString() {
            return this.artifactId;
        }
    }
}

