/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.IDatabaseSelectionStrategy;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.nodel.Tenant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDbSelectionStrategy
implements IDatabaseSelectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDbSelectionStrategy.class);
    protected final StorageService storageService;
    protected final Random random;

    protected AbstractDbSelectionStrategy(StorageService storageService) {
        this.storageService = storageService;
        this.random = new Random();
    }

    protected AbstractDbSelectionStrategy(StorageService storageService, Random random) {
        this.storageService = storageService;
        this.random = random;
    }

    @Override
    public Database select(Tenant tenant, List<Dataset> datasets) {
        List<Database> candidates = this.getDeployableDatabases(this.getDatabasesForTenant(tenant));
        return this.selectFromList(tenant, datasets, candidates.toArray(new Database[0]));
    }

    @Override
    public Database select(Tenant tenant, List<Dataset> datasets, List<IONObjectId> auxiliaryDatabaseIds) {
        if (auxiliaryDatabaseIds == null || auxiliaryDatabaseIds.isEmpty()) {
            return this.select(tenant, datasets);
        }
        List<Database> firstPassCandidates = this.getDeployableDatabases(this.getDatabasesForTenant(tenant));
        ArrayList<Database> secondPassCandidates = new ArrayList<Database>();
        Iterator<Database> dbItr = firstPassCandidates.iterator();
        while (dbItr.hasNext()) {
            Database db = dbItr.next();
            if (!auxiliaryDatabaseIds.contains(db.getId())) continue;
            secondPassCandidates.add(db);
            dbItr.remove();
        }
        Database candidate = this.selectFromList(tenant, datasets, firstPassCandidates.toArray(new Database[0]));
        if (candidate == null && (candidate = this.selectFromList(tenant, datasets, secondPassCandidates.toArray(new Database[0]))) != null) {
            LOGGER.info("Selected a database from the auxiliary list: {}", (Object)candidate);
        }
        return candidate;
    }

    private List<Database> getDatabasesForTenant(Tenant tenant) {
        String dbPool = null != tenant.getDatabasePool() ? tenant.getDatabasePool() : "default";
        try {
            return this.storageService.listDatabases(null, dbPool, false);
        }
        catch (Exception e) {
            LOGGER.warn("Could not retrieve a list of databases in pool '{}' for tenant {}.", new Object[]{dbPool, tenant.getId().getIdentifier(), e});
            return new ArrayList<Database>();
        }
    }

    protected abstract Database selectFromList(Tenant var1, List<Dataset> var2, Database[] var3);

    private List<Database> getDeployableDatabases(List<Database> databases) {
        ArrayList<Database> copiedList = new ArrayList<Database>(databases);
        try {
            Iterator iter = copiedList.iterator();
            while (iter.hasNext()) {
                Database db = (Database)iter.next();
                try {
                    if (!db.isDisabled() && this.storageService.checkDatabase(db)) continue;
                    iter.remove();
                }
                catch (WAStorageException ex) {
                    LOGGER.warn("Failed to determine if database ({}) is reachable", (Object)db.getName());
                    iter.remove();
                }
            }
            return copiedList;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

