/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.AbstractDbSelectionStrategy;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.storage.util.DeployJobTracker;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.util.WeightedRandomSelector;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostBiasedDbSelectionStrategy
extends AbstractDbSelectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CostBiasedDbSelectionStrategy.class);

    public CostBiasedDbSelectionStrategy(StorageService storageService) {
        super(storageService);
    }

    public CostBiasedDbSelectionStrategy(StorageService storageService, Random random) {
        super(storageService, random);
    }

    @Override
    public Database selectFromList(Tenant tenant, List<Dataset> datasets, Database[] databases) {
        DeployJobTracker deployTracker = this.storageService.getDeployJobTracker();
        try {
            if (databases.length == 0) {
                return null;
            }
            if (databases.length == 1) {
                return databases[0];
            }
            double[] costs = new double[databases.length];
            double costSum = 0.0;
            for (int i = 0; i < databases.length; ++i) {
                costs[i] = this.computeDeploymentCost(tenant, datasets, databases[i]);
                costSum += costs[i];
            }
            double[] jobCounts = new double[databases.length];
            for (int i = 0; i < databases.length; ++i) {
                jobCounts[i] = deployTracker.getJobCount(databases[i].getId());
            }
            DescriptiveStatistics jobCountStats = new DescriptiveStatistics(jobCounts);
            double max = jobCountStats.getMax();
            double p50 = jobCountStats.getPercentile(50.0);
            double[] weights = new double[databases.length];
            for (int i = 0; i < databases.length; ++i) {
                double normalizedCost = costs[i] / costSum;
                weights[i] = 1.0 / normalizedCost;
                if (databases.length <= 1 || !(jobCounts[i] > 1.0) || !(jobCounts[i] > p50)) continue;
                double scale = p50 / jobCounts[i];
                LOGGER.warn("Scaling database weight due to high job count (db={}, jobCount={}, allJobCounts={}, median={}, scale={})", new Object[]{databases[i].getName(), jobCounts[i], Arrays.toString(jobCounts), p50, scale});
                weights[i] = weights[i] * scale;
            }
            int choice = new WeightedRandomSelector(weights).select(this.random);
            return databases[choice];
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected exception", (Throwable)ex);
            return null;
        }
    }

    private double computeDeploymentCost(Tenant tenant, List<Dataset> datasets, Database db) {
        double databaseCost = 1.0;
        for (Dataset ds : datasets) {
            try {
                List tables = this.storageService.listTables(tenant.getId(), db.getId(), ds.getId(), null, null, false, false);
                if (tables.isEmpty()) {
                    databaseCost += ds.getStorageCost();
                    continue;
                }
                Table tbl = (Table)tables.get(0);
                if (tbl.getVersion() == ds.getVersion() && this.storageService.checkTable(db, tbl.getSchemaName(), tbl.getTableName())) continue;
                databaseCost += ds.getStorageCost();
            }
            catch (WAStorageException ex) {
                LOGGER.error("Unexpected error", (Throwable)ex);
            }
        }
        return databaseCost;
    }
}

