/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.NoSuchSheetException;
import com.ibm.neo.dataimport.deploy.TupleGenerator;
import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.DocumentMetadata;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.ds.DocumentDataSource;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.dataimport.nodel.storage.Column;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.dataimport.nodel.storage.SQLDataType;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.DatabaseLimits;
import com.ibm.neo.dataimport.storage.IBulkLoader;
import com.ibm.neo.dataimport.storage.IDatabaseAccessor;
import com.ibm.neo.dataimport.storage.IRowWriter;
import com.ibm.neo.dataimport.storage.IStreamingRowWriter;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.dataimport.storage.util.IdentifierUtil;
import com.ibm.neo.dataimport.util.DatasetStatsCollector;
import com.ibm.neo.dataimport.xtab.XSheet;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.util.Assertions;
import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.IProgress;
import com.ibm.neo.util.ops.ProgressHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetDeployer {
    private static final String ROW_ID = "__row_id__";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDeployer.class);
    private final ImportService mImportService;
    private final StorageService mStorageService;
    private UserDataSource mDataSource;
    private Dataset mDataset;
    private Database mDatabase;
    private EOrganizedBy mTableOrganization;
    private IONObjectId mTenantId;
    private Properties mTransactionIds;
    private long mFirstRowId = 1L;
    private volatile IBulkLoader mBulkLoader = null;
    private volatile boolean mCancelled = false;

    public DatasetDeployer(ImportService importService, StorageService storageService) {
        if (null == importService) {
            throw new NullArgumentException("importService");
        }
        if (null == storageService) {
            throw new NullArgumentException("storageService");
        }
        this.mImportService = importService;
        this.mStorageService = storageService;
        this.mTableOrganization = this.mImportService.getDefaultTableOrganization();
    }

    public UserDataSource getDataSource() {
        return this.mDataSource;
    }

    public void setDataSource(UserDataSource dataSource) {
        this.mDataSource = dataSource;
    }

    public Dataset getDataset() {
        return this.mDataset;
    }

    public void setDataset(Dataset dataset) {
        this.mDataset = dataset;
    }

    public Database getDatabase() {
        return this.mDatabase;
    }

    public void setDatabase(Database database) {
        this.mDatabase = database;
    }

    public void setTenantId(IONObjectId tenantId) {
        this.mTenantId = tenantId;
    }

    public void setTransactionIds(Properties transactionIds) {
        this.mTransactionIds = transactionIds;
    }

    public void setTableOrganization(EOrganizedBy tableOrganization) {
        this.mTableOrganization = tableOrganization;
    }

    public long getFirstRowId() {
        return this.mFirstRowId;
    }

    public void setFirstRowId(long firstRowId) {
        this.mFirstRowId = firstRowId;
    }

    public void cancel() {
        if (this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        IBulkLoader bulkLoader = this.mBulkLoader;
        if (null != bulkLoader) {
            bulkLoader.cancel();
        }
    }

    private void checkState() {
        Assertions.assertNotNull((Object)this.mDataset, (String)"Dataset was not specified");
        Assertions.assertNotNull((Object)this.mDatabase, (String)"Database was not specified");
        Assertions.assertNotNull((Object)this.mTenantId, (String)"Tenant Id was not specified");
    }

    public Table createTable(String schemaName, String tableName, boolean dropIfExists) throws PersistenceException, WAStorageException {
        this.checkState();
        IDatabaseAccessor accessor = this.mStorageService.getOrCreateAccessor(this.mDatabase.getDbType());
        DatabaseLimits dbLimits = accessor.getDatabaseLimits(this.mDatabase);
        boolean charsHaveByteLengthSemantics = accessor.charsHaveByteLengthSemantics(this.mDatabase);
        int maxBytesPerChar = accessor.maxBytesPerChar(this.mDatabase);
        this.mStorageService.ensureSchemaExists(this.mDatabase, schemaName);
        if (dropIfExists) {
            LOGGER.info("Dropping existing table '{}'.'{}'", (Object)schemaName, (Object)tableName);
            this.mStorageService.dropTable(this.mDatabase, schemaName, tableName, 15);
        }
        Table table = new Table();
        table.setDatabaseId(this.mDatabase.getId());
        table.setDatasetId(this.mDataset.getId());
        table.setTenantId(this.mTenantId);
        table.setSchemaName(schemaName);
        table.setTableName(tableName);
        table.setVersion(this.mDataset.getVersion());
        Date now = new Date();
        table.setCreatedTime(now);
        table.setLastAccessTime(now);
        table.setLastValidatedTime(now);
        if (null != this.mTableOrganization) {
            table.setOrganizedBy(this.mTableOrganization);
        } else {
            table.setOrganizedBy(EOrganizedBy.DEFAULT);
        }
        List dataItems = this.mDataset.getDataItems();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int dataItemIdx = 0; dataItemIdx < dataItems.size(); ++dataItemIdx) {
            DataItem di = (DataItem)dataItems.get(dataItemIdx);
            Column col = new Column();
            col.setDataItemName(di.getName());
            col.setDataType(DatasetDeployer.getSQLDataType(di.getDataType(), di.getMaxStringLength(), charsHaveByteLengthSemantics, maxBytesPerChar));
            if (ROW_ID.equals(di.getName())) {
                col.setPrimaryKey(true);
                columnNames.add(ROW_ID);
            } else {
                columnNames.add(this.mImportService.getNamingStrategy().makeColumnName(di, col.getDataType(), dataItemIdx));
            }
            table.getColumns().add(col);
        }
        int numColumns = table.getColumns().size();
        IdentifierUtil.uniquizeIdentifiers(columnNames, (int)dbLimits.getMaxColumnNameLength());
        for (int i = 0; i < numColumns; ++i) {
            ((Column)table.getColumns().get(i)).setColumnName((String)columnNames.get(i));
        }
        LOGGER.debug("Creating new table: {}", (Object)table.toString());
        try {
            this.mStorageService.createTable(this.mDatabase, table);
        }
        catch (WAStorageException.TableRowLengthExceeded ex) {
            if (table.getOrganizedBy() != EOrganizedBy.ROW) {
                LOGGER.error("Cannot create table as column-organized (too wide); falling back to row-organized");
                table.setOrganizedBy(EOrganizedBy.ROW);
                this.mStorageService.createTable(this.mDatabase, table);
            }
            LOGGER.error("Failed to create table - it is too wide", (Throwable)ex);
            throw ex;
        }
        return table;
    }

    public void loadTableData(Table table, ProgressHelper progress) throws Exception {
        this.loadTableData(table, this.mDataset.getPlans(), false, progress);
    }

    public void loadTableData(Table table, List<DeploymentPlan> plans, boolean appendHint, final ProgressHelper progress) throws Exception {
        this.checkState();
        HashMap<String, String> auditTags = new HashMap<String, String>();
        auditTags.put("datasetId", this.mDataset.getId().getIdentifier());
        auditTags.put("dataSourceId", this.mDataSource.getId().getIdentifier());
        auditTags.put("dataSourceName", this.mDataSource.getName());
        if (null != this.mTenantId) {
            auditTags.put("tenantId", this.mTenantId.getIdentifier());
        }
        if (null != this.mTransactionIds) {
            for (String string : this.mTransactionIds.keySet()) {
                auditTags.put(string, this.mTransactionIds.getProperty(string));
            }
        }
        long rowExtent = 0L;
        for (DeploymentPlan plan : plans) {
            rowExtent += plan.getSheetInfo().getRowExtent() - (long)plan.getFirstDataRow();
        }
        long startNanos = System.nanoTime();
        LOGGER.info("Bulk loading table '{}'.'{}'", (Object)table.getSchemaName(), (Object)table.getTableName());
        long expectedRowCount = Math.max(1L, rowExtent);
        this.mBulkLoader = this.mStorageService.createBulkLoader(this.mDatabase, table, expectedRowCount);
        this.mBulkLoader.setAuditTags(auditTags);
        this.mBulkLoader.setRowCount(expectedRowCount);
        this.mBulkLoader.setAppendHint(appendHint);
        if (null != progress) {
            progress.setTotalWork(100L);
            this.mBulkLoader.addProgressObserver((IObserver)new IObserver<IProgress>(){

                public void updated(IProgress subject) {
                    progress.setCompletedWork((long)((int)Math.round(subject.getPercentCompleted())));
                }
            });
        }
        this.mBulkLoader.start(this.getStreamingRowWriter(this.mDataset.getDataItems(), plans));
        if (null != progress) {
            progress.setCompletedWork(progress.getTotalWork());
        }
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos);
        LOGGER.info("Bulk load finished in {} seconds", (Object)elapsedSeconds);
    }

    public void collectTableStats(Table table) throws WAStorageException {
        DatasetStatsCollector collector = new DatasetStatsCollector(this.mStorageService, this.mDataset, this.mDatabase, table);
        long startNanos = System.nanoTime();
        LOGGER.info("Collecting stats for table '{}'.'{}'", (Object)table.getSchemaName(), (Object)table.getTableName());
        collector.collect();
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos);
        LOGGER.info("Stats collected in {} seconds", (Object)elapsedSeconds);
    }

    public IStreamingRowWriter getStreamingRowWriter() throws Exception {
        return this.getStreamingRowWriter(this.mDataset.getDataItems(), this.mDataset.getPlans());
    }

    private IStreamingRowWriter getStreamingRowWriter(List<DataItem> dataItems, final List<DeploymentPlan> plans) throws Exception {
        final IDataType[] dataTypes = new IDataType[dataItems.size()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = DatasetDeployer.getIDataType(dataItems.get(i));
        }
        return new IStreamingRowWriter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(IRowWriter writer) throws WAStorageException {
                long nextRowId = DatasetDeployer.this.mFirstRowId;
                LOGGER.info("Streaming rows for {} deployment plans", (Object)plans.size());
                try {
                    int planNum = 1;
                    for (DeploymentPlan plan : plans) {
                        LOGGER.info("Starting to stream rows for plan {}, starting at row id {}", (Object)planNum, (Object)nextRowId);
                        XSheet sheet = new XSheet(DatasetDeployer.this.mImportService.getCDFService().getSheetLibrary().load(plan.getSheetInfo().getSheetId()), plan.getCrossTabInfo());
                        ICDFSheetReader sheetReader = sheet.openReader();
                        try {
                            nextRowId += DatasetDeployer.this.generateTuples(writer, sheetReader, plan, dataTypes, nextRowId);
                        }
                        finally {
                            sheetReader.close();
                            LOGGER.info("Finished to stream rows for plan {}", (Object)planNum);
                            ++planNum;
                        }
                    }
                }
                catch (NoSuchSheetException ex) {
                    throw new WAStorageException((Throwable)ex);
                }
                catch (IOException ex) {
                    throw new WAStorageException((Throwable)ex);
                }
            }
        };
    }

    private long generateTuples(IRowWriter rowWriter, ICDFSheetReader sheetReader, DeploymentPlan plan, IDataType[] dataTypes, long nextRowId) throws WAStorageException {
        long rowCount = 0L;
        try {
            ICDFRowCursor cursor = sheetReader.cursor();
            int firstDataRow = plan.getFirstDataRow();
            cursor.position((long)(firstDataRow - 1));
            TupleGenerator generator = new TupleGenerator(plan, dataTypes, this.getNullPlaceholders(), nextRowId, cursor);
            IValue[] tupleValues = generator.nextTuple();
            while (tupleValues != null) {
                this.checkCancelled();
                rowWriter.write(tupleValues);
                tupleValues = generator.nextTuple();
                ++rowCount;
            }
            LOGGER.info("Generated {} rows", (Object)rowCount);
            return rowCount;
        }
        catch (IOException ex) {
            throw new WAStorageException("IO error: " + ex.toString(), (Throwable)ex);
        }
    }

    private List<String> getNullPlaceholders() {
        String[] nullTokens;
        DocumentMetadata meta;
        if (this.mDataSource instanceof DocumentDataSource && null != (meta = ((DocumentDataSource)this.mDataSource).getMetadata()) && null != (nullTokens = meta.getNullTokens())) {
            return Arrays.asList(nullTokens);
        }
        return this.mImportService.getNullPlaceholders();
    }

    private void checkCancelled() {
        if (this.mCancelled) {
            throw new CancellationException();
        }
    }

    private static SQLDataType getSQLDataType(EDataType dataType, int maxStringLength, boolean charsHaveByteLengthSemantics, int maxBytesPerChar) {
        switch (dataType) {
            case BOOLEAN: {
                return SQLDataType.getBoolean();
            }
            case CHAR: {
                if (charsHaveByteLengthSemantics) {
                    return SQLDataType.getChar((int)maxBytesPerChar);
                }
                return SQLDataType.getChar((int)1);
            }
            case DATE: {
                return SQLDataType.getDate();
            }
            case TIME: {
                return SQLDataType.getTime();
            }
            case TIMESTAMP: {
                return SQLDataType.getTimestamp();
            }
            case STRING: {
                if (charsHaveByteLengthSemantics) {
                    return SQLDataType.getVarChar((int)(maxBytesPerChar * maxStringLength));
                }
                return SQLDataType.getVarChar((int)maxStringLength);
            }
            case DECIMAL64: 
            case FLOAT64: {
                return SQLDataType.getDouble();
            }
            case FLOAT32: {
                return SQLDataType.getReal();
            }
            case INT8: {
                return SQLDataType.getTinyInt();
            }
            case INT16: {
                return SQLDataType.getSmallInt();
            }
            case INT32: {
                return SQLDataType.getInt();
            }
            case INT64: {
                return SQLDataType.getBigInt();
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    private static IDataType getIDataType(DataItem di) {
        switch (di.getDataType()) {
            case BOOLEAN: {
                return DataTypes.getBooleanType();
            }
            case CHAR: {
                return DataTypes.getStringType((int)1);
            }
            case STRING: {
                return DataTypes.getStringType((int)di.getMaxStringLength());
            }
            case DATE: {
                return DataTypes.getDateType();
            }
            case TIME: {
                return DataTypes.getTimeType();
            }
            case TIMESTAMP: {
                return DataTypes.getTimestampType();
            }
            case DECIMAL64: 
            case FLOAT64: {
                return DataTypes.getDoubleType();
            }
            case FLOAT32: {
                return DataTypes.getFloatType();
            }
            case INT8: 
            case INT16: 
            case INT32: {
                return DataTypes.getIntegerType();
            }
            case INT64: {
                return DataTypes.getLongType();
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + di.getDataType());
    }
}

