/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.dataimport.ImportService;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.api.WAStorageException;
import com.ibm.neo.dataimport.deploy.IDatabaseSelectionStrategy;
import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ImportPersistence;
import com.ibm.neo.dataimport.nodel.ops.DeployResult;
import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.StoragePersistence;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.dataimport.storage.StorageService;
import com.ibm.neo.messages.exceptions.NeoImportError;
import com.ibm.neo.metrics.CounterMetric;
import com.ibm.neo.metrics.TimerMetric;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.wrangler.api.WranglerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentResolver {
    private static final CounterMetric METRIC_RESOLVE_HITS = new CounterMetric("import.deployment.resolve_hits");
    private static final CounterMetric METRIC_RESOLVE_MISSES = new CounterMetric("import.deployment.resolve_misses");
    private static final CounterMetric METRIC_RESOLVE_TIME_OUTS = new CounterMetric("import.deployment.resolve_time_outs");
    private static final CounterMetric METRIC_RESOLVE_FAILURES = new CounterMetric("import.deployment.resolve_failures");
    private static final TimerMetric METRIC_RESOLVE_TIME = new TimerMetric("import.deployment.resolve_time");
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentResolver.class);
    private final PersistenceService ps;
    private final WranglerService wrangler;
    private final AccessControlService acs;
    private final StorageService storageService;
    private final ImportService importService;
    private final IDatabaseSelectionStrategy dbSelectionStrategy;
    private final int repairDelaySeconds;
    private final Random random;

    public DeploymentResolver(PersistenceService ps, WranglerService wrangler, AccessControlService acs, StorageService storageService, ImportService importService, IDatabaseSelectionStrategy dbSelectionStrategy, int repairDelaySeconds) {
        this.ps = ps;
        this.wrangler = wrangler;
        this.acs = acs;
        this.storageService = storageService;
        this.importService = importService;
        this.dbSelectionStrategy = dbSelectionStrategy;
        this.repairDelaySeconds = repairDelaySeconds;
        this.random = new Random();
    }

    public DeployResult ensureDeployed(Dataset dataset, long timeoutSeconds) throws WAImportException {
        return this.ensureDeployed(dataset, null, timeoutSeconds);
    }

    public List<DeployResult> ensureDeployed(List<Dataset> datasets, boolean collocated, long timeoutSeconds) throws WAImportException {
        if (datasets.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Ensuring datasets {} are deployed (collocated={}, timeoutSeconds={})", new Object[]{DeploymentResolver.datasetsToString(datasets), collocated, timeoutSeconds});
        }
        Tenant tenant = this.getCurrentTenant();
        if (collocated && datasets.size() > 1) {
            Database db = this.findCommonDatabase(tenant, datasets);
            if (null == db) {
                db = this.dbSelectionStrategy.select(tenant, datasets);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Selected database (name={}, _id={}) to deploy datasets {}", new Object[]{db.getName(), db.getId().getIdentifier(), DeploymentResolver.datasetsToString(datasets)});
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Found a common database (name={}, _id={}) for datasets {}", new Object[]{db.getName(), db.getId().getIdentifier(), DeploymentResolver.datasetsToString(datasets)});
            }
            return this.ensureDeployed(datasets, db, timeoutSeconds);
        }
        return this.ensureDeployed(datasets, null, timeoutSeconds);
    }

    public List<DeployResult> ensureDeployed(List<Dataset> datasets, Database db, long timeoutSeconds) throws WAImportException {
        ArrayList<DeployResult> deployments = new ArrayList<DeployResult>(datasets.size());
        for (Dataset ds : datasets) {
            deployments.add(this.ensureDeployed(ds, db, timeoutSeconds));
        }
        return deployments;
    }

    /*
     * Exception decompiling
     */
    public DeployResult ensureDeployed(Dataset dataset, Database db, long timeoutSeconds) throws WAImportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Database findCommonDatabase(Tenant tenant, List<Dataset> datasets) throws WAImportException {
        if (datasets.isEmpty()) {
            return null;
        }
        HashMap<IONObjectId, Database> commonDatabases = new HashMap<IONObjectId, Database>();
        for (Database db : this.getReachableDatabases(tenant)) {
            commonDatabases.put(db.getId(), db);
        }
        for (Dataset ds : datasets) {
            List tables = this.storageService.listTables(tenant.getId(), null, ds.getId(), null, null, false, false);
            ArrayList<IONObjectId> databaseIds = new ArrayList<IONObjectId>();
            for (Table t : tables) {
                Database db = (Database)commonDatabases.get(t.getDatabaseId());
                if (null == db) continue;
                if (t.getVersion() != ds.getVersion()) {
                    LOGGER.warn("Table (name={}, _id={}) has inconsistent version compared to dataset (name={}, _id={}) - expected {}, but was {}", new Object[]{t.getTableName(), t.getId().getIdentifier(), ds.getName(), ds.getId().getIdentifier(), ds.getVersion(), t.getVersion()});
                    continue;
                }
                if (!this.storageService.checkTable(db, t.getSchemaName(), t.getTableName())) {
                    LOGGER.warn("Table (name={}, _id={}) is missing from database (name={}, _id={})", new Object[]{t.getTableName(), t.getId().getIdentifier(), db.getName(), db.getId().getIdentifier()});
                    continue;
                }
                databaseIds.add(t.getDatabaseId());
            }
            commonDatabases.keySet().retainAll(databaseIds);
            if (!commonDatabases.isEmpty()) continue;
            break;
        }
        if (commonDatabases.isEmpty()) {
            return null;
        }
        ArrayList<Database> candidates = new ArrayList<Database>(commonDatabases.size());
        for (Database db : commonDatabases.values()) {
            candidates.add(db);
        }
        int index = this.random.nextInt(candidates.size());
        return (Database)candidates.get(index);
    }

    DeployResult findDeployment(Dataset dataset, Database targetDb) throws WAImportException {
        if (dataset.isRepairNeeded()) {
            METRIC_RESOLVE_MISSES.count(1L);
            LOGGER.warn("Dataset (name={}, _id={}) is marked for repair", (Object)dataset.getName(), (Object)dataset.getId().getIdentifier());
            return null;
        }
        IONObjectId tenantId = ACSHelper.getCurrentTenantId();
        List candidateTables = this.storageService.listTables(tenantId, null != targetDb ? targetDb.getId() : null, dataset.getId(), null, null, false, false);
        Iterator iter = candidateTables.iterator();
        HashMap<IONObjectId, Database> dbCache = new HashMap<IONObjectId, Database>();
        while (iter.hasNext()) {
            Table t = (Table)iter.next();
            if (t.getVersion() != dataset.getVersion()) {
                LOGGER.warn("Table (name={}, _id={}) has inconsistent version compared to dataset (name={}, _id={}) - expected {}, but was {}", new Object[]{t.getTableName(), t.getId().getIdentifier(), dataset.getName(), dataset.getId().getIdentifier(), dataset.getVersion(), t.getVersion()});
                iter.remove();
                this.storageService.softDropTable(t);
                continue;
            }
            Database db = (Database)dbCache.get(t.getDatabaseId());
            if (null == db) {
                try {
                    db = this.storageService.getDatabase(t.getDatabaseId());
                    dbCache.put(db.getId(), db);
                }
                catch (WAStorageException.NoSuchObjectException ex) {
                    LOGGER.warn("Could not find database (_id={}) for table (name={}, _id={})", new Object[]{t.getDatabaseId().getIdentifier(), t.getTableName(), t.getId().getIdentifier()});
                    iter.remove();
                    this.storageService.softDropTable(t);
                    continue;
                }
            }
            if (!this.storageService.checkDatabase(db)) {
                LOGGER.warn("Database (name={}, _id={}) is unreachable", (Object)db.getName(), (Object)db.getId().getIdentifier());
                iter.remove();
                continue;
            }
            if (this.storageService.checkTable(db, t.getSchemaName(), t.getTableName())) continue;
            LOGGER.warn("Table (name={}, _id={}) is missing from database (name={}, _id={})", new Object[]{t.getTableName(), t.getId().getIdentifier(), db.getName(), db.getId().getIdentifier()});
            iter.remove();
            this.storageService.softDropTable(t);
        }
        if (candidateTables.isEmpty()) {
            LOGGER.warn("Could not find any tables deployed for dataset (name={}, _id={})", (Object)dataset.getName(), (Object)dataset.getId().getIdentifier());
            METRIC_RESOLVE_MISSES.count(1L);
            return null;
        }
        int index = this.random.nextInt(candidateTables.size());
        Table table = (Table)candidateTables.get(index);
        Database db = (Database)dbCache.get(table.getDatabaseId());
        DeployResult result = new DeployResult();
        result.setDataSource(this.importService.getDataSource(dataset.getDataSourceId()));
        result.setDataset(dataset);
        result.setDatabase(db);
        result.setTable(table);
        LOGGER.trace("Resolved table (name={}, _id={}) deployed to database (name={}, _id={}) for dataset (name={}, _id={})", new Object[]{table.getTableName(), table.getId().getIdentifier(), db.getName(), db.getId().getIdentifier(), dataset.getName(), dataset.getId().getIdentifier()});
        Date now = new Date();
        dataset.setLastAccessTime(now);
        table.setLastAccessTime(now);
        table.setLastValidatedTime(now);
        if (null != dataset.getId()) {
            try {
                ImportPersistence.getDatasetCollection((PersistenceService)this.ps).getDocumentCollection().update(dataset.getId(), new UpdateBuilder().set("last-access-time", (Object)dataset.getLastAccessTime()).toDocument());
            }
            catch (PersistenceException ex) {
                throw WAImportException.newBuilder().withCause((Throwable)ex).withMessage((IMessageKey)NeoImportError.NEO_IS_DEPLOY_UPDATE).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }
        if (null != table.getId()) {
            try {
                StoragePersistence.getTableCollection((PersistenceService)this.ps).getDocumentCollection().update(table.getId(), new UpdateBuilder().set("last-access-time", (Object)table.getLastAccessTime()).set("last-validated-time", (Object)table.getLastValidatedTime()).toDocument());
            }
            catch (PersistenceException ex) {
                throw WAImportException.newBuilder().withCause((Throwable)ex).withMessage((IMessageKey)NeoImportError.NEO_IS_TABLE_TIMESTAMP).withConditionCode(EImportMessageCode.INTERNAL_ERROR).build();
            }
        }
        METRIC_RESOLVE_HITS.count(1L);
        return result;
    }

    private Database[] getReachableDatabases(Tenant tenant) throws WAStorageException {
        String dbPool = null != tenant.getDatabasePool() ? tenant.getDatabasePool() : "default";
        List databases = this.storageService.listDatabases(null, dbPool, false);
        Iterator iter = databases.iterator();
        while (iter.hasNext()) {
            Database db = (Database)iter.next();
            try {
                if (!db.isDisabled() && this.storageService.checkDatabase(db)) continue;
                iter.remove();
            }
            catch (WAStorageException ex) {
                LOGGER.warn("Failed to determine if database ({}) is reachable", (Object)db.getName());
                iter.remove();
            }
        }
        return databases.toArray(new Database[databases.size()]);
    }

    private Tenant getCurrentTenant() throws WAImportException {
        try {
            return this.acs.getCurrentTenant();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_DEPLOY_TENANT).build();
        }
    }

    private void updateRepairNeeded(Dataset dataset, boolean isRepairNeeded) throws PersistenceException {
        IDocumentCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)this.ps).getDocumentCollection();
        datasetCol.update(dataset.getId(), new UpdateBuilder().set("repair-needed", (Object)isRepairNeeded).toDocument());
        dataset.setRepairNeeded(isRepairNeeded);
    }

    private Dataset readDatasetIfTouched(Dataset dataset) throws WAImportException {
        try {
            NobjectCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)this.ps);
            Dataset peak = (Dataset)datasetCol.get(dataset.getId(), new ProjectionBuilder().include(new String[]{"last-repair-time", "modified-time", "repair-needed", "version"}).excludeId().toDocument());
            if (peak != null) {
                boolean touched;
                boolean bl = touched = !new EqualsBuilder().append((Object)dataset.getLastRepairTime(), (Object)peak.getLastRepairTime()).append((Object)dataset.getModifiedTime(), (Object)peak.getModifiedTime()).append(dataset.isRepairNeeded(), peak.isRepairNeeded()).append(dataset.getVersion(), peak.getVersion()).isEquals();
                if (touched) {
                    return (Dataset)datasetCol.get(dataset.getId());
                }
                return dataset;
            }
            LOGGER.error("Dataset (name={}, _id={}) was removed during repair");
            throw WAImportException.newBuilder().withConditionCode(EImportMessageCode.INTERNAL_ERROR).withMessage((IMessageKey)NeoImportError.NEO_IS_DATASET_REMOVED).build();
        }
        catch (PersistenceException ex) {
            throw WAImportException.newBuilder().withCause((Throwable)ex).build();
        }
    }

    private void recordRepairFailure(Dataset dataset) throws PersistenceException {
        IDocumentCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)this.ps).getDocumentCollection();
        Date now = new Date();
        IONObject result = datasetCol.findOneAndUpdate(new QueryBuilder().idEqualTo(dataset.getId()).toDocument(), null, new UpdateBuilder().set("last-repair-time", (Object)now).inc("repair-failure-count", (Number)1).toDocument(), new ProjectionBuilder().include(new String[]{"repair-failure-count"}).toDocument(), true, false);
        if (null != result) {
            dataset.setRepairFailureCount(result.getInt("repair-failure-count", 0));
        } else {
            dataset.setRepairFailureCount(0);
        }
        dataset.setLastRepairTime(now);
    }

    private void recordRepairSuccess(Dataset dataset) throws PersistenceException {
        IDocumentCollection datasetCol = ImportPersistence.getDatasetCollection((PersistenceService)this.ps).getDocumentCollection();
        Date now = new Date();
        datasetCol.update(dataset.getId(), new UpdateBuilder().set("last-repair-time", (Object)now).set("repair-failure-count", (Object)0).set("repair-needed", (Object)false).toDocument());
        dataset.setLastRepairTime(now);
        dataset.setRepairFailureCount(0);
        dataset.setRepairNeeded(false);
    }

    private static String datasetsToString(List<Dataset> datasets) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < datasets.size(); ++i) {
            Dataset ds = datasets.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(name=").append(ds.getName()).append(", _id=").append(ds.getId().getIdentifier()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    private static long secondsSince(long startNanos) {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos);
    }

    private static long secondsRemaining(long startNanos, long maxSeconds) {
        return Math.max(0L, maxSeconds - DeploymentResolver.secondsSince(startNanos));
    }
}

