/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.DeployActionFactory;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TupleGenerator {
    private final TupleGeneratorContext mContext;
    private final List<IDeployAction> mDeployActions;
    private final ICDFRowCursor mCursor;

    public TupleGenerator(DeploymentPlan plan, IDataType[] expectedDataTypes, List<String> nullPlaceholders, long firstRowId, ICDFRowCursor cursor) throws IOException {
        this.mCursor = cursor;
        this.mContext = new TupleGeneratorContext(expectedDataTypes, nullPlaceholders, firstRowId);
        List deployNodes = plan.getDeployNodes();
        this.mDeployActions = new ArrayList<IDeployAction>(expectedDataTypes.length);
        for (Node node : deployNodes) {
            this.mDeployActions.add(DeployActionFactory.createAction(node));
        }
    }

    public IValue[] nextTuple() throws IOException {
        ICDFRow cdfRow = TupleGenerator.nextNonEmptyRow(this.mCursor);
        if (cdfRow != null) {
            this.mContext.setSourceRow(cdfRow);
            for (IDeployAction action : this.mDeployActions) {
                action.evaluate(this.mContext);
            }
            IValue[] tuple = this.mContext.getTupleValues();
            for (int i = 0; i < tuple.length; ++i) {
                if (null == tuple[i] || tuple[i].isNull()) continue;
                return tuple;
            }
        }
        return null;
    }

    private static ICDFRow nextNonEmptyRow(ICDFRowCursor cursor) throws IOException {
        ICDFRow cdfRow;
        do {
            if (cursor.next()) continue;
            return null;
        } while ((cdfRow = cursor.getRow()).isEmpty());
        return cdfRow;
    }
}

