/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy;

import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.extract.parser.BooleanParser;
import com.ibm.cognos.aurora.core.extract.parser.CurrencyParser;
import com.ibm.cognos.aurora.core.extract.parser.DateParser;
import com.ibm.cognos.aurora.core.extract.parser.NumberParser;
import com.ibm.cognos.aurora.core.extract.parser.PercentParser;
import com.ibm.cognos.aurora.core.extract.parser.TimeParser;
import com.ibm.cognos.aurora.core.extract.parser.TimestampParser;
import com.ibm.icu.util.ULocale;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import java.util.List;

public class TupleGeneratorContext {
    private final List<String> mNullPlaceholders;
    private final IValue[] mTupleValues;
    private final long mFirstRowId;
    private ICDFCell[] mSourceCells;
    private NumberParser mNumberParser;
    private CurrencyParser mCurrencyParser;
    private PercentParser mPercentParser;
    private BooleanParser mBooleanParser;
    private DateParser mDateParser;
    private TimeParser mTimeParser;
    private TimestampParser mTimestampParser;

    public TupleGeneratorContext(IDataType[] expectedDataTypes, List<String> nullPlaceholders, long firstRowId) {
        this.mNullPlaceholders = nullPlaceholders;
        this.mFirstRowId = firstRowId;
        this.mTupleValues = new IValue[expectedDataTypes.length];
        for (int i = 0; i < expectedDataTypes.length; ++i) {
            this.mTupleValues[i] = expectedDataTypes[i].newValue();
        }
    }

    public long getFirstRowId() {
        return this.mFirstRowId;
    }

    public ICDFCell[] getCells() {
        return this.mSourceCells;
    }

    public IValue[] getTupleValues() {
        return this.mTupleValues;
    }

    public boolean isNullPlaceholder(String str) {
        str = str.trim();
        for (String s : this.mNullPlaceholders) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public void assignTupleValue(int index, IValue value) {
        if (index < 0 || index >= this.mTupleValues.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.mTupleValues[index].assignFrom(value);
    }

    public void setSourceRow(ICDFRow row) {
        for (IValue value : this.mTupleValues) {
            value.setNull();
        }
        this.mSourceCells = row.getCells(null);
    }

    public BooleanParser getBooleanParser() {
        if (null == this.mBooleanParser) {
            this.mBooleanParser = new BooleanParser(ULocale.US);
        }
        return this.mBooleanParser;
    }

    public DateParser getDateParser() {
        if (null == this.mDateParser) {
            this.mDateParser = new DateParser(ULocale.US);
        }
        return this.mDateParser;
    }

    public TimeParser getTimeParser() {
        if (null == this.mTimeParser) {
            this.mTimeParser = new TimeParser(ULocale.US);
        }
        return this.mTimeParser;
    }

    public TimestampParser getTimestampParser() {
        if (null == this.mTimestampParser) {
            this.mTimestampParser = new TimestampParser(ULocale.US);
        }
        return this.mTimestampParser;
    }

    public CurrencyParser getCurrencyParser() {
        if (null == this.mCurrencyParser) {
            this.mCurrencyParser = new CurrencyParser(ULocale.US);
        }
        return this.mCurrencyParser;
    }

    public PercentParser getPercentParser() {
        if (null == this.mPercentParser) {
            this.mPercentParser = new PercentParser(ULocale.US);
        }
        return this.mPercentParser;
    }

    public NumberParser getNumberParser() {
        if (null == this.mNumberParser) {
            this.mNumberParser = new NumberParser(ULocale.US);
        }
        return this.mNumberParser;
    }
}

