/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.DeployActionFactory;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.deploy.action.TransformAction;
import com.ibm.neo.dataimport.nodel.Node;
import com.ibm.neo.util.Assertions;
import java.util.Date;
import java.util.TimeZone;

public class AddLocalTimezoneOffsetAction
extends TransformAction {
    private final IDeployAction mValueAction;
    private final TimeZone mLocalTimeZone;

    public AddLocalTimezoneOffsetAction(Node node) {
        super(node);
        Assertions.assertTrue((!node.getChildren().isEmpty() ? 1 : 0) != 0, (String)("The " + node.getName() + " node requires one child node."));
        this.mValueAction = DeployActionFactory.createAction((Node)node.getChildren().get(0));
        this.mLocalTimeZone = TimeZone.getDefault();
    }

    @Override
    public IValue evaluate(TupleGeneratorContext context) {
        IValue value = this.mValueAction.evaluate(context);
        if (value == null) {
            return null;
        }
        DateTimeValue sourceValue = (DateTimeValue)value;
        long sourceTimeInMillis = sourceValue.getTimeInMillis();
        int sourceOffset = sourceValue.getTimeZone().getOffset(sourceTimeInMillis);
        DateTimeValue dateTimeValue = (DateTimeValue)value.getType().newValue();
        dateTimeValue.setYear(sourceValue.getYear());
        dateTimeValue.setMonth(sourceValue.getMonth());
        dateTimeValue.setDay(sourceValue.getDay());
        dateTimeValue.setHour(sourceValue.getHour());
        dateTimeValue.setMinute(sourceValue.getMinute());
        dateTimeValue.setSecond(sourceValue.getSecond());
        dateTimeValue.setMillisecond(sourceValue.getMillisecond());
        dateTimeValue.setOK();
        int localOffset = this.mLocalTimeZone.getOffset(dateTimeValue.getTimeInMillis());
        dateTimeValue.set(new Date(sourceTimeInMillis + (long)sourceOffset - (long)localOffset));
        return dateTimeValue;
    }
}

