/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.DeployActionFactory;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.deploy.action.TransformAction;
import com.ibm.neo.dataimport.nodel.Node;
import com.ibm.neo.util.Assertions;

public class CleanseStringAction
extends TransformAction {
    private final IDeployAction mSource;
    private final StringBuilder mBuffer;

    public CleanseStringAction(Node node) {
        super(node);
        Assertions.assertTrue((!node.getChildren().isEmpty() ? 1 : 0) != 0, (String)("The " + node.getName() + " node requires one child node."));
        this.mSource = DeployActionFactory.createAction((Node)node.getChildren().get(0));
        this.mBuffer = new StringBuilder();
    }

    @Override
    public IValue evaluate(TupleGeneratorContext context) {
        IValue v = this.mSource.evaluate(context);
        if (null == v || !v.isOK()) {
            return v;
        }
        String str = v.stringValue();
        if (str.length() == 0) {
            return null;
        }
        this.mBuffer.setLength(0);
        this.mBuffer.ensureCapacity(str.length());
        block4: for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (chr <= '\u001f') {
                switch (chr) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': {
                        chr = ' ';
                        this.mBuffer.append(chr);
                        break;
                    }
                    case '\r': {
                        chr = ' ';
                        this.mBuffer.append(chr);
                        if (i + 1 >= str.length() || str.charAt(i + 1) != '\n') continue block4;
                        ++i;
                        break;
                    }
                }
                continue;
            }
            this.mBuffer.append(chr);
        }
        str = this.mBuffer.toString().trim();
        if (str.length() == 0) {
            return null;
        }
        return new StringValue(str);
    }
}

