/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.neo.dataimport.deploy.action.AddLocalTimezoneOffsetAction;
import com.ibm.neo.dataimport.deploy.action.CleanseStringAction;
import com.ibm.neo.dataimport.deploy.action.EDeployAction;
import com.ibm.neo.dataimport.deploy.action.GenerateDateFieldAction;
import com.ibm.neo.dataimport.deploy.action.GetTupleValueAction;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.deploy.action.NextRowIdAction;
import com.ibm.neo.dataimport.deploy.action.ReadCellValueAction;
import com.ibm.neo.dataimport.deploy.action.SetTupleValueAction;
import com.ibm.neo.dataimport.deploy.action.TruncateStringAction;
import com.ibm.neo.dataimport.nodel.Node;
import java.lang.reflect.Constructor;
import java.util.EnumMap;

public class DeployActionFactory {
    private static final EnumMap<EDeployAction, Constructor<? extends IDeployAction>> actionMap = new EnumMap(EDeployAction.class);

    public static IDeployAction createAction(Node actionNode) {
        EDeployAction deployActionEnum = EDeployAction.valueOf(actionNode.getName());
        Constructor<? extends IDeployAction> actionCtor = actionMap.get((Object)deployActionEnum);
        if (actionCtor == null) {
            return null;
        }
        try {
            return actionCtor.newInstance(actionNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        try {
            actionMap.put(EDeployAction.ReadCellValue, ReadCellValueAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.SetTupleValue, SetTupleValueAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.GetTupleValue, GetTupleValueAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.GenerateDateField, GenerateDateFieldAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.CleanseString, CleanseStringAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.TruncateString, TruncateStringAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.NextRowId, NextRowIdAction.class.getConstructor(Node.class));
            actionMap.put(EDeployAction.DeployAsLocalTz, AddLocalTimezoneOffsetAction.class.getConstructor(Node.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

