/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.neo.dataimport.EGeneratedDateField;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.DeployActionFactory;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.deploy.action.TransformAction;
import com.ibm.neo.dataimport.nodel.Node;
import com.ibm.neo.util.Assertions;
import java.util.EnumSet;
import java.util.Locale;

public class GenerateDateFieldAction
extends TransformAction {
    private final EGeneratedDateField mFieldType;
    private final IDeployAction mSourceDateValueAction;
    private static EnumSet<BaseDataType> DATE_TYPES = EnumSet.of(BaseDataType.DATE, BaseDataType.TIMESTAMP);
    private static final Locale DEFAULT_FORMAT_LOCALE = Locale.US;
    private static ThreadLocal<SimpleDateFormat> QUARTER_NAME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("QQQ", DEFAULT_FORMAT_LOCALE);
        }
    };
    private static ThreadLocal<SimpleDateFormat> MONTH_NAME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("MMMM", DEFAULT_FORMAT_LOCALE);
        }
    };
    private static ThreadLocal<SimpleDateFormat> WEEKDAY_NAME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEEE", DEFAULT_FORMAT_LOCALE);
        }
    };

    public GenerateDateFieldAction(Node node) {
        super(node);
        this.mFieldType = EGeneratedDateField.valueOf(node.getArguments().getString(0));
        Assertions.assertTrue((!node.getArguments().isEmpty() ? 1 : 0) != 0, (String)"A GenerateDateFieldAction needs a child node to provide a source date.");
        this.mSourceDateValueAction = DeployActionFactory.createAction((Node)node.getChildren().get(0));
    }

    @Override
    public IValue evaluate(TupleGeneratorContext context) {
        IValue childValue = this.mSourceDateValueAction.evaluate(context);
        BaseDataType childValueType = childValue.getType().getBaseType();
        Assertions.assertTrue((boolean)DATE_TYPES.contains(childValueType));
        Calendar sourceDate = ((DateTimeValue)childValue).getCalendar();
        switch (this.mFieldType) {
            case YEAR: {
                return ValueFactory.createInteger((int)sourceDate.get(1));
            }
            case QUARTER: {
                int quarterNumber = sourceDate.get(2) / 3 + 1;
                return ValueFactory.createInteger((int)quarterNumber);
            }
            case QUARTER_NAME: {
                String quarterName = QUARTER_NAME_FORMATTER.get().format((Object)sourceDate);
                return ValueFactory.createString((String)quarterName);
            }
            case MONTH: {
                int monthNumber = sourceDate.get(2) + 1;
                return ValueFactory.createInteger((int)monthNumber);
            }
            case MONTH_NAME: {
                String monthName = MONTH_NAME_FORMATTER.get().format((Object)sourceDate);
                return ValueFactory.createString((String)monthName);
            }
            case DAY_OF_MONTH: {
                return ValueFactory.createInteger((int)sourceDate.get(5));
            }
            case WEEKDAY: {
                return ValueFactory.createInteger((int)sourceDate.get(7));
            }
            case WEEKDAY_NAME: {
                String weekdayName = WEEKDAY_NAME_FORMATTER.get().format((Object)sourceDate);
                return ValueFactory.createString((String)weekdayName);
            }
        }
        throw new RuntimeException("Unknown EGeneratedDateField value: " + this.mFieldType.name());
    }
}

