/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.TransformAction;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.dataimport.nodel.FormatHints;
import com.ibm.neo.dataimport.nodel.Node;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import java.math.BigDecimal;
import java.util.Date;

public class ReadCellValueAction
extends TransformAction {
    private static final long MAX_DATE_MILLIS = 253402300799000L;
    private final int mCellIndex;
    private final EDataType mExpectedDataType;
    private final FormatHints mFormatHints;

    public ReadCellValueAction(Node node) {
        super(node);
        IONArray arguments = node.getArguments();
        this.mCellIndex = arguments.getInt(0);
        this.mExpectedDataType = arguments.size() > 1 && arguments.getString(1) != null ? EDataType.fromExternalName((String)arguments.getString(1)) : null;
        this.mFormatHints = arguments.size() > 2 ? (FormatHints)IONHelper.toPOJO((IONObject)arguments.getIONObject(2), FormatHints.class) : null;
    }

    @Override
    public IValue evaluate(TupleGeneratorContext context) {
        if (this.mCellIndex >= context.getCells().length) {
            return null;
        }
        ICDFCell cell = context.getCells()[this.mCellIndex];
        if (null == cell || cell.isNull()) {
            return null;
        }
        IValue cellValue = ReadCellValueAction.cell2Value(cell);
        if (null == cellValue || cellValue.isNull()) {
            return null;
        }
        if (cellValue.getType().isString()) {
            if (context.isNullPlaceholder(cellValue.stringValue())) {
                return null;
            }
            if (null != this.mExpectedDataType && EDataType.STRING != this.mExpectedDataType) {
                cellValue = this.string2Value(cellValue.stringValue(), context);
            }
        } else if (EDataType.STRING == this.mExpectedDataType) {
            cellValue = ValueFactory.createString((String)cellValue.stringValue());
        }
        return cellValue;
    }

    private IValue string2Value(String str, TupleGeneratorContext context) {
        ParseResult result = new ParseResult();
        switch (this.mExpectedDataType) {
            case STRING: 
            case CHAR: {
                return ValueFactory.createString((String)str);
            }
            case BOOLEAN: {
                context.getBooleanParser().parse(str.trim(), result);
                break;
            }
            case DATE: {
                context.getDateParser().parse(str.trim(), result);
                break;
            }
            case TIME: {
                context.getTimeParser().parse(str.trim(), result);
                break;
            }
            case TIMESTAMP: {
                context.getTimestampParser().parse(str.trim(), result);
                break;
            }
            case DECIMAL64: 
            case FLOAT64: 
            case FLOAT32: 
            case INT64: 
            case INT32: 
            case INT16: 
            case INT8: {
                if (null != this.mFormatHints) {
                    if (this.mFormatHints.hasCurrency()) {
                        context.getCurrencyParser().parse(str.trim(), result);
                        break;
                    }
                    if (this.mFormatHints.hasPercent()) {
                        context.getPercentParser().parse(str.trim(), result);
                        break;
                    }
                }
                context.getNumberParser().parse(str.trim(), result);
                break;
            }
        }
        IValue value = result.getValue();
        if (null != value && value.isOK()) {
            if (value.getType().isNumeric() && (Double.isInfinite(value.doubleValue()) || Double.isNaN(value.doubleValue()))) {
                return null;
            }
            if (value.getType().isTemporal() && value.longValue() > 253402300799000L) {
                return null;
            }
            return value;
        }
        return null;
    }

    private static IValue cell2Value(ICDFCell cell) {
        if (null == cell || cell.isNull()) {
            return null;
        }
        switch (cell.getDataType()) {
            case STRING: {
                return ValueFactory.createString((String)cell.stringValue());
            }
            case CHAR: {
                return ValueFactory.createString((String)Character.toString(cell.charValue()));
            }
            case BOOLEAN: {
                return ValueFactory.createBoolean((boolean)cell.booleanValue());
            }
            case DATE: {
                if (cell.longValue() > 253402300799000L) {
                    return null;
                }
                return ValueFactory.createDate((Date)cell.dateValue());
            }
            case TIME: {
                if (cell.longValue() > 253402300799000L) {
                    return null;
                }
                return ValueFactory.createTime((Date)cell.dateValue());
            }
            case TIMESTAMP: {
                if (cell.longValue() > 253402300799000L) {
                    return null;
                }
                return ValueFactory.createTimestamp((Date)cell.dateValue());
            }
            case INT8: {
                return ValueFactory.createInteger((int)cell.byteValue());
            }
            case INT16: {
                return ValueFactory.createInteger((int)cell.shortValue());
            }
            case INT32: {
                return ValueFactory.createInteger((int)cell.intValue());
            }
            case INT64: {
                return ValueFactory.createLong((long)cell.longValue());
            }
            case FLOAT32: {
                if (Float.isInfinite(cell.floatValue()) || Float.isNaN(cell.floatValue())) {
                    return null;
                }
                return ValueFactory.createFloat((float)cell.floatValue());
            }
            case FLOAT64: {
                if (Double.isInfinite(cell.doubleValue()) || Double.isNaN(cell.doubleValue())) {
                    return null;
                }
                return ValueFactory.createDouble((double)cell.doubleValue());
            }
            case DECIMAL64: {
                return ValueFactory.createDecimal((BigDecimal)cell.bigDecimalValue());
            }
        }
        throw new RuntimeException("Unsupported cell type: " + cell.getDataType());
    }
}

