/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.deploy.action;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.neo.dataimport.deploy.TupleGeneratorContext;
import com.ibm.neo.dataimport.deploy.action.DeployActionFactory;
import com.ibm.neo.dataimport.deploy.action.IDeployAction;
import com.ibm.neo.dataimport.deploy.action.TransformAction;
import com.ibm.neo.dataimport.nodel.Node;
import com.ibm.neo.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateStringAction
extends TransformAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TruncateStringAction.class);
    private static final int MAX_NAG_COUNT = 10;
    private final IDeployAction mSource;
    private final int mMaxLength;
    private int mTruncationNagCount = 0;

    public TruncateStringAction(Node node) {
        super(node);
        Assertions.assertTrue((node.getArguments().size() == 1 ? 1 : 0) != 0, (String)("The " + node.getName() + " node requires exactly one argument."));
        Assertions.assertTrue((!node.getChildren().isEmpty() ? 1 : 0) != 0, (String)("The " + node.getName() + " node requires one child node."));
        this.mSource = DeployActionFactory.createAction((Node)node.getChildren().get(0));
        this.mMaxLength = node.getArguments().getInt(0);
    }

    @Override
    public IValue evaluate(TupleGeneratorContext context) {
        IValue v = this.mSource.evaluate(context);
        if (null == v || !v.isOK()) {
            return v;
        }
        Assertions.assertTrue((boolean)v.getType().isString(), (String)"TruncateStringAction can only evaluate strings.");
        String str = v.stringValue();
        if (str.length() > this.mMaxLength) {
            String truncated = str.substring(0, this.mMaxLength);
            if (this.mTruncationNagCount < 10) {
                ++this.mTruncationNagCount;
                LOGGER.warn("Truncating string '{}' to '{}'", (Object)str, (Object)truncated);
            }
            return new StringValue(truncated);
        }
        return v;
    }
}

