/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.file;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.blobstore.AbstractBlob;
import com.ibm.neo.blobstore.AbstractBlobContainer;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.dataimport.file.FileBlobContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Set;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileBlob
extends AbstractBlob {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBlob.class);
    private final File mBlobFile;
    private final File mMetaFile;
    private final JSONObject mMetadata;

    FileBlob(FileBlobContainer container, File blobFile, File metaFile, String filename, String contentType, boolean isCompressed, boolean isEncrypted) throws BlobStoreException {
        super((AbstractBlobContainer)container, blobFile.getName(), filename, contentType, blobFile.length(), new Date(blobFile.lastModified()), isCompressed, isEncrypted);
        this.mBlobFile = blobFile;
        this.mMetaFile = metaFile;
        this.mMetadata = this.readMetadata();
    }

    public boolean exists() throws BlobStoreException {
        return this.mBlobFile.exists();
    }

    public long getContentLength() {
        if (this.mBlobFile.exists()) {
            return this.mBlobFile.length();
        }
        return 0L;
    }

    public Set<String> getMetadataKeys() throws BlobStoreException {
        return this.mMetadata.keySet();
    }

    public Object getMetadataValue(String key) throws BlobStoreException {
        Object value = this.mMetadata.get((Object)key);
        if (value instanceof JSONObject) {
            JSONObject jobj = (JSONObject)value;
            if (jobj.containsKey((Object)"$date")) {
                return FileBlob.parseISO8601Timestamp((String)((String)jobj.get((Object)"$date")));
            }
            throw new BlobStoreException("Unexpected JSON Object: " + jobj.toString());
        }
        return value;
    }

    public void setMetadataValue(String key, Object value) throws BlobStoreException {
        if (key.equals("compressed")) {
            throw new IllegalArgumentException("Metadata key ('compressed') is reserved for internal use only");
        }
        if (key.equals("encrypted")) {
            throw new IllegalArgumentException("Metadata key ('encrypted') is reserved for internal use only");
        }
        if (value instanceof Date) {
            JSONObject dateObj = new JSONObject();
            dateObj.put((Object)"$date", (Object)FileBlob.formatISO8601Timestamp((Date)((Date)value)));
            this.mMetadata.put((Object)key, (Object)dateObj);
        } else {
            this.mMetadata.put((Object)key, value);
        }
    }

    public void saveMetadata() throws BlobStoreException {
        this.writeMetadata(this.mMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open() throws BlobStoreException, IOException {
        if (!this.exists()) {
            throw new BlobStoreException.BlobNotFound(this.getContainer().getName(), this.getKey());
        }
        InputStream in = new FileInputStream(this.mBlobFile);
        boolean closeStream = true;
        try {
            if (this.isEncrypted()) {
                if (!this.getCrypto().isEnabled()) {
                    throw new BlobStoreException.CryptoNotSupported();
                }
                try {
                    in = this.getCrypto().decrypt(in);
                }
                catch (CryptoException ex) {
                    LOGGER.error("Failed to create decryption stream", (Throwable)ex);
                    throw new BlobStoreException("Failed to create decryption stream", (Throwable)ex);
                }
            }
            if (this.isCompressed()) {
                in = new GzipCompressorInputStream(in);
            }
            closeStream = false;
            FileInputStream fileInputStream = in;
            return fileInputStream;
        }
        finally {
            if (closeStream) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public void remove() throws BlobStoreException {
        if (this.mBlobFile.exists()) {
            try {
                FileUtils.forceDelete((File)this.mBlobFile);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)this.mBlobFile);
            }
        }
        if (this.mMetaFile.exists()) {
            try {
                FileUtils.forceDelete((File)this.mMetaFile);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)this.mMetaFile);
            }
        }
        this.mMetadata.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject readMetadata() throws BlobStoreException {
        JSONObject jSONObject;
        if (!this.mMetaFile.exists()) return new JSONObject();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.mMetaFile), "UTF-8");
        try {
            jSONObject = JSONObject.parse((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new BlobStoreException("Failed to read metadata", (Throwable)ex);
            }
        }
        ((Reader)reader).close();
        return jSONObject;
    }

    private void writeMetadata(JSONObject metadata) throws BlobStoreException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mMetaFile), "UTF-8");){
            metadata.serialize((Writer)writer);
        }
        catch (IOException ex) {
            throw new BlobStoreException("Failed to write metadata", (Throwable)ex);
        }
    }
}

