/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FileResource {
    private final File mPhysicalFile;
    private final File mLogicalFile;
    private String mContentType;

    public FileResource(File physicalFile, File logicalFile, String contentType) {
        this.mPhysicalFile = physicalFile;
        this.mLogicalFile = logicalFile;
        this.mContentType = contentType;
    }

    public File getPhysicalFile() {
        return this.mPhysicalFile;
    }

    public File getLogicalFile() {
        return this.mLogicalFile;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public String getName() {
        return this.mLogicalFile.getName();
    }

    public String getPath() {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)this.mLogicalFile.getPath()));
    }

    public String getParent() {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)this.mLogicalFile.getParent()));
    }

    public long length() {
        return this.mPhysicalFile.length();
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.mPhysicalFile);
    }

    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.mPhysicalFile);
    }

    public void deleteQuietly() {
        FileUtils.deleteQuietly((File)this.mPhysicalFile);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("logical", (Object)this.mLogicalFile).append("physical", (Object)this.mPhysicalFile).append("content", (Object)this.mContentType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileResource)) {
            return false;
        }
        FileResource other = (FileResource)o;
        return new EqualsBuilder().append((Object)this.mLogicalFile, (Object)other.mLogicalFile).append((Object)this.mPhysicalFile, (Object)other.mPhysicalFile).append((Object)this.mContentType, (Object)other.mContentType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mLogicalFile).append((Object)this.mPhysicalFile).append((Object)this.mContentType).toHashCode();
    }
}

